/*
 * Decompiled with CFR 0.152.
 */
package bindead.environment.abi;

import bindead.analyses.ProgramAddress;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.platform.Platform;
import java.util.List;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;
import javalx.numeric.Range;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public abstract class ABI {
    private static final String tempReg = "tmpReg_" + ABI.class.getSimpleName();
    private final Platform platform;
    private final int archSize;

    public ABI(Platform platform) {
        this.platform = platform;
        this.archSize = platform.defaultArchitectureSize();
    }

    protected String sub(String targetReg, String sourceReg, int value) {
        return String.format("sub.%d %s, %s, %d", this.archSize, targetReg, sourceReg, value);
    }

    protected String add(String targetReg, String sourceReg, int value) {
        return String.format("add.%d %s, %s, %d", this.archSize, targetReg, sourceReg, value);
    }

    protected String load(String targetReg, String sourceReg) {
        return String.format("load.%d.%d %s, %s", this.archSize, this.archSize, targetReg, sourceReg);
    }

    protected String store(String addressReg, long value) {
        return String.format("store.%d.%d %s, %s", this.archSize, this.archSize, addressReg, value);
    }

    protected String mov(String targetReg, String sourceReg) {
        return String.format("mov.%d %s, %s", this.archSize, targetReg, sourceReg);
    }

    protected String call(long address) {
        return String.format("call.%d %s", this.archSize, address);
    }

    protected String ret(String targetRegister) {
        return String.format("return.%d %s", this.archSize, targetRegister);
    }

    protected Range getValueOf(String register, RootDomain<?> domainState) {
        return domainState.queryRange(MemVar.getVarOrFresh(register), FiniteRange.of(0L, (long)(this.archSize - 1)));
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public <D extends RootDomain<D>> D incStackPointer(D state) {
        int stackCellSizeInBytes = this.archSize / 8;
        String sp = this.getPlatform().getStackPointer();
        return (D)((RootDomain)state.eval(this.add(sp, sp, stackCellSizeInBytes)));
    }

    public <D extends RootDomain<D>> D decStackPointer(D state) {
        int stackCellSizeInBytes = this.archSize / 8;
        String sp = this.getPlatform().getStackPointer();
        return (D)((RootDomain)state.eval(this.sub(sp, sp, stackCellSizeInBytes)));
    }

    public <D extends RootDomain<D>> D setInstructionPointer(D state, long pcValue) {
        state = (RootDomain)state.eval(String.format("mov.%d %s, %d", this.archSize, this.platform.getInstructionPointer(), pcValue));
        return state;
    }

    public abstract RReilAddr getReturnAddress(RootDomain<?> var1);

    public abstract Range getFunctionParameterValue(int var1, RootDomain<?> var2);

    public abstract <D extends RootDomain<D>> D assignFunctionParameterToRegister(int var1, String var2, D var3);

    public abstract <D extends RootDomain<D>> D setRegisterAsReturnValue(String var1, D var2);

    public abstract Rhs.Rvar getReturnParameterAllocation();

    public Range getCurrentStackOffset(RootDomain<?> domainState) {
        return domainState.queryRange(this.getPlatform().getRegisterAsVariable(this.getPlatform().getStackPointer()));
    }

    public Range getValueFromStack(int offset, RootDomain<?> domainState) {
        int stackCellSizeInBytes = this.archSize / 8;
        String sp = this.getPlatform().getStackPointer();
        RootDomain state = domainState;
        String[] insns = new String[]{this.sub(sp, sp, stackCellSizeInBytes * offset), this.load(tempReg, sp)};
        state = (RootDomain)state.eval(insns);
        return this.getValueOf(tempReg, state);
    }

    public <D extends RootDomain<D>> D writeAnalysisStartStackCanary(RReilAddr startAddress, long stackCanary, D domainState) {
        Object state = domainState;
        String sp = this.getPlatform().getStackPointer();
        state = this.decStackPointer(state);
        state = (RootDomain)state.eval(this.store(sp, stackCanary));
        ProgramAddress dummyPoint = new ProgramAddress(RReilAddr.ZERO);
        ProgramAddress canaryPoint = new ProgramAddress(RReilAddr.valueOf(stackCanary));
        List<P2<RReilAddr, D>> result = ABI.evalBranch(state, this.call(startAddress.base()), dummyPoint, canaryPoint);
        assert (result.size() == 1);
        state = result.get(0)._2();
        return state;
    }

    public <D extends RootDomain<D>> D evalReturn(D domainState) {
        Object state = domainState;
        String sp = this.getPlatform().getStackPointer();
        state = (RootDomain)state.eval(this.load(tempReg, sp));
        state = this.incStackPointer(state);
        ProgramAddress dummyPoint = new ProgramAddress(RReilAddr.ZERO);
        List<P2<RReilAddr, D>> result = ABI.evalBranch(state, this.ret(tempReg), dummyPoint, dummyPoint);
        assert (result.size() == 1);
        state = result.get(0)._2();
        return state;
    }

    public abstract List<String> getSyscallInputRegisterNames();

    public abstract String getSyscallNrRegisterName();

    public abstract String getSyscallReturnRegisterName();

    private static final <D extends RootDomain<D>> List<P2<RReilAddr, D>> evalBranch(D state, String instruction, ProgramPoint current, ProgramPoint next) {
        RReil rreilInstruction = RReil.from(instruction);
        if (!(rreilInstruction instanceof RReil.Branch)) {
            throw new UnsupportedOperationException("Instruction not applicable to this eval on the state " + rreilInstruction);
        }
        RReil.Branch branch = (RReil.Branch)rreilInstruction;
        return state.eval(branch, current, next);
    }
}

