/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.thresholds;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.FoldMap;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.widening.thresholds.Threshold;
import bindead.domains.widening.thresholds.ThresholdsWideningProperties;
import bindead.domains.widening.thresholds.ThresholdsWideningState;
import bindead.domains.widening.thresholds.ThresholdsWideningStateBuilder;
import java.util.Set;
import javalx.data.Option;
import javalx.data.products.P2;

public class ThresholdsWidening<D extends ZenoDomain<D>>
extends ZenoFunctor<ThresholdsWideningState, D, ThresholdsWidening<D>> {
    public static final String NAME = "THRESHOLDSWIDENING";
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGWIDENING;
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGTESTS;
    private final boolean DEBUGOTHER;

    public ThresholdsWidening(D child) {
        super(NAME, ThresholdsWideningState.EMPTY, child);
        this.DEBUGBINARIES = ThresholdsWideningProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGWIDENING = ThresholdsWideningProperties.INSTANCE.debugWidening.isTrue();
        this.DEBUGASSIGN = ThresholdsWideningProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGTESTS = ThresholdsWideningProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGOTHER = ThresholdsWideningProperties.INSTANCE.debugOther.isTrue();
    }

    private ThresholdsWidening(ThresholdsWideningState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGBINARIES = ThresholdsWideningProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGWIDENING = ThresholdsWideningProperties.INSTANCE.debugWidening.isTrue();
        this.DEBUGASSIGN = ThresholdsWideningProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGTESTS = ThresholdsWideningProperties.INSTANCE.debugTests.isTrue();
        this.DEBUGOTHER = ThresholdsWideningProperties.INSTANCE.debugOther.isTrue();
    }

    @Override
    public ThresholdsWidening<D> build(ThresholdsWideningState state, D childState) {
        return new ThresholdsWidening<D>(state, childState);
    }

    @Override
    public ThresholdsWidening<D> eval(Zeno.Assign stmt) {
        ThresholdsWideningStateBuilder<ZenoDomain> builder = new ThresholdsWideningStateBuilder<ZenoDomain>((ThresholdsWideningState)this.state);
        Option<ProgramPoint> location = this.getContext().getLocation();
        if (stmt.getRhs() instanceof Zeno.Rlin && location.isSome()) {
            Zeno.Rlin rhs = (Zeno.Rlin)stmt.getRhs();
            builder.applyAffineTransformation(stmt.getLhs().getId(), rhs, (ZenoDomain)this.childState, location);
        } else {
            builder.removeThresholdsContaining(stmt.getLhs().getId(), (ZenoDomain)this.childState, location);
        }
        if (this.DEBUGASSIGN) {
            System.out.println();
            System.out.println(this.name + ":");
            System.out.println("  evaluating assign: " + stmt);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.eval(stmt);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public ThresholdsWidening<D> eval(Zeno.Test stmt) {
        ThresholdsWideningStateBuilder<ZenoDomain> builder = new ThresholdsWideningStateBuilder<ZenoDomain>((ThresholdsWideningState)this.state);
        Option<ProgramPoint> location = this.getContext().getLocation();
        ZenoDomain newChildState = builder.collectThresholds(location, stmt, (ZenoDomain)this.childState);
        if (this.DEBUGTESTS) {
            System.out.println();
            System.out.println(this.name + ": ");
            System.out.println("  evaluating test: " + stmt);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public ThresholdsWidening<D> project(VarSet vars) {
        ThresholdsWideningStateBuilder<ZenoDomain> builder = new ThresholdsWideningStateBuilder<ZenoDomain>((ThresholdsWideningState)this.state);
        Option<ProgramPoint> location = this.getContext().getLocation();
        for (NumVar variable : vars) {
            builder.removeThresholdsContaining(variable, (ZenoDomain)this.childState, location);
        }
        if (this.DEBUGOTHER) {
            System.out.println();
            System.out.println(this.name + ":");
            System.out.println("  project: " + vars);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public ThresholdsWidening<D> substitute(NumVar x, NumVar y) {
        ThresholdsWideningStateBuilder builder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)this.state);
        builder.substitute(x, y);
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public ThresholdsWidening<D> expand(FoldMap vars) {
        ThresholdsWideningStateBuilder builder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)this.state);
        builder.expand(vars);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).expand(vars);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public ThresholdsWidening<D> fold(FoldMap vars) {
        ThresholdsWideningStateBuilder builder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)this.state);
        builder.fold(vars);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).fold(vars);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public ThresholdsWidening<D> copyAndPaste(VarSet vars, ThresholdsWidening<D> from) {
        ThresholdsWideningStateBuilder builder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)this.state);
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(vars, (Summarization)((Object)from.childState));
        builder.copyAndPaste(vars, (ThresholdsWideningState)from.state);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public ThresholdsWidening<D> widen(ThresholdsWidening<D> other) {
        ThresholdsWideningStateBuilder<ZenoDomain> builder = new ThresholdsWideningStateBuilder<ZenoDomain>((ThresholdsWideningState)this.state);
        ThresholdsWideningStateBuilder otherBuilder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)other.state);
        builder.mergeThresholds((ZenoDomain)this.childState, (ZenoDomain)other.childState, otherBuilder);
        ZenoDomain widenedChildState = (ZenoDomain)((ZenoDomain)this.childState).widen(other.childState);
        Option<ProgramPoint> location = other.getContext().getLocation();
        P2<ZenoDomain, Set<Threshold>> result = builder.applyNarrowing(widenedChildState, location);
        ZenoDomain narrowedChildState = result._1();
        if (this.DEBUGWIDENING) {
            System.out.println();
            System.out.println(this.name + " (widening)@" + location + ": ");
            System.out.println(StringHelpers.indentMultiline("  widened-child:  ", widenedChildState.toString()) + "\n");
            System.out.println("  applied narrowing tests:  " + result._2());
            System.out.println(StringHelpers.indentMultiline("  narrowed-child: ", narrowedChildState.toString()) + "\n");
        }
        builder.removeNonRedundantThresholds(narrowedChildState);
        return this.build(builder.build(), (D)narrowedChildState);
    }

    @Override
    public ThresholdsWidening<D> join(ThresholdsWidening<D> other) {
        ThresholdsWideningStateBuilder<ZenoDomain> builder = new ThresholdsWideningStateBuilder<ZenoDomain>((ThresholdsWideningState)this.state);
        ThresholdsWideningStateBuilder otherBuilder = new ThresholdsWideningStateBuilder((ThresholdsWideningState)other.state);
        builder.mergeThresholds((ZenoDomain)this.childState, (ZenoDomain)other.childState, otherBuilder);
        if (this.DEBUGBINARIES) {
            System.out.println();
            System.out.println(this.name + " (join): ");
            System.out.println("  fst: " + this.state);
            System.out.println("  snd: " + other.state);
            System.out.println("  join: " + builder.build());
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        builder.removeNonRedundantThresholds(newChildState);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public boolean subsetOrEqual(ThresholdsWidening<D> other) {
        return ((ZenoDomain)this.childState).subsetOrEqual(other.childState);
    }
}

