/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.oldthresholds;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.widening.oldthresholds.Threshold;
import bindead.domains.widening.oldthresholds.ThresholdsWideningState;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import com.google.common.collect.HashMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.persistentcollections.AVLSet;

class ThresholdsWideningStateBuilder<D extends ZenoDomain<D>>
extends ZenoStateBuilder {
    private static ZenoFactory zeno = ZenoFactory.getInstance();
    private ThresholdsWideningState.MutableState thresholds;

    public ThresholdsWideningStateBuilder(ThresholdsWideningState state) {
        this.thresholds = state.mutableCopy();
    }

    public ThresholdsWideningState build() {
        return this.thresholds.immutableCopy();
    }

    protected D collectThresholds(Option<ProgramPoint> currentLocation, Zeno.Test test, D state) {
        D newState;
        if (currentLocation.isNone()) {
            return state.eval(test);
        }
        if (ZenoTestHelper.isTautologyReportUnreachable(test)) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Thresholds swallows test: " + test);
            }
            return state;
        }
        if (test.getOperator() == Zeno.ZenoTestOp.NotEqualToZero || test.getOperator() == Zeno.ZenoTestOp.EqualToZero) {
            if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
                System.out.println("Thresholds splits test: " + test);
            }
            P2<Zeno.Test, Zeno.Test> tests = test.splitEquality();
            this.collect(currentLocation, tests._1(), state);
            this.collect(currentLocation, tests._2(), state);
            return state.eval(test);
        }
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Thresholds test: " + test);
        }
        if ((newState = this.collect(currentLocation, test, state)) != null) {
            return newState;
        }
        return state.eval(test);
    }

    private static boolean isInterestingAsThreshold(Zeno.Test test) {
        for (NumVar var : test.getVars()) {
            if (var.isFlag()) continue;
            return true;
        }
        return false;
    }

    private D collect(Option<ProgramPoint> currentLocation, Zeno.Test test, D state) {
        assert (test.getOperator() != Zeno.ZenoTestOp.NotEqualToZero && test.getOperator() != Zeno.ZenoTestOp.EqualToZero);
        if (!ThresholdsWideningStateBuilder.isInterestingAsThreshold(test)) {
            return null;
        }
        Threshold threshold = new Threshold(currentLocation.get(), test);
        if (this.thresholds.contains(threshold.getOrigin()) && this.thresholds.isApplied(threshold.getOrigin()) || this.thresholds.containsAnyAppliedFrom(currentLocation.get())) {
            return null;
        }
        P2<Boolean, D> result = this.isRedundant(test, state);
        if (result._1().booleanValue()) {
            this.thresholds.add(threshold);
        }
        return (D)((ZenoDomain)result._2());
    }

    private P2<Boolean, D> isRedundant(Zeno.Test test, D state) {
        try {
            Object newState = state.eval(test);
            boolean redundant = state.subsetOrEqual(newState);
            return P2.tuple2(redundant, newState);
        }
        catch (Unreachable _) {
            return P2.tuple2(false, null);
        }
    }

    private boolean isRedundantOld(Zeno.Test test, D state) {
        Zeno.Test opposingTest = test.not();
        try {
            state.eval(opposingTest);
        }
        catch (Unreachable _) {
            return true;
        }
        return false;
    }

    protected void removeThresholdsContaining(NumVar var, D state) {
        AVLSet<Substitution> subsititions = ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, state);
        if (!subsititions.isEmpty()) {
            this.applySubstitution(var, subsititions.getMin().get());
        }
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            VarSet vars = lin.getVars();
            if (!vars.contains(var)) continue;
            this.thresholds.remove(threshold);
        }
    }

    protected void expand(FoldMap pairs) {
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            Linear renamed = lin.renameVar(pairs);
            if (renamed == null) continue;
            Zeno.Test newTest = zeno.comparison(renamed, test.getOperator());
            this.thresholds.add(threshold.withTest(newTest), this.thresholds.getAppliedPoints(threshold));
        }
    }

    protected void fold(FoldMap pairs) {
        HashSet<Threshold> permanentSet = new HashSet<Threshold>();
        HashSet<Threshold> ephemeralSet = new HashSet<Threshold>();
        ThresholdsWideningState.MutableState addedSet = ThresholdsWideningState.EMPTY.mutableCopy();
        HashSet<Threshold> removeSet = new HashSet<Threshold>();
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            VarSet vars = lin.getVars();
            boolean hasEphemeral = false;
            boolean hasPermanent = false;
            for (VarPair pair : pairs) {
                if (vars.contains((NumVar)pair.getEphemeral())) {
                    hasEphemeral = true;
                }
                if (!vars.contains((NumVar)pair.getPermanent())) continue;
                hasPermanent = true;
            }
            if (hasEphemeral || hasPermanent) {
                removeSet.add(threshold);
            }
            if (hasEphemeral && hasPermanent) continue;
            if (hasPermanent) {
                permanentSet.add(threshold);
                addedSet.add(threshold, this.thresholds.getAppliedPoints(threshold));
            }
            if (!hasEphemeral) continue;
            Zeno.Test newTest = zeno.comparison(test.getExpr().renameVar(pairs), test.getOperator());
            Threshold newThreshold = threshold.withTest(newTest);
            ephemeralSet.add(newThreshold);
            addedSet.add(newThreshold, this.thresholds.getAppliedPoints(threshold));
        }
        for (Threshold threshold : removeSet) {
            this.thresholds.remove(threshold);
        }
        permanentSet.retainAll(ephemeralSet);
        for (Threshold threshold : permanentSet) {
            this.thresholds.add(threshold, addedSet.getAppliedPoints(threshold));
        }
    }

    protected void copyAndPaste(VarSet vars, ThresholdsWideningState otherState) {
        ThresholdsWideningStateBuilder<D> otherBuilder = new ThresholdsWideningStateBuilder<D>(otherState);
        for (Threshold threshold : otherBuilder.thresholds) {
            Zeno.Test test = threshold.getTest();
            if (!vars.containsAll(test.getExpr().getVars())) continue;
            this.thresholds.add(threshold, otherBuilder.thresholds.getAppliedPoints(threshold));
        }
    }

    protected void substitute(NumVar x, NumVar y) {
        Substitution sigma = new Substitution(x, Linear.linear(y), Bound.ONE);
        this.applySubstitution(x, sigma);
    }

    private void applySubstitution(NumVar var, Substitution sigma) {
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            VarSet vars = test.getVars();
            if (!vars.contains(var)) continue;
            Zeno.Test newTest = test.applySubstitution(sigma);
            if (ZenoTestHelper.isTautology(newTest)) {
                this.thresholds.remove(threshold);
                continue;
            }
            this.thresholds.substitute(threshold, threshold.withTest(newTest));
        }
    }

    protected void applyAffineTransformation(Linear.Divisor d, NumVar var, Linear rhs, D state) {
        if (!rhs.getCoeff(var).isZero()) {
            Substitution subst = Substitution.invertingSubstitution(rhs, d.get(), var);
            this.applySubstitution(var, subst);
        } else {
            Linear newEq = rhs.subTerm(d.get(), var);
            newEq = newEq.toEquality();
            this.removeThresholdsContaining(var, state);
            this.generateNewPredicates(newEq);
        }
    }

    private static AVLSet<Substitution> generateSubstitutionsFor(NumVar var, QueryChannel child) {
        if (child == null) {
            return AVLSet.empty();
        }
        SetOfEquations equalities = child.queryEqualities(var);
        return ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, equalities);
    }

    private static AVLSet<Substitution> generateSubstitutionsFor(NumVar var, SetOfEquations equalities) {
        AVLSet<Substitution> substitutions = AVLSet.empty();
        if (equalities.isEmpty()) {
            return AVLSet.empty();
        }
        for (Linear equality : equalities) {
            substitutions = substitutions.add(equality.genSubstitution(var));
        }
        return substitutions;
    }

    private void generateNewPredicates(Linear newEq) {
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            Linear lin = test.getExpr();
            VarSet vars = lin.getVars();
            for (NumVar var : vars) {
                Substitution sigma = newEq.genSubstitutionOrNull(var);
                if (sigma == null) continue;
                Zeno.Test newTest = zeno.comparison(lin.applySubstitution(sigma), test.getOperator());
                if (!this.thresholds.contains(threshold)) continue;
                this.thresholds.substitute(threshold, threshold.withTest(newTest));
            }
        }
    }

    protected P3<D, Threshold, Set<Threshold>> applyNarrowing(D state, Option<ProgramPoint> point) {
        Set<Threshold> nonRedundant = this.getNonRedundantThresholds(state);
        Set<Threshold> unconsumed = this.getUnconsumedThresholds(nonRedundant, point);
        if (unconsumed.isEmpty()) {
            return P3.tuple3(state, null, Collections.emptySet());
        }
        D narrowedState = this.applyThresholds(unconsumed, state);
        Threshold smallestTest = this.getSmallestThreshold(unconsumed, narrowedState, point);
        this.markApplied(smallestTest, point);
        this.removeNonRedundantThresholds(narrowedState);
        return P3.tuple3(narrowedState, smallestTest, unconsumed);
    }

    private Threshold getSmallestThreshold(Set<Threshold> candidates, D state, Option<ProgramPoint> point) {
        assert (!candidates.isEmpty());
        HashMultimap<BigInt, Threshold> distances = HashMultimap.create();
        BigInt minDistance = null;
        for (Threshold threshold : candidates) {
            Zeno.Test test = threshold.getTest();
            assert (test.getOperator() != Zeno.ZenoTestOp.NotEqualToZero && test.getOperator() != Zeno.ZenoTestOp.EqualToZero);
            Bound distanceOfTestToState = state.queryRange(test.getExpr()).convexHull().high();
            if (!distanceOfTestToState.isFinite()) {
                this.markApplied(threshold, point);
                continue;
            }
            BigInt distance = distanceOfTestToState.asInteger().abs();
            if (!distance.equals(minDistance = minDistance == null ? distance : minDistance.min(distance))) continue;
            distances.put(distance, threshold);
        }
        if (distances.isEmpty()) {
            return candidates.iterator().next();
        }
        return (Threshold)distances.get(minDistance).iterator().next();
    }

    private Set<Threshold> getUnconsumedThresholds(Set<Threshold> candidates, Option<ProgramPoint> point) {
        if (point.isNone() || candidates.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Threshold> unconsumed = new HashSet<Threshold>();
        for (Threshold threshold : candidates) {
            if (this.thresholds.isAppliedAt(threshold, point.get())) continue;
            unconsumed.add(threshold);
        }
        return unconsumed;
    }

    private void markApplied(Threshold smallestTest, Option<ProgramPoint> point) {
        this.thresholds.markAppliedAt(smallestTest, point.getOrNull());
    }

    private Set<Threshold> getNonRedundantThresholds(D state) {
        HashSet<Threshold> nonRedundant = new HashSet<Threshold>();
        for (Threshold threshold : this.thresholds) {
            Zeno.Test test = threshold.getTest();
            if (this.isRedundant(test, state)._1().booleanValue()) continue;
            nonRedundant.add(threshold);
        }
        return nonRedundant;
    }

    protected void removeNonRedundantThresholds(D state) {
        Set<Threshold> nonRedundant = this.getNonRedundantThresholds(state);
        for (Threshold threshold : nonRedundant) {
            this.thresholds.remove(threshold);
        }
    }

    private D applyThresholds(Set<Threshold> thresh, D state) {
        for (Threshold threshold : thresh) {
            try {
                state = state.eval(threshold.getTest());
            }
            catch (Unreachable _) {
                throw new DomainStateException.InvariantViolationException();
            }
        }
        return state;
    }

    protected boolean subsetOrEqual(ThresholdsWideningStateBuilder<D> otherBuilder) {
        return this.thresholds.hasAppliedThresholdsNotIn(otherBuilder.thresholds);
    }

    protected void mergeThresholds(D thisChildState, D otherChildState, ThresholdsWideningStateBuilder<D> otherBuilder) {
        P3<ThresholdsWideningState.MutableState, ThresholdsWideningState.MutableState, ThresholdsWideningState.MutableState> split = this.thresholds.split(otherBuilder.thresholds);
        ThresholdsWideningState.MutableState onlyInThis = split._1();
        ThresholdsWideningState.MutableState inBoth = split._2();
        ThresholdsWideningState.MutableState onlyInOther = split._3();
        assert (onlyInThis.isConsistent());
        assert (onlyInOther.isConsistent());
        assert (inBoth.isConsistent());
        this.thresholds = inBoth;
        this.copyRedundantThresholdsFrom(onlyInThis, thisChildState, otherChildState);
        this.copyRedundantThresholdsFrom(onlyInOther, otherChildState, thisChildState);
    }

    private void copyRedundantThresholdsFrom(ThresholdsWideningState.MutableState candidates, D candidatesState, D otherState) {
        for (Threshold threshold : candidates) {
            Zeno.Test test = threshold.getTest();
            Zeno.Test redundantTest = this.getRedundantTest(test, candidatesState, otherState, new HashSet<Zeno.Test>());
            if (redundantTest == null) continue;
            this.thresholds.add(threshold.withTest(redundantTest), candidates.getAppliedPoints(threshold));
        }
    }

    private Zeno.Test getRedundantTest(Zeno.Test candidate, D candidatesState, D otherState, Set<Zeno.Test> usedCandidates) {
        if (usedCandidates.size() > 5) {
            return null;
        }
        if (this.isRedundant(candidate, otherState)._1().booleanValue()) {
            return candidate;
        }
        usedCandidates.add(candidate);
        AVLSet<Zeno.Test> substitutes = this.getSubstituteTests(candidate, candidatesState, otherState);
        for (Zeno.Test substitute : substitutes) {
            Zeno.Test redundantTest;
            if (usedCandidates.contains(substitute) || (redundantTest = this.getRedundantTest(substitute, candidatesState, otherState, usedCandidates)) == null) continue;
            return redundantTest;
        }
        return null;
    }

    private AVLSet<Zeno.Test> getSubstituteTests(Zeno.Test test, D testState, D otherState) {
        VarSet testVars = test.getVars();
        AVLSet<Substitution> substitutions = AVLSet.empty();
        for (NumVar var : testVars) {
            SetOfEquations thisEqualities = testState.queryEqualities(var);
            SetOfEquations otherEqualities = otherState.queryEqualities(var);
            substitutions = substitutions.union(ThresholdsWideningStateBuilder.generateSubstitutionsFor(var, thisEqualities.difference(otherEqualities)));
        }
        AVLSet<Zeno.Test> substitutes = AVLSet.empty();
        for (Substitution substitution : substitutions) {
            Zeno.Test substituteTest = test.applySubstitution(substitution);
            if (ZenoTestHelper.isTautology(substituteTest)) continue;
            substitutes = substitutes.add(substituteTest);
        }
        return substitutes;
    }

    @Override
    public String toString() {
        return this.build().toString();
    }
}

