/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.delayed;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.abstractsyntax.zeno.ZenoVisitor;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.widening.delayed.DelayedWideningProperties;
import bindead.domains.widening.delayed.DelayedWideningState;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.persistentcollections.AVLSet;

public class DelayedWidening<D extends ZenoDomain<D>>
extends ZenoFunctor<DelayedWideningState, D, DelayedWidening<D>> {
    public static final String NAME = "DELAYEDWIDENING";
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGWIDENING;
    private final boolean DEBUGASSIGN;
    private final boolean SEMANTICCONSTANTS;
    ZenoVisitor<Boolean, Void> syntacticConstantExprTest;

    public DelayedWidening(D childState) {
        this(DelayedWideningState.EMPTY, childState);
    }

    private DelayedWidening(DelayedWideningState state, D childState) {
        super(NAME, state, childState);
        this.DEBUGBINARIES = DelayedWideningProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGWIDENING = DelayedWideningProperties.INSTANCE.debugWidening.isTrue();
        this.DEBUGASSIGN = DelayedWideningProperties.INSTANCE.debugAssignments.isTrue();
        this.SEMANTICCONSTANTS = DelayedWideningProperties.INSTANCE.semanticConstants.isTrue();
        this.syntacticConstantExprTest = new ZenoRhsVisitorSkeleton<Boolean, Void>(){

            @Override
            public Boolean visit(Zeno.Bin expr, Void data) {
                return false;
            }

            @Override
            public Boolean visit(Zeno.RangeRhs expr, Void data) {
                return false;
            }

            @Override
            public Boolean visit(Zeno.Rlin expr, Void data) {
                return expr.isConstantOnly();
            }
        };
    }

    @Override
    public DelayedWidening<D> build(DelayedWideningState state, D childState) {
        return new DelayedWidening<D>(state, childState);
    }

    @Override
    public boolean subsetOrEqual(DelayedWidening<D> other) {
        return ((ZenoDomain)this.childState).subsetOrEqual(other.childState);
    }

    @Override
    public DelayedWidening<D> join(DelayedWidening<D> other) {
        DelayedWideningState newState = new DelayedWideningState(((DelayedWideningState)this.state).assignments.union(((DelayedWideningState)other.state).assignments));
        if (this.DEBUGBINARIES) {
            System.out.println(this.name + " (join): ");
            System.out.println("  fst:  " + ((DelayedWideningState)this.state).assignments);
            System.out.println("  snd:  " + ((DelayedWideningState)other.state).assignments);
            System.out.println("  join: " + newState.assignments);
        }
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        return this.build(newState, (D)newChildState);
    }

    @Override
    public DelayedWidening<D> widen(DelayedWidening<D> other) {
        AVLSet<ProgramPoint> newConstAssignments = ((DelayedWideningState)other.state).assignments.difference(((DelayedWideningState)this.state).assignments);
        ZenoDomain newChildState = newConstAssignments.isEmpty() ? (ZenoDomain)((ZenoDomain)this.childState).widen(other.childState) : (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        if (this.DEBUGWIDENING) {
            String message = newConstAssignments.isEmpty() ? "applying widening" : "widening suppressed because of " + newConstAssignments.size() + " new constant assignments from: " + newConstAssignments;
            Option<ProgramPoint> location = this.getContext().getLocation();
            System.out.println(this.name + " (widening)@" + location + ": " + message);
        }
        return this.build((DelayedWideningState)other.state, (D)newChildState);
    }

    @Override
    public DelayedWidening<D> eval(Zeno.Assign stmt) {
        Option<ProgramPoint> location = this.getContext().getLocation();
        Object newChildState = ((ZenoDomain)this.childState).eval(stmt);
        DelayedWideningState newState = (DelayedWideningState)this.state;
        if (location.isSome() && !((DelayedWideningState)this.state).assignments.contains(location.get()) && this.isConstant(newChildState, stmt)) {
            newState = new DelayedWideningState(((DelayedWideningState)this.state).assignments.add(location.get()));
        }
        if (this.DEBUGASSIGN) {
            System.out.println(this.name + " @" + location + ": ");
            System.out.println("  evaluating assign: " + stmt);
            System.out.println("  before: " + ((DelayedWideningState)this.state).assignments);
            System.out.println("  after: " + newState.assignments);
        }
        return this.build(newState, newChildState);
    }

    private boolean isConstant(D childState, Zeno.Assign stmt) {
        if (this.SEMANTICCONSTANTS) {
            return childState.queryRange(stmt.getLhs().getId()).isConstant();
        }
        return stmt.getRhs().accept(this.syntacticConstantExprTest, null);
    }

    @Override
    public DelayedWidening<D> eval(Zeno.Test test) throws Unreachable {
        Object newChildState = ((ZenoDomain)this.childState).eval(test);
        return this.build((DelayedWideningState)this.state, newChildState);
    }

    @Override
    public DelayedWidening<D> project(VarSet vars) {
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build((DelayedWideningState)this.state, newChildState);
    }

    @Override
    public DelayedWidening<D> substitute(NumVar x, NumVar y) {
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build((DelayedWideningState)this.state, newChildState);
    }
}

