/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.syntacticstripes;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import javalx.numeric.BigInt;

class Stripe {
    private static final ZenoFactory zeno = ZenoFactory.getInstance();
    final NumVar special;

    public Stripe(NumVar special) {
        this.special = special;
    }

    public String toString() {
        return this.special.toString();
    }

    Linear asLinear() {
        return Linear.linear(this.special);
    }

    Linear asLinear(Linear.Divisor gcd, BigInt c) {
        assert (gcd.get().isPositive());
        return Linear.linear(c, Linear.term(gcd.get(), this.special));
    }

    Linear asNegatedLinear(Linear.Divisor gcd, BigInt c) {
        assert (gcd.get().isPositive());
        return Linear.linear(c, Linear.term(gcd.get().negate(), this.special));
    }

    Zeno.Test asEquality(Linear lin) {
        Linear eq = lin.add(this.asLinear());
        return zeno.comparison(eq, Zeno.ZenoTestOp.EqualToZero);
    }

    Zeno.Test upperBoundPredicate(Linear lin, BigInt u) {
        Linear eq = lin.add(this.asLinear()).add(u);
        return zeno.comparison(eq, Zeno.ZenoTestOp.LessThanOrEqualToZero);
    }

    Zeno.Test lowerBoundPredicate(Linear lin, BigInt u) {
        Linear eq = this.asLinear().add(u).sub(lin);
        return zeno.comparison(zeno.linear(eq), Zeno.ZenoTestOp.LessThanOrEqualToZero);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.special == null ? 0 : this.special.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stripe other = (Stripe)obj;
        return !(this.special == null ? other.special != null : !this.special.equalTo(other.special));
    }
}

