/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.data.MemVarPair;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domains.pointsto.PointsToProperties;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.heap.Connector;
import bindead.domains.segments.heap.ConnectorData;
import bindead.domains.segments.heap.ConnectorId;
import bindead.domains.segments.heap.ConnectorSet;
import bindead.domains.segments.heap.HeapPartitioning;
import bindead.domains.segments.heap.HeapRegion;
import bindead.domains.segments.heap.HeapSegment;
import bindead.domains.segments.heap.PathString;
import bindead.exceptions.Unreachable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLSet;
import rreil.lang.MemVar;
import rreil.lang.Rhs;

public class HeapSegBuilder<D extends MemoryDomain<D>> {
    static final boolean withTransitiveInfo = false;
    private static final boolean withPrimConnectors = true;
    final boolean DEBUG;
    HeapSegment<D> seg;
    D child;

    void msg(String msg) {
        if (!this.DEBUG) {
            return;
        }
        System.out.print("\nHeapSegBuilder: ");
        System.out.println(msg);
    }

    void msgs(String msg) {
        if (!this.DEBUG) {
            return;
        }
        System.out.print("\nHeapSegBuilder: ");
        System.out.println(msg);
        System.out.print("\nin state: ");
        System.out.println(this.toCompactString());
    }

    HeapSegBuilder(HeapSegment<D> seg, D child) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.seg = seg;
        this.child = child;
    }

    private void remove(Connector en) {
        this.seg = this.seg.removeConnector(en.id);
        this.child = this.child.projectRegion(en.data.src);
        this.child = this.child.projectRegion(en.data.tgt);
    }

    void renameRegion(MemVar from, NumVar.AddrVar fromAddr, MemVar to, NumVar.AddrVar toAddr) {
        HeapRegion regions = this.seg.heapRegions.get(from).setMemId(to).setAddr(toAddr);
        ConnectorSet conns = ConnectorSet.empty();
        for (Connector conn : this.seg.connectors) {
            ConnectorId movedConnectorId = conn.id.moveConnector(from, to);
            MemVar newTgt = MemVar.fresh();
            this.child = this.child.substituteRegion(conn.data.tgt, newTgt);
            MemVar newSrc = MemVar.fresh();
            this.child = this.child.substituteRegion(conn.data.src, newSrc);
            ConnectorData movedConnectorData = new ConnectorData(newSrc, newTgt);
            conns = conns.add(movedConnectorId, movedConnectorData);
        }
        this.seg = this.seg.removeRegion(from).bindRegion(regions).withConnectors(conns);
        this.child = this.child.substituteRegion(from, to);
        this.child = this.child.substitute(fromAddr, toAddr);
    }

    void summarizeHeap() {
        this.createPrimeConnectors(this.seg.allKnownRegions);
        this.msg("created prime connectors");
        HeapPartitioning partitions = this.seg.partition(this.child);
        for (MemVarSet area : partitions) {
            if (area.size() < 2) continue;
            this.foldNodesOfPartition(area);
            this.msgs("summarized area " + area);
        }
        assert (this.seg.connectorsAreSane());
    }

    private void createPrimeConnectors(MemVarSet area) {
        for (MemVar sourceNode : area) {
            List<P2<PathString, NumVar.AddrVar>> targets = this.child.findPossiblePointerTargets(sourceNode);
            for (P2<PathString, NumVar.AddrVar> target : targets) {
                PathString path;
                ConnectorId enid;
                HeapRegion targetRegion = this.seg.heapRegions.get(target._2());
                if (targetRegion == null || !area.contains(targetRegion.memId) || this.seg.connectors.contains(enid = new ConnectorId(sourceNode, path = target._1(), targetRegion.memId))) continue;
                MemVar sourceContents = MemVar.fresh();
                MemVar targetContents = MemVar.fresh();
                this.child = this.child.copyMemRegion(sourceNode, sourceContents);
                this.child = this.child.copyMemRegion(targetRegion.memId, targetContents);
                ConnectorData endata = new ConnectorData(sourceContents, targetContents);
                Connector connector = new Connector(enid, endata);
                this.seg = this.seg.bindConnector(enid, endata);
            }
        }
    }

    private void updateTransitiveConnectors(Connector current) {
        ConnectorSet incoming = new ConnectorSet();
        for (Connector in : this.seg.connectors) {
            if (!in.spansTo(current.id.src)) continue;
            incoming = incoming.add(in);
            assert (false) : in + " * " + current;
            throw new UnimplementedException();
        }
        ConnectorSet outgoing = new ConnectorSet();
        for (Connector out : this.seg.connectors) {
            if (!out.spansFrom(current.id.tgt)) continue;
            outgoing = outgoing.add(out);
            throw new UnimplementedException();
        }
        for (Connector in : incoming) {
            Iterator<Connector> iterator = outgoing.iterator();
            if (!iterator.hasNext()) continue;
            Connector out = iterator.next();
            throw new UnimplementedException();
        }
    }

    private void createTransitiveConnectorClosure(MemVarSet area) {
        for (MemVar region : area) {
            ConnectorSet firsts = this.seg.connectors.getConnectorGoingTo(region);
            ConnectorSet seconds = this.seg.connectors.getConnectorComingFrom(region);
            for (Connector snd : seconds) {
                for (Connector fst : firsts) {
                    if (!area.contains(snd.id.tgt) && !area.contains(fst.id.src) || fst.id.src.equals(region) && snd.id.tgt.equals(region)) continue;
                    this.makeTransitiveNode(fst, snd);
                }
            }
        }
    }

    private void makeTransitiveNode(Connector edge1, Connector edge2) {
        if (edge1.id.src == edge1.id.tgt && edge2.id.src != edge2.id.tgt) {
            ConnectorData newData = this.makeTransitiveConnector(edge1.data, edge2.data);
            this.foldConnectorData(edge2.data, newData);
        } else if (edge1.id.src != edge1.id.tgt && edge2.id.src == edge2.id.tgt) {
            ConnectorData newData = this.makeTransitiveConnector(edge1.data, edge2.data);
            this.foldConnectorData(edge1.data, newData);
        } else if (edge1.id.src != edge2.id.src && edge1.id.tgt != edge2.id.tgt) {
            ConnectorData newData = this.makeTransitiveConnector(edge1.data, edge2.data);
            ConnectorId id = new ConnectorId(edge1.id.src, edge1.id.pathString.plus(edge2.id.pathString), edge2.id.tgt);
            if (this.seg.connectors.contains(id)) {
                Connector existingConnector = this.seg.connectors.get(id);
                this.foldConnectorData(existingConnector.data, newData);
            } else {
                this.seg = this.seg.bindConnector(id, newData);
            }
        } else assert (false) : "should not happen.";
    }

    private ConnectorData makeTransitiveConnector(ConnectorData edge1data, ConnectorData edge2data) {
        MemVar newSrc = this.makeCopyOfRegion(edge1data.src);
        MemVar newTgt = this.makeCopyOfRegion(edge2data.tgt);
        return new ConnectorData(newSrc, newTgt);
    }

    private void foldConnectorData(ConnectorData permData, ConnectorData ephData) {
        LinkedList<MemVarPair> vars = new LinkedList<MemVarPair>();
        vars.add(new MemVarPair(permData.src, ephData.src));
        vars.add(new MemVarPair(permData.tgt, ephData.tgt));
        this.child = this.child.foldNG(vars);
    }

    private MemVar makeCopyOfRegion(MemVar targetContents) {
        MemVar newTgt = MemVar.fresh();
        this.child = this.child.copyMemRegion(targetContents, newTgt);
        return newTgt;
    }

    private static Connector transitiveNode(Connector edge1, Connector edge2, MemVar c1, MemVar c2) {
        ConnectorId id = new ConnectorId(edge1.id.src, edge1.id.pathString.plus(edge2.id.pathString), edge2.id.tgt);
        ConnectorData data = new ConnectorData(c1, c2);
        return new Connector(id, data);
    }

    private void foldNodesOfPartition(MemVarSet area) {
        MemVar perm = area.getMin().get();
        for (MemVar eph : area) {
            if (eph.equals(perm)) continue;
            this.foldRegionsNG(perm, eph);
        }
    }

    public SegmentWithState<D> build() {
        return new SegmentWithState<D>(this.seg, this.child);
    }

    public String toString() {
        return "seg: " + this.seg + "\nstate: " + this.child;
    }

    public String toCompactString() {
        return this.build().toCompactString();
    }

    public void assumeEdgeNG(Rhs.Lin fieldThatPoints, HeapRegion region) {
        this.child = this.child.assumeEdgeNG(fieldThatPoints, region.address);
        this.applyPrimeConnectors(fieldThatPoints, region);
    }

    public void concretizeAndDisconnectNG(NumVar.AddrVar summary, AVLSet<MemVar> concreteNodes) {
        this.child = this.child.concretizeAndDisconnectNG(summary, concreteNodes);
    }

    private void applyPrimeConnectors(Rhs.Lin fieldThatPoints, HeapRegion target) {
        for (Connector connector : this.seg.connectors) {
            if (!connector.id.isSelfLoop() || this.seg.getRegion((MemVar)connector.id.src).isSummary) continue;
            this.remove(connector);
        }
        for (Connector connector : this.seg.connectors) {
            HeapRegion reg = this.seg.heapRegions.get(connector.id.tgt);
            assert (reg != null);
            NumVar.AddrVar tgtAddr = reg.address;
            Range flagRange = this.child.queryPtsEdge(connector.id.src, connector.id.pathString.prefix, fieldThatPoints.getSize(), tgtAddr);
            if (flagRange.isOne()) {
                this.child = this.child.assumeRegionsAreEqual(connector.id.src, connector.data.src);
                this.child = this.child.assumeRegionsAreEqual(connector.id.tgt, connector.data.tgt);
                this.remove(connector);
                continue;
            }
            if (!flagRange.isZero() || connector.id.isSelfLoop() && reg.isSummary) continue;
            this.remove(connector);
        }
    }

    private void applyTransitiveConnectors(ConnectorId id) {
        for (Connector sc : this.seg.connectors) {
            if (!sc.spansFrom(id.src, id.pathString) || sc.id.isSelfLoop()) continue;
            for (Connector tc : this.seg.connectors) {
                if (!tc.spansFrom(id.tgt) || !tc.spansTo(sc.id.tgt)) continue;
                String message = "current connector is " + id + ": specialize connector " + tc + " with " + sc;
                this.msg(message);
                try {
                    this.applyTransitiveConnectorViaCnP(id, sc, tc);
                }
                catch (Unreachable u) {
                    this.msg("equated, unreachable");
                }
            }
        }
    }

    private void applyTransitiveConnectorViaCnP(ConnectorId singleStep, Connector sc, Connector tc) {
        D cs = this.child;
        cs = cs.assumeRegionsAreEqual(singleStep.src, sc.data.src);
        cs = cs.assumeRegionsAreEqual(tc.data.tgt, sc.data.tgt);
        new HeapSegBuilder<D>(this.seg, cs).msgs("equated.");
        D child2 = this.child.projectRegion(tc.data.src).projectRegion(tc.data.tgt);
        this.child = child2.copyAndPaste(MemVarSet.of(tc.data.src, tc.data.tgt), cs);
    }

    private void applyTransitiveConnectorViaExpand(ConnectorId singleStep, Connector sc, Connector tc) {
        System.err.println("single " + singleStep + " " + sc + " " + tc);
        MemVar scSrcCopy = MemVar.fresh();
        MemVar scTgtCopy = MemVar.fresh();
        LinkedList<MemVarPair> expansion = new LinkedList<MemVarPair>();
        expansion.add(new MemVarPair(sc.data.src, scSrcCopy));
        expansion.add(new MemVarPair(sc.data.tgt, scTgtCopy));
        System.err.println(expansion);
        D fallback = this.child;
        try {
            this.child = this.child.expandNG(expansion);
            this.child = this.child.assumeRegionsAreEqual(singleStep.src, scSrcCopy);
            this.child = this.child.assumeRegionsAreEqual(tc.data.tgt, scTgtCopy);
            this.child = this.child.projectRegion(scSrcCopy).projectRegion(scTgtCopy);
        }
        catch (Unreachable _) {
            this.child = fallback;
        }
    }

    void foldRegionsNG(MemVar perm, MemVar eph) {
        this.msg("summarize " + perm + " <- " + eph);
        MemVarSet summaryContents = MemVarSet.of(perm);
        MemVarSet concreteContents = MemVarSet.of(eph);
        MemVarSet pointingToConcrete = MemVarSet.empty();
        MemVarSet pointingToSummary = MemVarSet.empty();
        for (Connector en : this.seg.connectors) {
            if (en.spansTo(perm)) {
                summaryContents = summaryContents.insert(en.data.tgt);
                if (!en.spansFrom(eph)) {
                    pointingToSummary = pointingToSummary.insert(en.data.src);
                }
            } else if (en.spansTo(eph)) {
                concreteContents = concreteContents.insert(en.data.tgt);
                if (!en.spansFrom(perm)) {
                    pointingToConcrete = pointingToConcrete.insert(en.data.src);
                }
            }
            if (en.spansFrom(perm)) {
                summaryContents = summaryContents.insert(en.data.src);
                continue;
            }
            if (!en.spansFrom(eph)) continue;
            concreteContents = concreteContents.insert(en.data.src);
        }
        HeapRegion permRegion = this.seg.getRegion(perm);
        HeapRegion ephRegion = this.seg.getRegion(eph);
        this.child = this.child.bendGhostEdgesNG(permRegion.address, ephRegion.address, summaryContents, concreteContents, pointingToSummary, pointingToConcrete);
        this.msg("fold Regions: bent ghost edges");
        LinkedList<MemVarPair> doubleEdgeNodePairs = new LinkedList<MemVarPair>();
        for (Connector en : this.seg.connectors) {
            if (!en.spans(perm, eph) && !en.spans(eph, perm)) continue;
            ConnectorId toId = new ConnectorId(en.id.src, en.id.pathString, en.id.src);
            if (this.seg.connectors.contains(toId)) {
                this.foldOnto(doubleEdgeNodePairs, en, toId);
                continue;
            }
            this.seg = this.bendEdgeNode(en, toId);
        }
        this.child = this.child.foldNG(doubleEdgeNodePairs);
        this.msg("fold Regions: bent connectors between s and c");
        LinkedList<MemVarPair> allContents = new LinkedList<MemVarPair>();
        allContents.add(new MemVarPair(perm, eph));
        for (Connector en : this.seg.connectors) {
            ConnectorId toId;
            if (en.spans(eph, eph)) {
                toId = new ConnectorId(perm, en.id.pathString, perm);
                if (this.seg.connectors.contains(toId)) {
                    this.foldOnto(allContents, en, toId);
                    continue;
                }
                this.seg = this.bendEdgeNode(en, toId);
                continue;
            }
            if (en.spansTo(eph)) {
                toId = new ConnectorId(en.id.src, en.id.pathString, perm);
                if (this.seg.connectors.contains(toId)) {
                    this.foldOnto(allContents, en, toId);
                    continue;
                }
                this.seg = this.bendEdgeNode(en, toId);
                continue;
            }
            if (!en.spansFrom(eph)) continue;
            toId = new ConnectorId(perm, en.id.pathString, en.id.tgt);
            if (this.seg.connectors.contains(toId)) {
                this.foldOnto(allContents, en, toId);
                continue;
            }
            this.seg = this.bendEdgeNode(en, toId);
        }
        this.child = this.child.foldNG(permRegion.address, ephRegion.address, allContents);
        this.seg = this.seg.removeRegion(ephRegion);
        this.seg = this.seg.bindRegion(permRegion.setSummaryFlag(true));
        this.msg("summarized.");
    }

    private void foldOnto(List<MemVarPair> doubleEdgeNodePairs, Connector en, ConnectorId ontoId) {
        Connector onto = this.seg.connectors.get(ontoId);
        doubleEdgeNodePairs.add(new MemVarPair(onto.data.src, en.data.src));
        doubleEdgeNodePairs.add(new MemVarPair(onto.data.tgt, en.data.tgt));
        this.seg = this.seg.removeConnector(en.id);
    }

    private HeapSegment<D> bendEdgeNode(Connector en, ConnectorId toId) {
        MemVar newSrc = MemVar.fresh();
        this.child = this.child.substituteRegion(en.data.src, newSrc);
        MemVar newTgt = MemVar.fresh();
        this.child = this.child.substituteRegion(en.data.tgt, newTgt);
        ConnectorData movedData = new ConnectorData(newSrc, newTgt);
        return this.seg.removeConnector(en.id).bindConnector(toId, movedData);
    }

    HeapRegion expandNG(HeapRegion summary) {
        HeapRegion concrete = new HeapRegion(NumVar.freshAddress(), MemVar.fresh(), summary.size);
        this.seg = this.seg.bindRegion(concrete);
        LinkedList<MemVarPair> toExpand = new LinkedList<MemVarPair>();
        toExpand.add(new MemVarPair(summary.memId, concrete.memId));
        for (Connector en : this.seg.connectors) {
            if (en.spans(summary.memId, summary.memId)) {
                ConnectorId ccid = en.id.bendSrcTo(concrete).bendTgtTo(concrete);
                this.expandConnector(toExpand, ccid, en.data);
                continue;
            }
            if (en.spansTo(summary)) {
                ConnectorId xcid = en.id.bendTgtTo(concrete);
                this.expandConnector(toExpand, xcid, en.data);
                continue;
            }
            if (!en.spansFrom(summary)) continue;
            ConnectorId cxid = en.id.bendSrcTo(concrete);
            this.expandConnector(toExpand, cxid, en.data);
        }
        assert (this.seg.connectorsAreSane());
        this.child = this.child.expandNG(summary.address, concrete.address, toExpand);
        return concrete;
    }

    private void expandConnector(LinkedList<MemVarPair> expandList, ConnectorId id, ConnectorData data) {
        MemVar newSrc = MemVar.fresh();
        expandList.add(new MemVarPair(data.src, newSrc));
        MemVar newTgt = MemVar.fresh();
        expandList.add(new MemVarPair(data.tgt, newTgt));
        ConnectorData cdata = new ConnectorData(newSrc, newTgt);
        this.seg = this.seg.bindConnector(id, cdata);
    }

    void expandAndBendGhostEdgesNG(HeapRegion summary, HeapRegion concrete) {
        LinkedList<MemVarPair> toExpand = new LinkedList<MemVarPair>();
        for (Connector en : this.seg.connectors) {
            if (en.spans(summary.memId, summary.memId)) {
                ConnectorId scid = en.id.bendTgtTo(concrete);
                this.expandConnector(toExpand, scid, en.data);
                continue;
            }
            if (!en.spans(concrete.memId, concrete.memId)) continue;
            ConnectorId csid = en.id.bendTgtTo(summary);
            this.expandConnector(toExpand, csid, en.data);
        }
        MemVarSet toBendAsSummary = MemVarSet.of(summary.memId);
        MemVarSet toBendAsConcrete = MemVarSet.of(concrete.memId);
        MemVarSet pointingToSummary = MemVarSet.empty();
        MemVarSet pointingToConcrete = MemVarSet.empty();
        for (Connector en : this.seg.connectors) {
            this.msg("testing " + en);
            if (en.spansTo(summary)) {
                toBendAsSummary = toBendAsSummary.insert(en.data.tgt);
                if (!en.spansFrom(concrete)) {
                    pointingToSummary = pointingToSummary.insert(en.data.src);
                }
            } else if (en.spansTo(concrete)) {
                toBendAsConcrete = toBendAsConcrete.insert(en.data.tgt);
                if (!en.spansFrom(summary)) {
                    pointingToConcrete = pointingToConcrete.insert(en.data.src);
                }
            }
            if (en.spansFrom(summary)) {
                toBendAsSummary = toBendAsSummary.insert(en.data.src);
            } else if (en.spansFrom(concrete)) {
                toBendAsConcrete = toBendAsConcrete.insert(en.data.src);
            }
            this.msg("s: " + toBendAsSummary);
            this.msg("c: " + toBendAsConcrete);
        }
        assert (this.seg.connectorsAreSane());
        this.child = this.child.expandNG(toExpand);
        this.msg("pointingToSummary " + pointingToSummary);
        this.msg("pointingToConcrete " + pointingToConcrete);
        this.msg("toBendAsSummary " + toBendAsSummary);
        this.msg("toBendAsConcrete " + toBendAsConcrete);
        this.child = this.child.bendBackGhostEdgesNG(summary.address, concrete.address, toBendAsSummary, toBendAsConcrete, pointingToSummary, pointingToConcrete);
    }

    void concretizeAndDisconnectNG(HeapRegion summary, HeapRegion concrete) {
        AVLSet<MemVar> concreteNodes = AVLSet.singleton(concrete.memId).add(summary.memId);
        for (Connector en : this.seg.connectors) {
            if (en.spansFrom(concrete) || en.spansFrom(summary)) {
                concreteNodes = concreteNodes.add(en.data.src);
            }
            if (!en.spansTo(concrete) && !en.spansTo(summary)) continue;
            concreteNodes = concreteNodes.add(en.data.tgt);
        }
        this.concretizeAndDisconnectNG(summary.address, concreteNodes);
    }

    void informAboutAssign(MemVar toRegion, Range toOffset, MemVar fromRegion, Range fromOffset) {
        assert (toRegion != null);
        this.msg("informed about assign: " + this.showRO(toRegion, toOffset) + " <- " + this.showRO(fromRegion, fromOffset));
        ConnectorSet ens = this.seg.connectors;
        for (Connector en : this.seg.connectors) {
            if (!en.id.attachedTo(toRegion, toOffset)) continue;
            ens = ens.remove(en.id);
            this.child = this.child.projectRegion(en.data.src);
            this.child = this.child.projectRegion(en.data.tgt);
        }
        MemVarSet regs = this.seg.allKnownRegions;
        if (toRegion != null) {
            regs = regs.insert(toRegion);
        }
        if (fromRegion != null) {
            regs = regs.insert(fromRegion);
        }
        this.seg = new HeapSegment(this.seg.heapRegions, ens, regs);
    }

    String showRO(MemVar toRegion, Range toOffset) {
        return toRegion + ":" + toOffset;
    }
}

