/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import javalx.numeric.BigInt;
import rreil.lang.MemVar;

public class HeapRegion
implements Comparable<HeapRegion> {
    final boolean isSummary;
    public final NumVar.AddrVar address;
    public final MemVar memId;
    final BigInt size;

    private HeapRegion(NumVar.AddrVar address, MemVar id, BigInt size, boolean isSummary) {
        assert (address != null);
        this.address = address;
        this.isSummary = isSummary;
        assert (id != null);
        this.memId = id;
        assert (size != null);
        this.size = size;
    }

    HeapRegion(NumVar.AddrVar address, MemVar regionName, BigInt size) {
        this(address, regionName, size, false);
    }

    public String toString() {
        String summStr = this.isSummary ? " (Summary)" : "(Concrete)";
        return this.memId + ":" + this.size + summStr;
    }

    HeapRegion setMemId(MemVar to) {
        return new HeapRegion(this.address, to, this.size, this.isSummary);
    }

    public HeapRegion setAddr(NumVar.AddrVar toAddr) {
        return new HeapRegion(toAddr, this.memId, this.size, this.isSummary);
    }

    HeapRegion turnIntoSummary() {
        return this.setSummaryFlag(true);
    }

    HeapRegion setSummaryFlag(boolean s) {
        return new HeapRegion(this.address, this.memId, this.size, s);
    }

    public MemVarSet getChildSupportSet() {
        return MemVarSet.of(this.memId);
    }

    @Override
    public int compareTo(HeapRegion other) {
        int t1 = this.address.compareTo(other.address);
        if (t1 != 0) {
            return t1;
        }
        return this.memId.compareTo(other.memId);
    }

    public void toCompactString(StringBuilder builder, PrettyDomain child) {
        builder.append("    " + this.memId + "@" + this.address + " = ");
        child.memVarToCompactString(builder, this.memId);
        if (this.isSummary) {
            builder.append("<Summary>");
        }
        builder.append("\n");
    }
}

