/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.sat;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.FoldMap;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domains.sat.RhsTranslator;
import bindead.domains.sat.SatState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import javalx.numeric.BigInt;
import satDomain.Flag;
import satDomain.HashedSubstitution;
import satDomain.Numeric;
import satDomain.Renamer;
import satDomain.Substitution;

public class SatStateBuilder {
    protected final Numeric cnf;
    protected final HashMap<Integer, Integer> translation;

    private boolean isTracked(int v) {
        return this.translation.containsKey(v);
    }

    boolean isTracked(NumVar v) {
        return this.isTracked(v.getStamp());
    }

    private int getInner(int v) {
        assert (this.isTracked(v));
        return this.translation.get(v);
    }

    private int getInner(NumVar v) {
        return this.getInner(v.getStamp());
    }

    private boolean equalSupport(SatStateBuilder other) {
        return this.translation.keySet().equals(other.translation.keySet());
    }

    public SatStateBuilder(SatState ctx) {
        this.cnf = new Numeric(ctx.cnf);
        this.translation = new HashMap<Integer, Integer>(ctx.translation);
    }

    public SatState build() {
        System.out.println("build() built new SatState: " + this.translation + "\n" + this.cnf);
        return new SatState(this.cnf, this.translation);
    }

    public String toString() {
        return "SatStateBuilder{\n" + this.cnf + '}';
    }

    public boolean subsetOrEqual(SatStateBuilder other) {
        assert (this.equalSupport(other));
        other.cnf.rename(this.makeRenamerForSecondTranslation(this.translation, other.translation));
        return this.cnf.isSubset(other.cnf);
    }

    private Map<Integer, Integer> makeRenamerForSecondTranslation(HashMap<Integer, Integer> t1, HashMap<Integer, Integer> t2) {
        HashMap<Integer, Integer> renaming = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> e : t1.entrySet()) {
            Integer other = t2.get(e.getKey());
            renaming.put(other, e.getValue());
        }
        return renaming;
    }

    private void joinWith(SatStateBuilder other, boolean compression) {
        assert (this.equalSupport(other));
        Renamer rl = new Renamer();
        Renamer rr = new Renamer();
        for (Map.Entry<Integer, Integer> e : this.translation.entrySet()) {
            int outer = e.getKey();
            int il = rl.add(e.getValue());
            int ir = rr.add(other.getInner(outer));
            assert (il == ir);
            this.translation.put(outer, il);
            other.translation.put(outer, ir);
        }
        this.cnf.project(rl, compression);
        other.cnf.project(rr, compression);
        this.cnf.joinWith(other.cnf);
    }

    public void joinWith(SatStateBuilder other) {
        this.joinWith(other, false);
    }

    public void widenWith(SatStateBuilder other) {
        this.joinWith(other, true);
    }

    public void substitute(NumVar x, NumVar y) {
        assert (this.isTracked(y));
        assert (!this.isTracked(x));
        this.translation.put(x.getStamp(), this.translation.get(y.getStamp()));
        this.translation.remove(y.getStamp());
    }

    public void eval(Finite.Test test) {
        System.out.println("SatStateBuilder: test " + test);
        List<List<Integer>> clauses = new RhsTranslator(this).visitTest(test, true);
        System.out.println("SatStateBuilder: translated to clauses " + clauses);
        if (clauses != null) {
            this.restrictCnf(this.translateClauses(clauses));
        }
    }

    public void eval(Finite.Assign stmt) {
        NumVar lhs = stmt.getLhs().getId();
        if (!this.isTracked(lhs)) {
            return;
        }
        this.translation.put(lhs.getStamp(), this.cnf.freshTopVar().flag);
        this.restrictHalf(lhs, stmt.getRhs(), -1);
        this.restrictHalf(lhs, stmt.getRhs(), 1);
    }

    private void restrictHalf(NumVar lhs, Finite.Rhs rhs, int polarity) {
        List<List<Integer>> negRhs = rhs.accept(new RhsTranslator(this), polarity < 0);
        if (negRhs != null) {
            for (List<Integer> c : negRhs) {
                c.add(polarity * lhs.getStamp());
            }
            this.restrictCnf(this.translateClauses(negRhs));
        }
    }

    private List<int[]> translateClauses(List<List<Integer>> cls) {
        assert (cls != null);
        LinkedList<int[]> t = new LinkedList<int[]>();
        for (List<Integer> clause : cls) {
            t.add(this.translateClause(clause));
        }
        System.out.println("translated clauses " + t);
        return t;
    }

    private int[] translateClause(List<Integer> clause) {
        int[] c = new int[clause.size()];
        int i = 0;
        for (Integer l : clause) {
            c[i++] = this.translateLiteral(l);
        }
        return c;
    }

    private Integer translateLiteral(Integer l) {
        assert (l != null);
        Integer t = this.translation.get(Math.abs(l));
        assert (t != null);
        return l > 0 ? t : -t.intValue();
    }

    private void restrictCnf(List<int[]> list) {
        this.cnf.assumeClauses(list);
    }

    public void copyAndPaste(VarSet vars, SatState state) {
        assert (false);
    }

    public void fold(FoldMap vars) {
        HashedSubstitution subst = new HashedSubstitution();
        for (VarPair p : vars) {
            subst.put(this.getInner((NumVar)p.getEphemeral()), this.getInner((NumVar)p.getPermanent()));
        }
        Substitution s = this.cnf.summarize(subst);
        System.out.println("fold: substitution " + s);
        for (Map.Entry<Integer, Integer> t : this.translation.entrySet()) {
            Integer v = t.getValue();
            t.setValue(s.get(v));
        }
        System.out.println("fold: vars " + vars);
        System.out.println("fold: translation " + this.translation);
        for (VarPair vp : vars) {
            this.translation.remove(((NumVar)vp.getEphemeral()).getStamp());
        }
        System.out.println("fold: translation " + this.translation);
    }

    public void expand(FoldMap vars) {
        System.out.println("expand: vars " + vars);
        System.out.println("expand: in domain " + this.translation + " " + this.cnf);
        HashSet<Flag> fromSet = new HashSet<Flag>();
        for (VarPair v : vars) {
            int internalPermanent = this.translation.get(((NumVar)v.getPermanent()).getStamp());
            fromSet.add(new Flag(internalPermanent));
            System.out.println("expand: fromSet has " + internalPermanent);
        }
        Substitution s = this.cnf.expand("expanding SatStateBuilder", fromSet);
        System.out.println("expand: substitution " + s);
        System.out.println("expand: trans " + this.translation);
        for (VarPair v : vars) {
            int newO = ((NumVar)v.getEphemeral()).getStamp();
            int newI = s.get(this.translation.get(((NumVar)v.getPermanent()).getStamp()));
            this.translation.put(newO, newI);
            System.out.println("expand: new translation " + newO + " -> " + newI);
        }
        System.out.println("expand: in domain " + this.translation + " " + this.cnf);
    }

    public void remove(NumVar variable) {
        if (this.isTracked(variable)) {
            this.translation.remove(variable.getStamp());
        }
    }

    public void introduce(NumVar variable, Option<BigInt> value) {
        assert (!this.isTracked(variable));
        int iv = value.isNone() ? this.cnf.freshTopVar().flag : (value.get().isZero() ? this.cnf.freshFalseVar().flag : this.cnf.freshTrueVar().flag);
        this.translation.put(variable.getStamp(), iv);
        System.out.println("introduced " + iv);
    }
}

