/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.sat;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.sat.SatStateBuilder;
import java.util.LinkedList;
import java.util.List;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import rreil.lang.BinOp;

class RhsTranslator
implements FiniteExprVisitor<List<List<Integer>>, Boolean> {
    private final SatStateBuilder ssb;

    RhsTranslator(SatStateBuilder s) {
        this.ssb = s;
    }

    @Override
    public List<List<Integer>> visit(Finite.Bin expr, Boolean data) {
        System.out.println("Visit bin " + expr);
        BinOp op = expr.getOp();
        Finite.Rlin l = expr.getLeft();
        Finite.Rlin r = expr.getRight();
        if (op == BinOp.Sub || op == BinOp.Add || op == BinOp.Xor) {
            return this.makeXor(l, r, data);
        }
        if (op == BinOp.Mul || op == BinOp.And) {
            return this.makeAnd(l, r, data);
        }
        if (op == BinOp.Or) {
            return this.makeOr(l, r, data);
        }
        return null;
    }

    List<List<Integer>> makeOr(Finite.Rlin l, Finite.Rlin r, Boolean data) {
        List<List<Integer>> ll = l.accept(this, data);
        List<List<Integer>> rl = r.accept(this, data);
        if (data.booleanValue()) {
            return RhsTranslator.makeDisjunction(ll, rl);
        }
        return RhsTranslator.makeConjunction(ll, rl);
    }

    private List<List<Integer>> makeAnd(Finite.Rlin l, Finite.Rlin r, Boolean data) {
        List<List<Integer>> ll = l.accept(this, data);
        List<List<Integer>> rl = r.accept(this, data);
        if (!data.booleanValue()) {
            return RhsTranslator.makeConjunction(ll, rl);
        }
        return RhsTranslator.makeDisjunction(ll, rl);
    }

    private static List<List<Integer>> makeDisjunction(List<List<Integer>> ll, List<List<Integer>> rl) {
        LinkedList<List<Integer>> newL = new LinkedList<List<Integer>>();
        if (ll == null || rl == null) {
            return null;
        }
        for (List<Integer> l1 : ll) {
            for (List<Integer> r1 : rl) {
                LinkedList<Integer> newC = new LinkedList<Integer>(l1);
                newC.addAll(r1);
                newL.add(newC);
            }
        }
        return newL;
    }

    private static List<List<Integer>> makeConjunction(List<List<Integer>> ll, List<List<Integer>> rl) {
        LinkedList<List<Integer>> newL = new LinkedList<List<Integer>>(ll);
        newL.addAll(rl);
        return newL;
    }

    private List<List<Integer>> makeXor(Finite.Rlin l, Finite.Rlin r, Boolean data) {
        List<List<Integer>> ll1 = l.accept(this, data);
        List<List<Integer>> rl1 = r.accept(this, true);
        List<List<Integer>> ll2 = l.accept(this, data == false);
        List<List<Integer>> rl2 = r.accept(this, false);
        List<List<Integer>> o1 = RhsTranslator.makeDisjunction(ll1, rl1);
        List<List<Integer>> o2 = RhsTranslator.makeDisjunction(ll2, rl2);
        return RhsTranslator.makeConjunction(o1, o2);
    }

    @Override
    public List<List<Integer>> visit(Finite.Cmp expr, Boolean data) {
        assert (false);
        return null;
    }

    @Override
    public List<List<Integer>> visit(Finite.Convert expr, Boolean data) {
        return null;
    }

    @Override
    public List<List<Integer>> visit(Finite.SignExtend expr, Boolean data) {
        return null;
    }

    @Override
    public List<List<Integer>> visit(Finite.FiniteRangeRhs expr, Boolean data) {
        System.out.println("visit Range " + expr + " size=" + expr.getSize());
        Interval r = expr.getRange();
        System.out.println("range " + r);
        BigInt v = r.getConstant();
        if (v == null) {
            return null;
        }
        System.out.println("constant " + v);
        LinkedList<List<Integer>> res = new LinkedList<List<Integer>>();
        if (v.isOne()) {
            if (!data.booleanValue()) {
                res.add(new LinkedList());
            }
            return res;
        }
        if (v.isZero()) {
            if (!data.booleanValue()) {
                res.add(new LinkedList());
            }
            return res;
        }
        return null;
    }

    @Override
    public List<List<Integer>> visit(Finite.Rlin expr, Boolean data) {
        System.out.println("Visit Rlin " + expr + " size " + expr.getSize());
        Linear l = expr.getLinearTerm();
        return this.makeLinear(data, l);
    }

    private List<List<Integer>> makeLinear(Boolean data, Linear l) {
        Linear.Term[] ts = l.getTerms();
        LinkedList<List<Integer>> clauses = new LinkedList<List<Integer>>();
        if (ts.length == 0) {
            if (!data.booleanValue()) {
                clauses.add(new LinkedList());
            }
            return clauses;
        }
        if (ts.length != 1) {
            return null;
        }
        Linear.Term t = ts[0];
        if (!t.getCoeff().isOne()) {
            return null;
        }
        NumVar v = t.getId();
        if (!this.ssb.isTracked(v)) {
            return null;
        }
        LinkedList<Integer> clause = new LinkedList<Integer>();
        clause.add(data != false ? -v.getStamp() : v.getStamp());
        clauses.add(clause);
        return clauses;
    }

    public List<List<Integer>> visitTest(Finite.Test test, Boolean data) {
        switch (test.getOperator()) {
            case Equal: {
                return this.makeEqualTo(test.getSize(), test.getLeftExpr(), test.getRightExpr(), data);
            }
            case NotEqual: {
                return this.makeEqualTo(test.getSize(), test.getLeftExpr(), test.getRightExpr(), data == false);
            }
            case SignedLessThan: {
                return this.visitSignedLessThan(test, data);
            }
            case SignedLessThanOrEqual: {
                return this.visitSignedLessThanOrEqualTo(test, data);
            }
            case UnsignedLessThan: {
                assert (false);
                return null;
            }
            case UnsignedLessThanOrEqual: {
                assert (false);
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    private List<List<Integer>> visitSignedLessThanOrEqualTo(Finite.Test test, Boolean data) {
        int size = test.getSize();
        if (size != 1) {
            return null;
        }
        assert (false);
        List<List<Integer>> lhs = this.makeLinear(data, test.getLeftExpr());
        List<List<Integer>> rhs = this.makeLinear(data, test.getRightExpr());
        if (lhs == null || rhs == null) {
            return null;
        }
        return null;
    }

    private List<List<Integer>> visitSignedLessThan(Finite.Test test, Boolean data) {
        int size = test.getSize();
        if (size != 1) {
            return null;
        }
        assert (false);
        List<List<Integer>> lhs = this.makeLinear(data, test.getLeftExpr());
        List<List<Integer>> rhs = this.makeLinear(data, test.getRightExpr());
        if (lhs == null || rhs == null) {
            return null;
        }
        return null;
    }

    private List<List<Integer>> makeEqualTo(int size, Linear lhs, Linear rhs, Boolean data) {
        System.out.println("visit EqualTo " + lhs + " == " + rhs + " ~ " + data);
        List<List<Integer>> plhs = this.makeLinear(data, lhs);
        List<List<Integer>> nlhs = this.makeLinear(data == false, lhs);
        List<List<Integer>> prhs = this.makeLinear(data, rhs);
        List<List<Integer>> nrhs = this.makeLinear(data == false, rhs);
        List<List<Integer>> clauses = RhsTranslator.makeDisjunction(plhs, nrhs);
        System.out.println("plhs " + plhs);
        System.out.println("nlhs " + nlhs);
        System.out.println("prhs " + prhs);
        System.out.println("nrhs " + nrhs);
        if (plhs == null || nlhs == null || prhs == null || nrhs == null) {
            return null;
        }
        clauses.addAll(RhsTranslator.makeDisjunction(nlhs, prhs));
        System.out.println("created clauses " + clauses);
        return clauses;
    }
}

