/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.root;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.abstractsyntax.memderef.RootRegionAccess;
import bindead.abstractsyntax.memderef.SymbolicOffset;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.MemoryChildOp;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.messages.ReadFromUnknownPointerInfo;
import bindead.domains.root.RootState;
import bindead.exceptions.DomainStateException;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.FiniteRangeTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.MemVar;
import rreil.lang.Rhs;
import rreil.lang.util.Type;

class RootStateBuilder {
    private MemVarSet regions;
    private AVLMap<MemVar, NumVar> regionToAddress;
    private AVLMap<NumVar, MemVar> addressToRegion;
    protected AVLMap<MemVar, RegionCtx> contexts;
    private FiniteRangeTree<ContentCtx> segments;
    protected AVLMap<BigInt, MemVar> concreteAddresses;
    public final MemoryChildOp.Sequence childOps = new MemoryChildOp.Sequence();

    RootStateBuilder(RootState state) {
        this.regions = state.regions;
        this.regionToAddress = state.regionToAddress;
        this.addressToRegion = state.addressToRegion;
        this.contexts = state.contexts;
        this.segments = state.segments;
        this.concreteAddresses = state.concreteAddresses;
    }

    public NumVar addressOf(MemVar regionId) {
        Option<NumVar> address = this.regionToAddress.get(regionId);
        if (address.isSome()) {
            return address.get();
        }
        NumVar.AddrVar symbolicAddress = NumVar.freshAddress();
        this.childOps.addIntro(symbolicAddress, Type.Address);
        this.setAddressOf(regionId, symbolicAddress);
        return symbolicAddress;
    }

    private MemVar regionOf(NumVar addressVariableId) {
        return this.addressToRegion.get(addressVariableId).get();
    }

    private MemVar regionOf(Interval accessRange) {
        OverlappingRanges<ContentCtx> overlaps = this.segments.searchOverlaps(accessRange);
        if (overlaps.size() != 1) {
            return null;
        }
        ContentCtx segment = overlaps.iterator().next()._2();
        return this.concreteAddresses.get(segment.getAddress()).get();
    }

    public RootStateBuilder addSegmentCtx(ContentCtx ctx) {
        int BYTESIZE = 8;
        BigInt startAddress = ctx.getAddress().mul(BYTESIZE);
        FiniteRange segmentRange = FiniteRange.of(startAddress, (ctx.getSize() - 1L) * (long)BYTESIZE + 1L);
        OverlappingRanges<ContentCtx> overlappingSegments = this.segments.searchOverlaps(segmentRange);
        if (!overlappingSegments.isEmpty()) {
            throw new DomainStateException.InvariantViolationException();
        }
        this.segments = this.segments.bind(segmentRange, ctx);
        return this;
    }

    public RootStateBuilder addRegister(MemVar region) {
        if (this.regions.contains(region)) {
            return this;
        }
        this.regions = this.regions.insert(region);
        this.contexts = this.contexts.bind((Object)region, (Object)RegionCtx.EMPTYSTICKY);
        this.childOps.addRegionIntro(region, RegionCtx.EMPTYSTICKY);
        return this;
    }

    public void setAddressOf(MemVar regionId, NumVar addressVariable) {
        this.regionToAddress = this.regionToAddress.bind((Object)regionId, (Object)addressVariable);
        this.addressToRegion = this.addressToRegion.bind((Object)addressVariable, (Object)regionId);
    }

    public void introduce(MemVar region, RegionCtx regionCtx) {
        if (this.contexts.contains(region)) {
            throw new DomainStateException.VariableSupportSetException();
        }
        this.contexts = this.contexts.bind((Object)region, (Object)regionCtx);
        this.regions = this.regions.insert(region);
    }

    void makeCompatible(RootStateBuilder other) {
        this.mergeRegionsAndContexts(other);
        this.mergeAddresses(other);
        this.mergeSegments(other);
    }

    private void mergeRegionsAndContexts(RootStateBuilder other) {
        RegionCtx ctx;
        MemVarSet inBoth = this.regions.intersection(other.regions);
        MemVarSet onlyInFst = this.regions.difference(inBoth);
        MemVarSet onlyInSnd = other.regions.difference(inBoth);
        for (MemVar r : onlyInFst) {
            ctx = this.contexts.get(r).get();
            other.contexts = other.contexts.bind((Object)r, (Object)ctx);
            other.regions = other.regions.insert(r);
            other.childOps.addRegionIntro(r, ctx);
        }
        for (MemVar r : onlyInSnd) {
            ctx = other.contexts.get(r).get();
            this.contexts = this.contexts.bind((Object)r, (Object)ctx);
            this.regions = this.regions.insert(r);
            this.childOps.addRegionIntro(r, ctx);
        }
    }

    private void mergeAddresses(RootStateBuilder other) {
        NumVar symbolicAddress;
        MemVar region;
        ThreeWaySplit<AVLMap<MemVar, NumVar>> regionToAddressSplit = this.regionToAddress.split(other.regionToAddress);
        assert (regionToAddressSplit.inBothButDiffering().isEmpty());
        for (P2<MemVar, NumVar> p2 : regionToAddressSplit.onlyInFirst()) {
            region = p2._1();
            symbolicAddress = p2._2();
            other.regionToAddress = other.regionToAddress.bind((Object)region, (Object)symbolicAddress);
            other.addressToRegion = other.addressToRegion.bind((Object)symbolicAddress, (Object)region);
            other.childOps.addIntro(symbolicAddress, Type.Address);
        }
        for (P2<MemVar, NumVar> p2 : regionToAddressSplit.onlyInSecond()) {
            region = p2._1();
            symbolicAddress = p2._2();
            this.regionToAddress = this.regionToAddress.bind((Object)region, (Object)symbolicAddress);
            this.addressToRegion = this.addressToRegion.bind((Object)symbolicAddress, (Object)region);
            this.childOps.addIntro(symbolicAddress, Type.Address);
        }
        ThreeWaySplit<AVLMap<NumVar, MemVar>> addressToRegionSplit = this.addressToRegion.split(other.addressToRegion);
        assert (addressToRegionSplit.onlyInFirst().isEmpty());
        assert (addressToRegionSplit.onlyInSecond().isEmpty());
        assert (addressToRegionSplit.inBothButDiffering().isEmpty());
    }

    private void mergeSegments(RootStateBuilder other) {
        ThreeWaySplit<FiniteRangeTree<ContentCtx>> split = this.segments.split(other.segments);
        assert (split.onlyInFirst().isEmpty());
        assert (split.onlyInSecond().isEmpty());
        assert (split.inBothButDiffering().isEmpty());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: " + this.childOps);
        builder.append("\n");
        builder.append(this.build());
        return builder.toString();
    }

    public RootState build() {
        return new RootState(this.regions, this.regionToAddress, this.addressToRegion, this.contexts, this.segments, this.concreteAddresses);
    }

    <Child extends MemoryDomain<Child>> RootRegionAccess resolveReference(Rhs.Rval address, Child child) {
        if (address instanceof Rhs.Rlit) {
            Rhs.Rlit addressLiteral = (Rhs.Rlit)address;
            BigInt addressInBytes = addressLiteral.getValue();
            BigInt addressInBits = addressInBytes.mul(Bound.EIGHT);
            Interval accessRange = Interval.of(addressInBits, addressInBits.add(BigInt.of(addressLiteral.getSize() - 1)));
            MemVar regionId = this.regionOf(accessRange);
            RegionCtx region = this.contexts.get(regionId).get();
            Range offset = Range.from(Interval.of(addressInBytes.sub(region.getAddress().get())));
            return RootRegionAccess.explicit(regionId, offset);
        }
        if (address instanceof Rhs.Rvar) {
            Rhs.Rvar variable = (Rhs.Rvar)address;
            List<P2<AbstractPointer, Child>> pointsTo = child.deprecatedDeref(variable.getSize(), address, VarSet.empty());
            if (pointsTo.isEmpty()) {
                child.getContext().addWarning(new ReadFromUnknownPointerInfo(Range.from(Interval.TOP)));
                return null;
            }
            AbstractPointer dRef = pointsTo.get(0)._1();
            SymbolicOffset offset = new SymbolicOffset(dRef.offset);
            if (dRef.isAbsolute()) {
                Range accessRange = child.queryRange(variable);
                MemVar regionId = this.regionOf(accessRange.convexHull().mul(BigInt.of(8L)));
                if (regionId == null) {
                    child.getContext().addWarning(new ReadFromUnknownPointerInfo(accessRange));
                    return null;
                }
                assert (regionId != null);
                return new RootRegionAccess(dRef.address, new AbstractMemPointer(regionId, offset));
            }
            MemVar regionId = this.regionOf(dRef.address);
            assert (regionId != null);
            return new RootRegionAccess(dRef.address, new AbstractMemPointer(regionId, offset));
        }
        throw new DomainStateException.InvariantViolationException();
    }

    public final <D extends MemoryDomain<D>> D applyChildOps(D state) {
        return this.childOps.apply(state);
    }
}

