/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.zeno;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.debug.XmlPrintHelpers;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.zeno.Entailment;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.MultiMap;
import javalx.persistentcollections.ThreeWaySplit;

class PredicatesState
extends FunctorState {
    private final MultiMap<Zeno.Test, Zeno.Test> forward;
    private final MultiMap<Zeno.Test, Zeno.Test> backward;
    private final MultiMap<NumVar, Zeno.Test> occurences;
    public static final PredicatesState EMPTY = new PredicatesState();
    private static final boolean removePredicateTautologies = true;
    private static final boolean removeImplicationTautologies = true;

    private PredicatesState(MultiMap<Zeno.Test, Zeno.Test> forward, MultiMap<Zeno.Test, Zeno.Test> backward, MultiMap<NumVar, Zeno.Test> occurrences) {
        this.forward = forward;
        this.backward = backward;
        this.occurences = occurrences;
        assert (this.isConsistent());
    }

    private PredicatesState() {
        this(MultiMap.empty(), MultiMap.empty(), MultiMap.empty());
    }

    private boolean isConsistent() {
        for (P2<Zeno.Test, Zeno.Test> p2 : this.forward) {
            Zeno.Test lhs = p2._1();
            Zeno.Test rhs = p2._2();
            if (!this.backward.get(rhs).contains(lhs)) {
                return false;
            }
            for (NumVar variable : lhs.getVars()) {
                if (this.occurences.get(variable).contains(lhs)) continue;
                return false;
            }
        }
        for (P2<Zeno.Test, Zeno.Test> p2 : this.backward) {
            Zeno.Test rhs = p2._1();
            Zeno.Test lhs = p2._2();
            if (!this.forward.get(lhs).contains(rhs)) {
                return false;
            }
            for (NumVar variable : rhs.getVars()) {
                if (this.occurences.get(variable).contains(rhs)) continue;
                return false;
            }
        }
        for (P2<Comparable<Zeno.Test>, Zeno.Test> p2 : this.occurences) {
            NumVar variable = (NumVar)p2._1();
            Zeno.Test test = p2._2();
            if (!test.getVars().contains(variable)) {
                return false;
            }
            if (this.forward.contains(test) || this.backward.contains(test)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "#" + this.size() + " " + this.contentToString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
        builder.append(domainName + ": " + this.toString());
        builder.append('\n');
    }

    private int size() {
        int count = 0;
        Iterator<P2<Zeno.Test, Zeno.Test>> iterator = this.forward.iterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    private String contentToString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        SortedSet<Zeno.Test> sorted = StringHelpers.sortLexically(this.forward.keys());
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            Zeno.Test premise = (Zeno.Test)iterator.next();
            AVLSet<Zeno.Test> implications = this.forward.get(premise);
            for (Zeno.Test implication : implications) {
                builder.append(premise);
                builder.append(" \u2192 ");
                builder.append(implication);
                builder.append(", ");
            }
            if (iterator.hasNext()) continue;
            builder.setLength(builder.length() - 2);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e(XmlPrintHelpers.sanitize("PREDICATES(Z)"));
        for (P2<Zeno.Test, Zeno.Test> p2 : this.forward) {
            builder = builder.e("Entry").a("type", "Implication");
            builder = builder.e("Premise");
            builder = p2._1().toXML(builder);
            builder = builder.up();
            builder = builder.e("Consequence");
            builder = p2._2().toXML(builder);
            builder = builder.up();
            builder = builder.up();
        }
        builder = builder.up();
        return builder;
    }

    public MutableState toMutable() {
        return new MutableState(this.forward, this.backward, this.occurences);
    }

    static class MutableState {
        private MultiMap<Zeno.Test, Zeno.Test> forward;
        private MultiMap<Zeno.Test, Zeno.Test> backward;
        private MultiMap<NumVar, Zeno.Test> occurrences;

        private MutableState(MultiMap<Zeno.Test, Zeno.Test> forward, MultiMap<Zeno.Test, Zeno.Test> backward, MultiMap<NumVar, Zeno.Test> occurrences) {
            this.forward = forward;
            this.backward = backward;
            this.occurrences = occurrences;
        }

        public PredicatesState toImmutable() {
            return new PredicatesState(this.forward, this.backward, this.occurrences);
        }

        public String toString() {
            return this.toImmutable().toString();
        }

        public boolean contains(NumVar variable) {
            return this.occurrences.contains(variable);
        }

        public void addImplication(Zeno.Test premise, Zeno.Test consequence) {
            this.forward = this.forward.add(premise, consequence);
            this.backward = this.backward.add(consequence, premise);
            this.addOccurrencesFor(premise);
            this.addOccurrencesFor(consequence);
        }

        public Iterable<P2<Zeno.Test, Zeno.Test>> getImplications() {
            return this.forward;
        }

        public AVLSet<Zeno.Test> getConsequences(Zeno.Test predicate) {
            return this.forward.get(predicate);
        }

        public AVLSet<Zeno.Test> getPremises(Zeno.Test predicate) {
            return this.backward.get(predicate);
        }

        public Iterable<Zeno.Test> getAllLhs() {
            return this.forward.keys();
        }

        public Iterable<Zeno.Test> getAllLhsContaining(VarSet vars) {
            AVLSet<Zeno.Test> lhs = AVLSet.empty();
            for (NumVar var : vars) {
                for (Zeno.Test predicate : this.occurrences.get(var)) {
                    if (!this.isLhs(predicate)) continue;
                    lhs = lhs.add(predicate);
                }
            }
            return lhs;
        }

        public Iterable<Zeno.Test> getAllRhs() {
            return this.backward.keys();
        }

        public AVLSet<Zeno.Test> getTestsContainingOnly(VarSet variables) {
            AVLSet<Zeno.Test> result = AVLSet.empty();
            for (NumVar variable : variables) {
                result = result.union(this.occurrences.get(variable));
            }
            for (Zeno.Test test : result) {
                if (variables.containsAll(test.getVars())) continue;
                result = result.remove(test);
            }
            return result;
        }

        public Iterable<Zeno.Test> getAllRhsContaining(VarSet vars) {
            AVLSet<Zeno.Test> rhs = AVLSet.empty();
            for (NumVar var : vars) {
                for (Zeno.Test predicate : this.occurrences.get(var)) {
                    if (!this.isRhs(predicate)) continue;
                    rhs = rhs.add(predicate);
                }
            }
            return rhs;
        }

        public void removePredicatesContaining(NumVar variable) {
            AVLSet<Zeno.Test> occs = this.occurrences.get(variable);
            if (occs.isEmpty()) {
                return;
            }
            for (Zeno.Test test : occs) {
                this.removePredicate(test);
            }
        }

        public void removePredicatesNotContaining(VarSet variables) {
            AVLSet<Zeno.Test> toBeKept = this.getTestsContainingOnly(variables);
            MultiMap<Zeno.Test, Zeno.Test> newForward = MultiMap.empty();
            MultiMap<Zeno.Test, Zeno.Test> newBackward = MultiMap.empty();
            MultiMap<NumVar, Zeno.Test> newOccurrences = MultiMap.empty();
            for (Zeno.Test test : toBeKept) {
                AVLSet<Zeno.Test> newValues;
                AVLSet<Zeno.Test> oldValues;
                if (this.isLhs(test)) {
                    oldValues = this.forward.get(test);
                    newValues = oldValues.intersection(toBeKept);
                    newForward = newForward.add(test, newValues);
                }
                if (this.isRhs(test)) {
                    oldValues = this.backward.get(test);
                    newValues = oldValues.intersection(toBeKept);
                    newBackward = newBackward.add(test, newValues);
                }
                if (!newForward.contains(test) && !newBackward.contains(test)) continue;
                for (NumVar variable : test.getVars()) {
                    newOccurrences = newOccurrences.add(variable, test);
                }
            }
            this.forward = newForward;
            this.backward = newBackward;
            this.occurrences = newOccurrences;
        }

        private void removePredicate(Zeno.Test predicate) {
            this.removeOccurencesOf(predicate);
            if (this.isLhs(predicate)) {
                for (Zeno.Test rhs : this.forward.get(predicate)) {
                    this.backward = this.backward.remove(rhs, predicate);
                    if (this.forward.contains(rhs) || this.backward.contains(rhs)) continue;
                    this.removeOccurencesOf(rhs);
                }
                this.forward = this.forward.remove(predicate);
            }
            if (this.isRhs(predicate)) {
                for (Zeno.Test lhs : this.backward.get(predicate)) {
                    this.forward = this.forward.remove(lhs, predicate);
                    if (this.forward.contains(lhs) || this.backward.contains(lhs)) continue;
                    this.removeOccurencesOf(lhs);
                }
                this.backward = this.backward.remove(predicate);
            }
        }

        public void substituteInPredicates(Substitution substitution) {
            NumVar substitutedVar = substitution.getVar();
            if (substitution.isSimple() && substitutedVar.equalTo(substitution.getExpr().getSingleVarOrNull())) {
                return;
            }
            AVLSet<Zeno.Test> originalPredicates = this.occurrences.get(substitutedVar);
            if (originalPredicates.isEmpty()) {
                return;
            }
            List<P2<Zeno.Test, Zeno.Test>> originalImplications = this.toImplicationTuples(originalPredicates);
            LinkedList<P2<Zeno.Test, Zeno.Test>> substitutedImplications = new LinkedList<P2<Zeno.Test, Zeno.Test>>();
            this.removePredicatesContaining(substitutedVar);
            for (P2<Zeno.Test, Zeno.Test> implication : originalImplications) {
                Zeno.Test originalConsequence;
                Zeno.Test substitutedConsequence;
                Zeno.Test originalPremise = implication._1();
                Zeno.Test substitutedPremise = originalPremise.applySubstitution(substitution);
                if (substitutedPremise.equals(substitutedConsequence = (originalConsequence = implication._2()).applySubstitution(substitution)) || ZenoTestHelper.isTautology(substitutedPremise) || ZenoTestHelper.isTautology(substitutedConsequence)) continue;
                substitutedImplications.add(P2.tuple2(substitutedPremise, substitutedConsequence));
            }
            for (P2<Zeno.Test, Zeno.Test> implication : substitutedImplications) {
                this.addImplication(implication._1(), implication._2());
            }
        }

        private List<P2<Zeno.Test, Zeno.Test>> toImplicationTuples(AVLSet<Zeno.Test> predicates) {
            LinkedList<P2<Zeno.Test, Zeno.Test>> implications = new LinkedList<P2<Zeno.Test, Zeno.Test>>();
            for (Zeno.Test predicate : predicates) {
                if (this.isLhs(predicate)) {
                    for (Zeno.Test rhs : this.forward.get(predicate)) {
                        implications.add(P2.tuple2(predicate, rhs));
                    }
                }
                if (!this.isRhs(predicate)) continue;
                for (Zeno.Test lhs : this.backward.get(predicate)) {
                    implications.add(P2.tuple2(lhs, predicate));
                }
            }
            return implications;
        }

        private boolean isLhs(Zeno.Test predicate) {
            return this.forward.contains(predicate);
        }

        private boolean isRhs(Zeno.Test predicate) {
            return this.backward.contains(predicate);
        }

        private void addOccurrencesFor(Zeno.Test predicate) {
            for (NumVar variable : predicate.getVars()) {
                this.occurrences = this.occurrences.add(variable, predicate);
            }
        }

        private void removeOccurencesOf(Zeno.Test predicate) {
            for (NumVar variable : predicate.getVars()) {
                this.occurrences = this.occurrences.remove(variable, predicate);
            }
        }

        public void union(MutableState otherState) {
            this.forward = this.forward.union(otherState.forward);
            this.backward = this.backward.union(otherState.backward);
            this.occurrences = this.occurrences.union(otherState.occurrences);
        }

        public void intersect(MutableState otherState) {
            this.forward = this.forward.intersection(otherState.forward);
            this.backward = this.backward.intersection(otherState.backward);
            this.occurrences = MultiMap.empty();
            for (P2<Zeno.Test, Zeno.Test> p2 : this.forward) {
                this.addOccurrencesFor(p2._1());
                this.addOccurrencesFor(p2._2());
            }
        }

        public static <D extends ZenoDomain<D>> boolean isEntailed(MutableState otherState, MutableState inState, D inChildState) {
            ThreeWaySplit<MultiMap<Zeno.Test, Zeno.Test>> split = otherState.forward.splitWithDifference(inState.forward);
            if (split.onlyInFirst().isEmpty() && split.inBothButDiffering().isEmpty()) {
                return true;
            }
            MultiMap<Zeno.Test, Zeno.Test> leftOverImplications = split.onlyInFirst().union(split.inBothButDiffering());
            return Entailment.areAllImplicationsSemanticallyEntailed(leftOverImplications, inChildState);
        }

        public static <D extends ZenoDomain<D>> MutableState getEntailed(MutableState otherState, MutableState inState, D inChildState) {
            ThreeWaySplit<MultiMap<Zeno.Test, Zeno.Test>> split = otherState.forward.splitWithDifference(inState.forward);
            if (split.onlyInFirst().isEmpty() && split.inBothButDiffering().isEmpty()) {
                return otherState;
            }
            MultiMap<Zeno.Test, Zeno.Test> leftOverImplications = split.onlyInFirst().union(split.inBothButDiffering());
            MultiMap<Zeno.Test, Zeno.Test> syntacticallyEntailed = otherState.forward.difference(leftOverImplications);
            MultiMap<Zeno.Test, Zeno.Test> semanticallyEntailed = Entailment.getAllSemanticallyEntailedImplications(leftOverImplications, inChildState);
            MultiMap<Object, Object> entailed = MultiMap.empty();
            entailed = entailed.union(syntacticallyEntailed);
            entailed = entailed.union(semanticallyEntailed);
            MutableState result = EMPTY.toMutable();
            for (P2<Object, Object> p2 : entailed) {
                Zeno.Test lhs = (Zeno.Test)p2._1();
                Zeno.Test rhs = (Zeno.Test)p2._2();
                result.addImplication(lhs, rhs);
            }
            return result;
        }
    }
}

