/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.zeno;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoVisitor;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.zeno.PredicatesStateBuilder;
import javalx.numeric.Bound;

class PredicatesAssignmentVisitor {
    PredicatesAssignmentVisitor() {
    }

    public static void run(Zeno.Assign assign, PredicatesStateBuilder builder) {
        Visitor visitor = new Visitor(assign.getLhs().getId());
        assign.getRhs().accept(visitor, builder);
    }

    private static class Visitor
    implements ZenoVisitor<Void, PredicatesStateBuilder> {
        private final NumVar lhsVariable;

        public Visitor(NumVar lhsVariable) {
            this.lhsVariable = lhsVariable;
        }

        @Override
        public Void visit(Zeno.Assign stmt, PredicatesStateBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public Void visit(Zeno.Lhs variable, PredicatesStateBuilder builder) {
            throw new IllegalStateException();
        }

        @Override
        public Void visit(Zeno.Bin expr, PredicatesStateBuilder builder) {
            builder.project(this.lhsVariable);
            return null;
        }

        @Override
        public Void visit(Zeno.RangeRhs range, PredicatesStateBuilder builder) {
            builder.project(this.lhsVariable);
            return null;
        }

        @Override
        public Void visit(Zeno.Rlin lin, PredicatesStateBuilder builder) {
            if (!builder.contains(this.lhsVariable)) {
                return null;
            }
            if (!lin.getDivisor().isOne()) {
                builder.project(this.lhsVariable);
                return null;
            }
            Linear rhs = lin.getLinearTerm();
            if (rhs.contains(this.lhsVariable)) {
                Substitution substitution = Substitution.invertingSubstitution(rhs, Bound.ONE, this.lhsVariable);
                builder.substitute(substitution);
            } else {
                builder.project(this.lhsVariable);
            }
            return null;
        }
    }
}

