/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.zeno;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.data.FoldMap;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.Summarization;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.predicates.PredicatesProperties;
import bindead.domains.predicates.zeno.Entailment;
import bindead.domains.predicates.zeno.PredicatesAssignmentVisitor;
import bindead.domains.predicates.zeno.PredicatesState;
import bindead.domains.predicates.zeno.PredicatesStateBuilder;
import bindead.exceptions.Unreachable;
import java.util.HashSet;
import java.util.Set;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.MultiMap;

public class Predicates<D extends ZenoDomain<D>>
extends ZenoFunctor<PredicatesState, D, Predicates<D>> {
    public static final String NAME = "PREDICATES(Z)";
    private final boolean DEBUGASSIGN;
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGSUBSET;
    private final boolean DEBUGOTHER;
    private final SetOfEquations newEqualities;

    public Predicates(D child) {
        this(PredicatesState.EMPTY, child, SetOfEquations.empty());
    }

    private Predicates(PredicatesState state, D childState, SetOfEquations newEqualities) {
        super(NAME, state, childState);
        this.DEBUGASSIGN = PredicatesProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGBINARIES = PredicatesProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGSUBSET = PredicatesProperties.INSTANCE.debugSubsetOrEqual.isTrue();
        this.DEBUGOTHER = PredicatesProperties.INSTANCE.debugOther.isTrue();
        this.newEqualities = newEqualities;
    }

    private Predicates<D> build(PredicatesState state, D childState, SetOfEquations newEqualities) {
        return new Predicates<D>(state, childState, newEqualities);
    }

    @Override
    public Predicates<D> build(PredicatesState state, D childState) {
        return this.build(state, childState, SetOfEquations.empty());
    }

    @Override
    public Predicates<D> eval(Zeno.Assign assign) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesAssignmentVisitor.run(assign, builder);
        if (this.DEBUGASSIGN) {
            System.out.println(this.name + ":");
            System.out.println("  evaluating: " + assign);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.eval(assign);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Predicates<D> eval(Zeno.Test test) throws Unreachable {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        P3<ZenoDomain, SetOfEquations, MultiMap<Zeno.Test, Zeno.Test>> result = this.fixApply(test, (ZenoDomain)this.childState, builder, new HashSet<Zeno.Test>());
        ZenoDomain newChildState = result._1();
        SetOfEquations newEqualities = result._2();
        Predicates.addSynthesizedPredicates(result._3(), builder);
        return this.build(builder.build(), newChildState, newEqualities);
    }

    private P3<D, SetOfEquations, MultiMap<Zeno.Test, Zeno.Test>> fixApply(Zeno.Test test, D state, PredicatesStateBuilder builder, Set<Zeno.Test> alreadyAppliedTests) {
        if (AnalysisProperties.INSTANCE.debugTests.isTrue().booleanValue()) {
            System.out.println("Predicates test: " + test);
        }
        Object newChildState = state.eval(test);
        alreadyAppliedTests.add(test);
        SynthChannel synthChannel = newChildState.getSynthChannel();
        SetOfEquations newEqualities = synthChannel.getEquations();
        MultiMap<Zeno.Test, Zeno.Test> newImplications = synthChannel.getImplications();
        AVLSet<Object> newImpliedTests = AVLSet.empty();
        newImpliedTests = newImpliedTests.union(Entailment.getSyntacticallyEntailed(test, builder));
        VarSet modifiedVars = test.getVars().union(newEqualities.getVars());
        newImpliedTests = newImpliedTests.union(Entailment.getSemanticallyEntailed(newChildState, modifiedVars, builder));
        for (Zeno.Test test2 : Entailment.equalitiesToTests(newEqualities)) {
            if (alreadyAppliedTests.contains(test2)) continue;
            newImpliedTests = newImpliedTests.union(Entailment.getSyntacticallyEntailed(test2, builder));
            newImpliedTests = newImpliedTests.union(Entailment.getSemanticallyEntailed(newChildState, test2.getVars(), builder));
        }
        for (Zeno.Test test3 : newImpliedTests) {
            if (alreadyAppliedTests.contains(test3)) continue;
            P3 result = this.fixApply(test3, newChildState, builder, alreadyAppliedTests);
            newChildState = (ZenoDomain)result._1();
            newEqualities = newEqualities.union(result._2());
            newImplications = newImplications.union(result._3());
        }
        return P3.tuple3(newChildState, newEqualities, newImplications);
    }

    @Override
    public Predicates<D> project(VarSet vars) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        for (NumVar variable : vars) {
            builder.project(variable);
            if (!this.DEBUGOTHER) continue;
            System.out.println(this.name + ":");
            System.out.println("  projecting: " + variable);
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Predicates<D> substitute(NumVar x, NumVar y) {
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        builder.substitute(x, y);
        if (this.DEBUGOTHER) {
            System.out.println(this.name + ":");
            System.out.println("  substitute: [" + x + "\\" + y + "]");
            System.out.println("  before: " + this.state);
            System.out.println("  after: " + builder.build());
        }
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public boolean subsetOrEqual(Predicates<D> other) {
        PredicatesStateBuilder thisBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesStateBuilder otherBuilder = new PredicatesStateBuilder((PredicatesState)other.state, (QueryChannel)((Object)other.childState));
        boolean isSubset = thisBuilder.isSubset(otherBuilder);
        if (this.DEBUGSUBSET) {
            System.out.println("PREDICATES(Z):");
            System.out.println(" subset-or-equal: " + isSubset);
            System.out.println("    fst: " + this.state);
            System.out.println("    snd: " + other.state);
        }
        if (!isSubset) {
            return false;
        }
        return ((ZenoDomain)this.childState).subsetOrEqual(other.childState);
    }

    @Override
    public Predicates<D> join(Predicates<D> other) {
        PredicatesStateBuilder thisBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesStateBuilder otherBuilder = new PredicatesStateBuilder((PredicatesState)other.state, (QueryChannel)((Object)other.childState));
        PredicatesStateBuilder joinedBuilder = thisBuilder.join(otherBuilder);
        ZenoDomain joinedChildState = (ZenoDomain)((ZenoDomain)this.childState).join(other.childState);
        Predicates.addSynthesizedPredicates(joinedChildState.getSynthChannel().getImplications(), joinedBuilder);
        return this.build(joinedBuilder.build(), (D)joinedChildState);
    }

    @Override
    public Predicates<D> widen(Predicates<D> other) {
        PredicatesStateBuilder thisBuilder = new PredicatesStateBuilder((PredicatesState)this.state, (QueryChannel)((Object)this.childState));
        PredicatesStateBuilder otherBuilder = new PredicatesStateBuilder((PredicatesState)other.state, (QueryChannel)((Object)other.childState));
        PredicatesStateBuilder joinedBuilder = thisBuilder.join(otherBuilder);
        ZenoDomain widenedChildState = (ZenoDomain)((ZenoDomain)this.childState).widen(other.childState);
        Predicates.addSynthesizedPredicates(widenedChildState.getSynthChannel().getImplications(), joinedBuilder);
        return this.build(joinedBuilder.build(), (D)widenedChildState);
    }

    private static void addSynthesizedPredicates(MultiMap<Zeno.Test, Zeno.Test> implications, PredicatesStateBuilder builder) {
        for (P2<Zeno.Test, Zeno.Test> p2 : implications) {
            builder.addImplication(p2._1(), p2._2());
        }
    }

    @Override
    public Predicates<D> expand(FoldMap pairs) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).expand(pairs);
        PredicatesStateBuilder oldStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        PredicatesStateBuilder newStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        newStateBuilder.renameExpand(pairs);
        newStateBuilder.union(oldStateBuilder);
        return this.build(newStateBuilder.build(), (D)newChildState);
    }

    @Override
    public Predicates<D> fold(FoldMap pairs) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).fold(pairs);
        PredicatesStateBuilder oldStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        PredicatesStateBuilder newStateBuilder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        newStateBuilder.renameFold(pairs);
        newStateBuilder.intersect(oldStateBuilder);
        return this.build(newStateBuilder.build(), (D)newChildState);
    }

    @Override
    public Predicates<D> copyAndPaste(VarSet vars, Predicates<D> from) {
        ZenoDomain newChildState = (ZenoDomain)((ZenoDomain)this.childState).copyAndPaste(vars, (Summarization)((Object)from.childState));
        PredicatesStateBuilder builder = new PredicatesStateBuilder((PredicatesState)this.state, newChildState);
        builder.copyAndPaste(vars, new PredicatesStateBuilder((PredicatesState)from.state, (QueryChannel)((Object)from.childState)));
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel synth = super.getSynthChannel();
        synth.addEquations(this.newEqualities);
        return synth;
    }
}

