/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.XmlPrintHelpers;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.finite.Entailment;
import com.jamesmurty.utils.XMLBuilder;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn2;
import javalx.fn.Predicate;
import javalx.mutablecollections.CollectionHelpers;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;

class PredicatesState
extends FunctorState {
    public static final PredicatesState EMPTY = new PredicatesState();
    private final AVLMap<Flag, AVLSet<Finite.Test>> predicates;
    private final AVLMap<NumVar, AVLSet<Flag>> varOccurrences;

    private PredicatesState(AVLMap<Flag, AVLSet<Finite.Test>> predicates, AVLMap<NumVar, AVLSet<Flag>> varOccurrences) {
        this.predicates = predicates;
        this.varOccurrences = varOccurrences;
        assert (this.isConsistent());
    }

    private PredicatesState() {
        this(AVLMap.empty(), AVLMap.empty());
    }

    private boolean isConsistent() {
        AVLSet<Finite.Test> flagPredicates;
        Flag flag;
        VarSet flagVars = VarSet.empty();
        VarSet predicateVars = VarSet.empty();
        for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
            flag = p2._1();
            flagVars = flagVars.add(flag.flagVariable);
            flagPredicates = p2._2();
            predicateVars = predicateVars.union(PredicatesState.getVariablesInPredicates(flagPredicates));
        }
        if (flagVars.containsAny(predicateVars)) {
            return false;
        }
        for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
            AVLSet aVLSet;
            flag = p2._1();
            flagPredicates = p2._2();
            if (flagPredicates.intersection(aVLSet = this.predicates.get(flag.negate()).getOrElse(AVLSet.empty())).isEmpty()) continue;
            return false;
        }
        for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
            flag = p2._1();
            for (NumVar numVar : PredicatesState.getVariablesInPredicates(p2._2())) {
                AVLSet<Flag> occurences = this.varOccurrences.get(numVar).getOrElse(AVLSet.empty());
                if (occurences.contains(flag)) continue;
                return false;
            }
        }
        for (P2<Comparable<Flag>, AVLSet<Comparable<Finite.Test>>> p2 : this.varOccurrences) {
            NumVar var = (NumVar)p2._1();
            for (Flag flag2 : p2._2()) {
                Option<AVLSet<Finite.Test>> predsOption = this.predicates.get(flag2);
                if (predsOption.isNone()) {
                    return false;
                }
                if (PredicatesState.getVariablesInPredicates(predsOption.get()).contains(var)) continue;
                return false;
            }
        }
        return true;
    }

    public MutableState toMutable() {
        return new MutableState(this.predicates, this.varOccurrences);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e(XmlPrintHelpers.sanitize("PREDICATES(F)"));
        for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
            Finite.Test flagTest = p2._1().asTest();
            for (Finite.Test consequence : p2._2()) {
                builder = builder.e("Entry").a("type", "Implication");
                builder = builder.e("Premise");
                builder = flagTest.toXML(builder);
                builder = builder.up();
                builder = builder.e("Consequence");
                builder = consequence.toXML(builder);
                builder = builder.up();
                builder = builder.up();
            }
        }
        builder = builder.up();
        return builder;
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
        builder.append(domainName + ": " + this.toString());
        builder.append('\n');
    }

    private P2<AVLMap<NumVar, AVLSet<Finite.Test>>, AVLMap<NumVar, AVLSet<Finite.Test>>> splitFlagsMap() {
        FiniteMap truePredicates = AVLMap.empty();
        FiniteMap falsePredicates = AVLMap.empty();
        for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
            Flag flag = p2._1();
            if (flag.isTrue()) {
                truePredicates = truePredicates.bind(flag.flagVariable, p2._2());
                continue;
            }
            falsePredicates = falsePredicates.bind(flag.flagVariable, p2._2());
        }
        return P2.tuple2(truePredicates, falsePredicates);
    }

    public String toString() {
        return "#" + this.predicates.size() + " " + this.contentToString();
    }

    private String contentToString() {
        AVLSet<Finite.Test> trueSet;
        NumVar flag;
        P2<AVLMap<NumVar, AVLSet<Finite.Test>>, AVLMap<NumVar, AVLSet<Finite.Test>>> splitup = this.splitFlagsMap();
        AVLMap<NumVar, AVLSet<Finite.Test>> truePredicates = splitup._1();
        AVLMap<NumVar, AVLSet<Finite.Test>> falsePredicates = splitup._2();
        ThreeWaySplit<AVLMap<NumVar, AVLSet<Finite.Test>>> threeWaySplitup = truePredicates.split(falsePredicates);
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (P2<NumVar, AVLSet<Finite.Test>> p2 : threeWaySplitup.inBothButDiffering()) {
            flag = p2._1();
            trueSet = p2._2();
            AVLSet<Finite.Test> falseSet = falsePredicates.getOrNull(flag);
            builder.append(flag);
            builder.append("\u2192");
            builder.append(trueSet);
            builder.append(" \u00ac");
            builder.append(flag);
            builder.append("\u2192");
            builder.append(falseSet);
            builder.append(", ");
        }
        for (P2<NumVar, AVLSet<Finite.Test>> p2 : threeWaySplitup.onlyInFirst()) {
            flag = p2._1();
            trueSet = p2._2();
            builder.append(flag);
            builder.append("\u2192");
            builder.append(trueSet);
            builder.append(", ");
        }
        for (P2<NumVar, AVLSet<Finite.Test>> p2 : threeWaySplitup.onlyInSecond()) {
            flag = p2._1();
            AVLSet<Finite.Test> falseSet = p2._2();
            builder.append("\u00ac");
            builder.append(flag);
            builder.append("\u2192");
            builder.append(falseSet);
            builder.append(", ");
        }
        if (builder.length() > 2) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("}");
        return builder.toString();
    }

    static VarSet getVariablesInPredicates(AVLSet<Finite.Test> preds) {
        VarSet vars = VarSet.empty();
        for (Finite.Test pred : preds) {
            vars = vars.union(pred.getVars());
        }
        return vars;
    }

    static class MutableState {
        private AVLMap<Flag, AVLSet<Finite.Test>> predicates;
        private AVLMap<NumVar, AVLSet<Flag>> varOccurrences;

        public MutableState(AVLMap<Flag, AVLSet<Finite.Test>> predicates, AVLMap<NumVar, AVLSet<Flag>> varOccurrences) {
            this.predicates = predicates;
            this.varOccurrences = varOccurrences;
        }

        public PredicatesState toImmutable() {
            return new PredicatesState(this.predicates, this.varOccurrences);
        }

        public String toString() {
            return this.toImmutable().toString();
        }

        public boolean isFlag(NumVar flag) {
            return this.predicates.contains(Flag.asTrue(flag)) || this.predicates.contains(Flag.asFalse(flag));
        }

        public boolean isPredicatesVar(NumVar var) {
            return this.varOccurrences.contains(var);
        }

        public VarSet getAllPredicateVars() {
            return VarSet.fromKeys(this.varOccurrences);
        }

        public VarSet getAllFlagVars() {
            VarSet flagVars = VarSet.empty();
            for (P2<Flag, AVLSet<Finite.Test>> p2 : this.predicates) {
                Flag flag = p2._1();
                flagVars = flagVars.add(flag.flagVariable);
            }
            return flagVars;
        }

        public AVLSet<Finite.Test> getPredicates(NumVar flag, boolean flagValuation) {
            return this.getPredicates(Flag.toFlag(flag, flagValuation));
        }

        public AVLSet<Finite.Test> getPredicates(Flag flag) {
            return this.predicates.get(flag).getOrElse(AVLSet.empty());
        }

        public AVLSet<Flag> getFlagsFromVars(VarSet vars) {
            AVLSet<Flag> result = AVLSet.empty();
            for (NumVar variable : vars) {
                Flag falseFlag;
                Flag trueFlag = Flag.asTrue(variable);
                if (this.predicates.contains(trueFlag)) {
                    result = result.add(trueFlag);
                }
                if (!this.predicates.contains(falseFlag = Flag.asFalse(variable))) continue;
                result = result.add(falseFlag);
            }
            return result;
        }

        public void addPredicate(NumVar flagVar, boolean flagValuation, Finite.Test predicate) {
            Flag flag = Flag.toFlag(flagVar, flagValuation);
            AVLSet<Finite.Test> newPreds = this.getPredicates(flag).add(predicate);
            for (NumVar var : predicate.getVars()) {
                this.addVariableOccurrenceInPredicatesOf(flag, var);
            }
            this.setPredicates(flag, newPreds);
        }

        public void addPredicates(Flag flag, AVLSet<Finite.Test> predicatesToAdd) {
            AVLSet<Finite.Test> newPreds = this.getPredicates(flag).union(predicatesToAdd);
            for (NumVar var : PredicatesState.getVariablesInPredicates(predicatesToAdd)) {
                this.addVariableOccurrenceInPredicatesOf(flag, var);
            }
            this.setPredicates(flag, newPreds);
        }

        public void setPredicates(Flag flag, AVLSet<Finite.Test> newPredicates) {
            this.predicates = newPredicates.isEmpty() ? this.predicates.remove((Object)flag) : this.predicates.bind((Object)flag, newPredicates);
        }

        public void substituteFlag(NumVar x, NumVar y) {
            Flag xFalse;
            assert (this.isFlag(x));
            Flag xTrue = Flag.asTrue(x);
            if (this.predicates.contains(xTrue)) {
                Flag yTrue = Flag.asTrue(y);
                for (NumVar var : this.getVariablesInPredicatesOf(xTrue)) {
                    this.replaceVariableOccurrenceInPredicatesOf(xTrue, yTrue, var);
                }
                this.addPredicates(yTrue, this.getPredicates(xTrue));
                this.predicates = this.predicates.remove((Object)xTrue);
            }
            if (this.predicates.contains(xFalse = Flag.asFalse(x))) {
                Flag yFalse = Flag.asFalse(y);
                for (NumVar var : this.getVariablesInPredicatesOf(xFalse)) {
                    this.replaceVariableOccurrenceInPredicatesOf(xFalse, yFalse, var);
                }
                this.addPredicates(yFalse, this.getPredicates(xFalse));
                this.predicates = this.predicates.remove((Object)xFalse);
            }
        }

        public void copyFlagPredicates(NumVar target, NumVar source) {
            assert (this.isFlag(source));
            assert (!source.equalTo(target));
            assert (!this.isFlag(target));
            assert (!this.isPredicatesVar(target));
            Flag sourceTrue = Flag.asTrue(source);
            Flag targetTrue = Flag.asTrue(target);
            Flag sourceFalse = Flag.asFalse(source);
            Flag targetFalse = Flag.asFalse(target);
            for (NumVar var : this.getVariablesInPredicatesOf(sourceTrue)) {
                this.addVariableOccurrenceInPredicatesOf(targetTrue, var);
            }
            for (NumVar var : this.getVariablesInPredicatesOf(sourceFalse)) {
                this.addVariableOccurrenceInPredicatesOf(targetFalse, var);
            }
            this.setPredicates(targetTrue, this.getPredicates(sourceTrue));
            this.setPredicates(targetFalse, this.getPredicates(sourceFalse));
        }

        public void copyFlagPredicatesNegated(NumVar target, NumVar source) {
            assert (this.isFlag(source));
            assert (!source.equalTo(target));
            assert (!this.isFlag(target));
            assert (!this.isPredicatesVar(target));
            Flag sourceTrue = Flag.asTrue(source);
            Flag targetTrue = Flag.asTrue(target);
            Flag sourceFalse = Flag.asFalse(source);
            Flag targetFalse = Flag.asFalse(target);
            for (NumVar var : this.getVariablesInPredicatesOf(sourceTrue)) {
                this.addVariableOccurrenceInPredicatesOf(targetFalse, var);
            }
            for (NumVar var : this.getVariablesInPredicatesOf(sourceFalse)) {
                this.addVariableOccurrenceInPredicatesOf(targetTrue, var);
            }
            this.setPredicates(targetFalse, this.getPredicates(sourceTrue));
            this.setPredicates(targetTrue, this.getPredicates(sourceFalse));
        }

        public void negateFlag(NumVar flagVar) {
            Flag trueFlag = Flag.asTrue(flagVar);
            Flag falseFlag = Flag.asFalse(flagVar);
            VarSet truePredicatesVars = this.getVariablesInPredicatesOf(trueFlag);
            VarSet falsePredicatesVars = this.getVariablesInPredicatesOf(falseFlag);
            for (NumVar var : truePredicatesVars) {
                this.removeVariableOccurrenceInPredicatesOf(trueFlag, var);
            }
            for (NumVar var : falsePredicatesVars) {
                this.removeVariableOccurrenceInPredicatesOf(falseFlag, var);
            }
            for (NumVar var : truePredicatesVars) {
                this.addVariableOccurrenceInPredicatesOf(falseFlag, var);
            }
            for (NumVar var : falsePredicatesVars) {
                this.addVariableOccurrenceInPredicatesOf(trueFlag, var);
            }
            AVLSet<Finite.Test> truePredicates = this.getPredicates(trueFlag);
            AVLSet<Finite.Test> falsePredicates = this.getPredicates(falseFlag);
            this.setPredicates(trueFlag, falsePredicates);
            this.setPredicates(falseFlag, truePredicates);
        }

        public VarSet getVariablesInPredicatesOf(NumVar flag) {
            return PredicatesState.getVariablesInPredicates(this.getPredicates(Flag.asTrue(flag))).union(PredicatesState.getVariablesInPredicates(this.getPredicates(Flag.asFalse(flag))));
        }

        private VarSet getVariablesInPredicatesOf(Flag flag) {
            return PredicatesState.getVariablesInPredicates(this.getPredicates(flag));
        }

        public void addVariableOccurrenceInPredicatesOf(Flag flag, NumVar var) {
            AVLSet<Flag> occurrences = this.getOccurrencesOf(var);
            this.varOccurrences = this.varOccurrences.bind((Object)var, occurrences.add(flag));
        }

        private void replaceVariableOccurrenceInPredicatesOf(Flag toReplace, Flag replacer, NumVar var) {
            AVLSet<Flag> occurrences = this.getOccurrencesOf(var);
            this.varOccurrences = this.varOccurrences.bind((Object)var, occurrences.remove(toReplace).add(replacer));
        }

        public void removeVariableOccurrenceInPredicatesOf(Flag toRemove, NumVar var) {
            AVLSet<Flag> occurrences = this.getOccurrencesOf(var);
            AVLSet<Flag> newOccurrences = occurrences.remove(toRemove);
            this.varOccurrences = newOccurrences.isEmpty() ? this.varOccurrences.remove((Object)var) : this.varOccurrences.bind((Object)var, newOccurrences);
        }

        public AVLSet<Flag> getOccurrencesOf(NumVar var) {
            return this.varOccurrences.get(var).getOrElse(AVLSet.empty());
        }

        public void removeFlag(NumVar flagVar) {
            Flag trueFlag = Flag.asTrue(flagVar);
            Flag falseFlag = Flag.asFalse(flagVar);
            for (NumVar var : this.getVariablesInPredicatesOf(trueFlag)) {
                this.removeVariableOccurrenceInPredicatesOf(trueFlag, var);
            }
            for (NumVar var : this.getVariablesInPredicatesOf(falseFlag)) {
                this.removeVariableOccurrenceInPredicatesOf(falseFlag, var);
            }
            this.predicates = this.predicates.remove((Object)trueFlag);
            this.predicates = this.predicates.remove((Object)falseFlag);
        }

        public void removePredicatesContaining(final NumVar var) {
            for (Flag flag : this.getOccurrencesOf(var)) {
                AVLSet<Finite.Test> predicatesOfFlag = this.getPredicates(flag);
                AVLSet<Finite.Test> newPredicatesOfFlag = CollectionHelpers.filter(predicatesOfFlag, new Predicate<Finite.Test>(){

                    @Override
                    public Boolean apply(Finite.Test test) {
                        return !test.getVars().contains(var);
                    }
                });
                this.setPredicates(flag, newPredicatesOfFlag);
                AVLSet<Finite.Test> removedPredicates = predicatesOfFlag.difference(newPredicatesOfFlag);
                VarSet varsInNewPredicates = PredicatesState.getVariablesInPredicates(newPredicatesOfFlag);
                for (NumVar variable : PredicatesState.getVariablesInPredicates(removedPredicates)) {
                    if (varsInNewPredicates.contains(variable)) continue;
                    this.removeVariableOccurrenceInPredicatesOf(flag, variable);
                }
            }
        }

        public AVLSet<Substitution> generateSubstitutionsFor(NumVar var, QueryChannel child) {
            AVLSet<Substitution> substitutions = AVLSet.empty();
            if (child == null) {
                return AVLSet.empty();
            }
            SetOfEquations equalities = child.queryEqualities(var);
            if (equalities.isEmpty()) {
                return AVLSet.empty();
            }
            for (Linear equality : equalities) {
                substitutions = substitutions.add(equality.genSubstitution(var));
            }
            return substitutions;
        }

        public void union(MutableState other) {
            this.predicates = MutableState.unionPredicates(this.predicates, other.predicates);
            Fn2<AVLSet<Flag>, AVLSet<Flag>, AVLSet<Flag>> selector2 = new Fn2<AVLSet<Flag>, AVLSet<Flag>, AVLSet<Flag>>(){

                @Override
                public AVLSet<Flag> apply(AVLSet<Flag> a, AVLSet<Flag> b) {
                    return a.union(b);
                }
            };
            this.varOccurrences = this.varOccurrences.union(selector2, other.varOccurrences);
        }

        private static AVLMap<Flag, AVLSet<Finite.Test>> unionPredicates(AVLMap<Flag, AVLSet<Finite.Test>> first, AVLMap<Flag, AVLSet<Finite.Test>> second) {
            Fn2<AVLSet<Finite.Test>, AVLSet<Finite.Test>, AVLSet<Finite.Test>> selector = new Fn2<AVLSet<Finite.Test>, AVLSet<Finite.Test>, AVLSet<Finite.Test>>(){

                @Override
                public AVLSet<Finite.Test> apply(AVLSet<Finite.Test> a, AVLSet<Finite.Test> b) {
                    return a.union(b);
                }
            };
            return first.union(selector, second);
        }

        private static AVLMap<Flag, AVLSet<Finite.Test>> differencePredicates(AVLMap<Flag, AVLSet<Finite.Test>> first, AVLMap<Flag, AVLSet<Finite.Test>> second) {
            ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> split = MutableState.splitPredicates(first, second);
            return MutableState.unionPredicates(split.onlyInFirst(), split.inBothButDiffering());
        }

        private static ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> splitPredicates(AVLMap<Flag, AVLSet<Finite.Test>> first, AVLMap<Flag, AVLSet<Finite.Test>> second) {
            ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> split = first.split(second);
            AVLMap<Flag, AVLSet<Finite.Test>> onlyInFirst = split.onlyInFirst();
            AVLMap<Flag, AVLSet<Finite.Test>> onlyInSecond = split.onlyInSecond();
            FiniteMap inBothButDiffering = AVLMap.empty();
            for (P2<Flag, AVLSet<Finite.Test>> p2 : split.inBothButDiffering()) {
                Flag key = p2._1();
                AVLSet<Finite.Test> values = p2._2().difference(second.getOrNull(key));
                inBothButDiffering = inBothButDiffering.bind(key, values);
            }
            return ThreeWaySplit.make(onlyInFirst, inBothButDiffering, onlyInSecond);
        }

        public void intersect(MutableState other) {
            ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> split = MutableState.splitPredicates(this.predicates, other.predicates);
            for (Flag flag : split.onlyInFirst().keys()) {
                VarSet varsToRemove = this.getVariablesInPredicatesOf(flag);
                for (NumVar var : varsToRemove) {
                    this.removeVariableOccurrenceInPredicatesOf(flag, var);
                }
            }
            this.predicates = MutableState.differencePredicates(this.predicates, split.onlyInFirst());
            for (P2 p2 : split.inBothButDiffering()) {
                Flag flag = (Flag)p2._1();
                AVLSet inThis = (AVLSet)p2._2();
                AVLSet<Finite.Test> inOther = other.predicates.get(flag).get();
                AVLSet<Finite.Test> common = inThis.intersection(inOther);
                this.setPredicates(flag, common);
                VarSet varsToRemove = PredicatesState.getVariablesInPredicates(inThis.difference(common));
                for (NumVar var : varsToRemove) {
                    this.removeVariableOccurrenceInPredicatesOf(flag, var);
                }
            }
        }

        public static <D extends FiniteDomain<D>> boolean isEntailed(MutableState otherState, MutableState inState, D inChildState) {
            ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> split = MutableState.splitPredicates(otherState.predicates, inState.predicates);
            if (split.onlyInFirst().isEmpty() && split.inBothButDiffering().isEmpty()) {
                return true;
            }
            AVLMap<Flag, AVLSet<Finite.Test>> leftOverImplications = MutableState.unionPredicates(split.onlyInFirst(), split.inBothButDiffering());
            return Entailment.areAllImplicationsSemanticallyEntailed(leftOverImplications, inChildState);
        }

        public static <D extends FiniteDomain<D>> MutableState getEntailed(MutableState otherState, MutableState inState, D inChildState) {
            ThreeWaySplit<AVLMap<Flag, AVLSet<Finite.Test>>> split = MutableState.splitPredicates(otherState.predicates, inState.predicates);
            if (split.onlyInFirst().isEmpty() && split.inBothButDiffering().isEmpty()) {
                return otherState;
            }
            AVLMap<Flag, AVLSet<Finite.Test>> leftOverImplications = MutableState.unionPredicates(split.onlyInFirst(), split.inBothButDiffering());
            AVLMap<Flag, AVLSet<Finite.Test>> syntacticallyEntailed = MutableState.differencePredicates(otherState.predicates, leftOverImplications);
            AVLMap<Flag, AVLSet<Finite.Test>> semanticallyEntailed = Entailment.getAllSemanticallyEntailedImplications(leftOverImplications, inChildState);
            AVLMap<Flag, AVLSet<Finite.Test>> entailed = MutableState.unionPredicates(syntacticallyEntailed, semanticallyEntailed);
            MutableState result = EMPTY.toMutable();
            for (P2<Flag, AVLSet<Finite.Test>> p2 : entailed) {
                result.addPredicates(p2._1(), p2._2());
            }
            return result;
        }
    }

    protected static class Flag
    implements Comparable<Flag> {
        private final NumVar flagVariable;
        private final boolean flagValuation;

        private Flag(NumVar flagVariable, boolean flagValuation) {
            assert (flagVariable != null);
            this.flagVariable = flagVariable;
            this.flagValuation = flagValuation;
        }

        public static Flag toFlag(NumVar variable, boolean flagValuation) {
            return new Flag(variable, flagValuation);
        }

        public static Flag asTrue(NumVar variable) {
            return new Flag(variable, true);
        }

        public static Flag asFalse(NumVar variable) {
            return new Flag(variable, false);
        }

        public Flag negate() {
            return new Flag(this.flagVariable, !this.flagValuation);
        }

        public boolean isTrue() {
            return this.flagValuation;
        }

        public NumVar getVariable() {
            return this.flagVariable;
        }

        public Finite.Test asTest() {
            FiniteFactory finite = FiniteFactory.getInstance();
            if (this.isTrue()) {
                return finite.equalToOne(1, this.flagVariable);
            }
            return finite.equalToZero(1, this.flagVariable);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flagValuation ? 1231 : 1237);
            result = 31 * result + (this.flagVariable == null ? 0 : this.flagVariable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Flag)) {
                return false;
            }
            Flag other = (Flag)obj;
            if (this.flagValuation != other.flagValuation) {
                return false;
            }
            return !(this.flagVariable == null ? other.flagVariable != null : !this.flagVariable.equalTo(other.flagVariable));
        }

        @Override
        public int compareTo(Flag other) {
            int result = this.flagVariable.compareTo(other.flagVariable);
            if (result == 0) {
                result = new Boolean(this.flagValuation).compareTo(other.flagValuation);
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (!this.isTrue()) {
                builder.append("\u00ac");
            }
            builder.append(this.flagVariable);
            return builder.toString();
        }
    }
}

