/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.predicates.finite;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.affine.Substitution;
import bindead.domains.predicates.finite.PredicatesStateBuilder;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import rreil.lang.BinOp;

class PredicatesAssignmentVisitor {
    private static final FiniteFactory finite = FiniteFactory.getInstance();

    PredicatesAssignmentVisitor() {
    }

    public static Finite.Assign run(Finite.Assign stmt, PredicatesStateBuilder builder) {
        Visitor vistor = new Visitor(stmt.getLhs());
        Finite.Rhs expr = stmt.getRhs().accept(vistor, builder);
        if (expr != stmt.getRhs()) {
            stmt = finite.assign(stmt.getLhs(), expr);
        }
        return stmt;
    }

    static /* synthetic */ FiniteFactory access$000() {
        return finite;
    }

    static class Visitor
    implements FiniteExprVisitor<Finite.Rhs, PredicatesStateBuilder> {
        private static final Finite.FiniteRangeRhs TOP = PredicatesAssignmentVisitor.access$000().range(1, Interval.BOOLEANTOP);
        final Finite.Lhs lhs;

        public Visitor(Finite.Lhs lhs) {
            this.lhs = lhs;
        }

        @Override
        public Finite.Rhs visit(Finite.Cmp expr, PredicatesStateBuilder builder) {
            Finite.Test test = expr.asTest();
            builder.assignPredicateToFlag(this.lhs.getId(), test);
            return TOP;
        }

        @Override
        public Finite.Rhs visit(Finite.Bin expr, PredicatesStateBuilder builder) {
            switch (expr.getOp()) {
                case Add: {
                    return this.handleLinearArithmetic(expr, builder);
                }
                case Sub: {
                    return this.handleLinearArithmetic(expr, builder);
                }
                case Xor: {
                    return this.handleXor(expr, builder);
                }
            }
            builder.project(this.lhs.getId());
            return expr;
        }

        private Finite.Rhs handleLinearArithmetic(Finite.Bin expr, PredicatesStateBuilder builder) {
            switch (expr.getOp()) {
                case Add: {
                    return expr.getLeft().add(expr.getRight()).accept(this, builder);
                }
                case Sub: {
                    return expr.getLeft().sub(expr.getRight()).accept(this, builder);
                }
            }
            builder.project(this.lhs.getId());
            return expr;
        }

        private Finite.Rhs handleXor(Finite.Bin expr, PredicatesStateBuilder builder) {
            Linear l = expr.getLeft().getLinearTerm();
            Linear r = expr.getRight().getLinearTerm();
            if (expr.getOp() == BinOp.Xor && this.lhs.getSize() == 1) {
                NumVar variable = null;
                if (l.isConstantOnly() && l.getConstant().isOne() && r.isSingleTerm()) {
                    variable = r.getKey();
                } else if (r.isConstantOnly() && r.getConstant().isOne() && l.isSingleTerm()) {
                    variable = l.getKey();
                }
                if (variable != null && builder.isFlag(variable)) {
                    builder.assignNegatedCopy(this.lhs.getId(), variable);
                    return TOP;
                }
                builder.project(this.lhs.getId());
                return expr;
            }
            builder.project(this.lhs.getId());
            return expr;
        }

        @Override
        public Finite.Rhs visit(Finite.SignExtend expr, PredicatesStateBuilder builder) {
            builder.project(this.lhs.getId());
            return expr;
        }

        @Override
        public Finite.Rhs visit(Finite.Convert expr, PredicatesStateBuilder builder) {
            builder.project(this.lhs.getId());
            return expr;
        }

        @Override
        public Finite.Rhs visit(Finite.Rlin expr, PredicatesStateBuilder builder) {
            Linear rhs = expr.getLinearTerm();
            NumVar var = this.lhs.getId();
            if (builder.isPredicatesVar(var)) {
                if (rhs.contains(var)) {
                    Substitution substitution = Substitution.invertingSubstitution(rhs, Bound.ONE, var);
                    builder.applyPredicatesSubstitution(substitution);
                } else {
                    builder.project(var);
                }
            } else if (rhs.isSingleTerm()) {
                NumVar variable = rhs.getKey();
                if (builder.isFlag(variable) && rhs.getConstant().isZero() && rhs.getCoeff(variable).isOne()) {
                    builder.assignCopy(var, variable);
                } else {
                    builder.project(var);
                }
            } else {
                builder.project(var);
            }
            return expr;
        }

        @Override
        public Finite.Rhs visit(Finite.FiniteRangeRhs expr, PredicatesStateBuilder builder) {
            NumVar var = this.lhs.getId();
            builder.project(var);
            return expr;
        }
    }
}

