/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.combinators.FiniteStateBuilder;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domains.pointsto.HyperPointsToSet;
import bindead.domains.pointsto.PointsTo;
import bindead.domains.pointsto.PointsToMap;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.pointsto.PointsToState;
import bindead.domains.pointsto.RhsTranslator;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.List;
import java.util.Set;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import rreil.lang.util.Type;

class PointsToStateBuilder<D extends FiniteDomain<D>>
extends FiniteStateBuilder {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    PointsToMap pointsToMap;

    PointsToStateBuilder(PointsToState state) {
        this.pointsToMap = state.getPointsToMap();
    }

    void bindPts(PointsToSet targetPts) {
        this.pointsToMap = this.pointsToMap.bind(targetPts);
    }

    PointsToState build() {
        return new PointsToState(this.pointsToMap);
    }

    void copyAndPaste(VarSet vars, PointsTo<D> from) {
        VarSet childVars = vars;
        for (NumVar v : vars) {
            PointsToSet vpts = from.queryPts(v);
            childVars = childVars.union(vpts.localVars());
            this.bindPts(vpts);
        }
        this.getChildOps().addCopyAndPaste(childVars, (FiniteDomain)from.childState);
    }

    void evalAssign(int size, NumVar lhsVar, HyperPointsToSet hyperRhs) {
        assert (!lhsVar.isAddress());
        PointsToSet targetPts = PointsToSet.empty(lhsVar);
        for (P2<NumVar.AddrVar, Linear> p2 : hyperRhs.getTerms()) {
            NumVar.FlagVar newFlag = NumVar.freshFlag();
            this.getChildOps().addIntro(newFlag);
            NumVar.AddrVar addr = p2._1();
            Linear coeff = p2._2();
            this.getChildOps().addAssignment(fin.variable(0, newFlag), fin.linear(0, coeff));
            targetPts = targetPts.bind(addr, newFlag);
        }
        if (!hyperRhs.sumOfFlags.isZero()) {
            NumVar.FlagVar var = NumVar.freshFlag();
            this.getChildOps().addIntro(var);
            targetPts = targetPts.withSumVar(var);
            this.getChildOps().addAssignment(fin.variable(size, var), fin.linear(size, hyperRhs.sumOfFlags));
        }
        Finite.Rhs offset = hyperRhs.offset;
        this.killPtsVars(lhsVar);
        this.bindPts(targetPts);
        this.getChildOps().addAssignment(fin.variable(size, lhsVar), offset);
    }

    @Deprecated
    HyperPointsToSet translate(int lhsSize, Finite.Rhs rhs, WarningsContainer wc) {
        return new RhsTranslator(lhsSize, this.build(), wc).run(rhs);
    }

    void killPtsVars(NumVar lhsVar) {
        Option<PointsToSet> pts = this.pointsToMap.get(lhsVar);
        if (pts.isSome()) {
            pts.get().killLocalVars(this.getChildOps());
        }
    }

    void remove(NumVar eph) {
        this.pointsToMap = this.pointsToMap.remove(eph);
    }

    void introduce(NumVar variable, Type type) {
        boolean isAddress = type.equals((Object)Type.Address);
        assert (isAddress == variable.isAddress());
        this.bindPts(PointsToSet.empty(variable));
    }

    void project(NumVar var, QueryChannel qc) {
        if (var.isAddress()) {
            this.projectAddressFromPTSs((NumVar.AddrVar)var, qc);
        }
        PointsToSet pts = this.getPts(var);
        for (NumVar var1 : pts.localVars()) {
            this.getChildOps().addKill(var1);
        }
        this.remove(var);
        this.getChildOps().addKill(var);
    }

    private void projectAddressFromPTSs(NumVar.AddrVar var, QueryChannel qc) {
        for (PointsToSet currentPts : this.pointsToMap) {
            PointsToSet.PointsToEntry currentEntry = currentPts.getEntry(var);
            if (currentEntry == null) continue;
            this.bindPts(currentPts.remove(var));
            BigInt flagValue = qc.queryRange(currentEntry.flag).getConstantOrNull();
            if (flagValue != null && !flagValue.isZero()) {
                this.getChildOps().addAssignment(fin.variable(0, currentPts.var), fin.range(0, Interval.top()));
            }
            this.getChildOps().addKill(currentEntry.flag);
        }
    }

    void substitute(NumVar from, NumVar to) {
        assert (from.isAddress() == to.isAddress());
        if (from.isAddress()) {
            NumVar.AddrVar toAddr = (NumVar.AddrVar)to;
            NumVar.AddrVar fromAddr = (NumVar.AddrVar)from;
            for (PointsToSet t : this.pointsToMap) {
                PointsToSet newPts = t.substituteAddress(toAddr, fromAddr, this.getChildOps());
                if (newPts == null) continue;
                this.bindPts(newPts);
            }
        }
        PointsToSet p = this.getPts(from);
        this.remove(from);
        assert (!this.pointsToMap.contains(to));
        P2<PointsToSet, FoldMap> newP = p.cloneWithNewVars(to);
        for (VarPair vp : newP._2()) {
            this.getChildOps().addSubst((NumVar)vp.getPermanent(), (NumVar)vp.getEphemeral());
        }
        this.bindPts(newP._1());
        this.getChildOps().addSubst(from, to);
    }

    final PointsToSet getPts(NumVar numVar) {
        Option<PointsToSet> pts = this.pointsToMap.get(numVar);
        if (pts.isNone()) {
            throw new DomainStateException.VariableSupportSetException(numVar);
        }
        return pts.get();
    }

    final PointsToSet getPts(Finite.Rlin numVar) {
        HyperPointsToSet hpts = new RhsTranslator(numVar.getSize(), this.build(), null).visitLinear(numVar.getLinearTerm(), numVar.getSize());
        throw new UnimplementedException("cannot implement");
    }

    void assumeConcrete(NumVar var) {
        PointsToSet pts = this.getPts(var);
        if (pts.outFlagOfGhostNode == null) {
            return;
        }
        this.getChildOps().addKill(pts.outFlagOfGhostNode);
        this.bindPts(pts.withGhostNode(null));
    }

    public void assumePointsTo(HyperPointsToSet pointer, NumVar.AddrVar target, VarSet contents) {
        for (NumVar content : contents) {
            this.assumeConcrete(content);
        }
        this.assumePointsTo(pointer, target);
    }

    void assumePointsTo(HyperPointsToSet pointer, NumVar.AddrVar target) {
        boolean hasOne = false;
        for (P2<NumVar.AddrVar, Linear> p : pointer) {
            NumVar.AddrVar addr = p._1();
            if (target != null && addr.equalTo(target)) {
                hasOne = true;
                this.testEqualTo(p._2(), Linear.ONE);
                continue;
            }
            this.testEqualTo(p._2(), Linear.ZERO);
        }
        if (target == null) {
            assert (!hasOne) : "weird: there was a NULL entry in the points-to set";
            this.testEqualTo(pointer.sumOfFlags, Linear.ZERO);
        } else {
            if (!hasOne) {
                throw new Unreachable();
            }
            this.testEqualTo(pointer.sumOfFlags, Linear.ONE);
        }
    }

    private void testEqualTo(Linear linear, Linear value) {
        Finite.Test t = fin.equalTo(0, value, linear);
        this.getChildOps().addTest(t);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: ");
        builder.append(this.getChildOps());
        builder.append('\n');
        builder.append(this.build());
        return builder.toString();
    }

    public void concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        for (PointsToSet pts : this.pointsToMap) {
            if (cs.contains(pts.var)) {
                this.concretize(pts);
                continue;
            }
            this.disconnect(s, pts);
        }
    }

    private void disconnect(NumVar.AddrVar s, PointsToSet pts) {
        if (pts.hasEntry(s)) {
            PointsToSet.PointsToEntry e = pts.getEntry(s);
            this.getChildOps().addAssignment(fin.variable(0, e.flag), fin.literal(0, BigInt.ZERO));
        }
    }

    private void concretize(PointsToSet pts) {
        if (pts.hasGhostNode()) {
            this.getChildOps().addKill(pts.outFlagOfGhostNode);
            this.bindPts(pts.withGhostNode(null));
        }
    }

    public void bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        ListVarPair toExpandOnChild = new ListVarPair();
        for (NumVar sv : svs) {
            this.bendBackGhostFlag(toExpandOnChild, sv, c);
        }
        for (NumVar cv : cvs) {
            this.bendBackGhostFlag(toExpandOnChild, cv, s);
        }
        this.getChildOps().addExpandNG(toExpandOnChild);
        for (NumVar cv : cvs) {
            this.killGhostFlag(cv);
        }
        for (NumVar sumvar : pts) {
            this.unfoldConnectorTarget(sumvar, c, s);
            this.unfoldConnectorTarget(sumvar, s, c);
        }
        for (NumVar concvar : ptc) {
            this.unfoldConnectorTarget(concvar, c, s);
            this.unfoldConnectorTarget(concvar, s, c);
        }
    }

    private void unfoldConnectorTarget(NumVar current, NumVar.AddrVar s, NumVar.AddrVar c) {
        PointsToSet epts = this.pointsToMap.get(current).get();
        if (epts.hasEntry(s) && !epts.hasEntry(c)) {
            NumVar concFlag = NumVar.fresh();
            this.getChildOps().addIntro(concFlag);
            this.bindPts(epts.bind(c, concFlag));
        }
    }

    private void killGhostFlag(NumVar cv) {
        PointsToSet pts = this.pointsToMap.get(cv).get();
        if (!pts.hasGhostNode()) {
            return;
        }
        this.getChildOps().addKill(pts.outFlagOfGhostNode);
        this.bindPts(pts.withGhostNode(null));
    }

    private void bendBackGhostFlag(ListVarPair childExp, NumVar var, NumVar.AddrVar target) {
        PointsToSet spts = this.getPts(var);
        if (spts.hasGhostNode()) {
            assert (!spts.hasEntry(target));
            NumVar newFlag = NumVar.fresh();
            spts = spts.bind(target, newFlag);
            childExp.add(spts.outFlagOfGhostNode, newFlag);
            this.bindPts(spts);
        }
    }

    void expandNG(List<VarPair> nvps) {
        FoldMap foldMap = FoldMap.fromList(nvps);
        ListVarPair innerExpansion = new ListVarPair();
        for (PointsToSet pts : this.pointsToMap) {
            if (!foldMap.isPermanent(pts.var)) continue;
            this.expandInnerNG(null, null, foldMap, innerExpansion, pts);
        }
        this.getChildOps().addExpandNG(innerExpansion);
    }

    void expandNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, List<VarPair> nvps) {
        FoldMap foldMap = FoldMap.fromList(nvps);
        ListVarPair innerExpansion = new ListVarPair();
        for (PointsToSet pts : this.pointsToMap) {
            if (foldMap.isPermanent(pts.var)) {
                this.expandInnerNG(summary, concrete, foldMap, innerExpansion, pts);
                continue;
            }
            if (!pts.hasEntry(summary)) continue;
            this.expandOuterNG(summary, concrete, foldMap, innerExpansion, pts);
        }
        this.introduce(concrete, Type.Address);
        this.getChildOps().addExpandNG(summary, concrete, innerExpansion);
    }

    private void expandOuterNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, FoldMap foldMap, List<VarPair> innerVars, PointsToSet pts) {
        assert (summary != null);
        assert (concrete != null);
        assert (!pts.hasEntry(concrete));
        assert (!foldMap.isEphemeral(pts.var));
        PointsToSet.PointsToEntry sumEntry = pts.getEntry(summary);
        if (sumEntry != null) {
            NumVar freshFlag = PointsToStateBuilder.makeExpansion(innerVars, sumEntry.flag);
            this.bindPts(pts.bind(concrete, freshFlag));
        }
    }

    private void expandInnerNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, FoldMap foldMap, List<VarPair> innerVars, PointsToSet pts) {
        PointsToSet ephPts;
        assert (summary == null == (concrete == null));
        NumVar eph = foldMap.getEphemeral(pts.var);
        innerVars.add(new VarPair(pts.var, eph));
        if (!pts.sumOfFlags.isConstantZero()) {
            NumVar c = PointsToStateBuilder.makeExpansion(innerVars, pts.sumOfFlags.numVar);
            ephPts = PointsToSet.empty(eph, c);
        } else {
            ephPts = PointsToSet.empty(eph);
        }
        if (pts.hasGhostNode()) {
            NumVar oflag = PointsToStateBuilder.makeExpansion(innerVars, pts.outFlagOfGhostNode);
            ephPts = ephPts.withGhostNode(oflag);
        }
        for (PointsToSet.PointsToEntry entry : pts) {
            NumVar ef = PointsToStateBuilder.makeExpansion(innerVars, entry.flag);
            NumVar.AddrVar address = entry.address;
            if (summary != null && address.equalTo(summary)) {
                address = concrete;
            }
            ephPts = ephPts.bind(address, ef);
        }
        this.bindPts(ephPts);
    }

    PointsToSet bendGhostEdge(NumVar.AddrVar other, ListVarPair innerFold, NumVar var) {
        PointsToSet ppts1 = this.getPts(var);
        PointsToSet.PointsToEntry o = ppts1.getEntry(other);
        if (o == null) {
            NumVar zeroFlag1 = NumVar.fresh();
            this.getChildOps().addIntro(zeroFlag1, BigInt.ZERO);
            NumVar zeroFlag = zeroFlag1;
            ppts1 = ppts1.bind(other, zeroFlag);
            this.bindPts(ppts1);
        }
        PointsToSet.PointsToEntry o1 = ppts1.getEntry(other);
        if (ppts1.outFlagOfGhostNode != null) {
            innerFold.add(new VarPair(o1.flag, ppts1.outFlagOfGhostNode));
        }
        ppts1 = ppts1.remove(other).withGhostNode(o1.flag);
        return ppts1;
    }

    void bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        ListVarPair innerFold = new ListVarPair();
        for (NumVar var : svs) {
            PointsToSet ppts = this.bendGhostEdge(concrete, innerFold, var);
            this.bindPts(ppts);
        }
        for (NumVar var : cvs) {
            PointsToSet epts = this.bendGhostEdge(summary, innerFold, var);
            epts = epts.renameAddress(concrete, summary);
            this.bindPts(epts);
        }
        for (NumVar var : pts) {
            this.foldPointers(var, summary, concrete);
        }
        for (NumVar var : ptc) {
            this.foldPointers(var, concrete, summary);
        }
        this.getChildOps().addFoldNG(innerFold);
    }

    private void foldPointers(NumVar var, NumVar.AddrVar targetToKeep, NumVar.AddrVar targetToRemove) {
        assert (targetToKeep != null);
        assert (targetToRemove != null);
        PointsToSet epts = this.getPts(var);
        PointsToSet.PointsToEntry entryToKeep = epts.getEntry(targetToKeep);
        PointsToSet.PointsToEntry entryToRemove = epts.getEntry(targetToRemove);
        if (entryToKeep == null && entryToRemove == null) {
            return;
        }
        if (entryToKeep != null && entryToRemove == null) {
            this.getChildOps().addAssignment(fin.variable(0, entryToKeep.flag), fin.range(0, Interval.ZEROorONE));
        } else if (entryToKeep == null && entryToRemove != null) {
            this.getChildOps().addAssignment(fin.variable(0, entryToRemove.flag), fin.range(0, Interval.ZEROorONE));
            epts = epts.remove(entryToRemove).bind(targetToKeep, entryToRemove.flag);
            this.bindPts(epts);
        } else if (entryToKeep != null && entryToRemove != null) {
            this.getChildOps().addAssignment(fin.variable(0, entryToKeep.flag), fin.range(0, Interval.ZEROorONE));
            this.getChildOps().addKill(entryToRemove.flag);
            epts = epts.remove(entryToRemove);
            this.bindPts(epts);
        }
    }

    void foldInnerVar(FoldMap outer, ListVarPair innerVars, PointsToSet current) {
        PointsToSet current1 = current;
        NumVar eph = outer.getEphemeral(current1.var);
        PointsToSet ephPts = this.getPts(eph);
        innerVars.add(current1.var, eph);
        current1 = this.step2a1__foldSumFlag(innerVars, current1, ephPts);
        current1 = this.step2a2__foldGhostNode(innerVars, current1, ephPts);
        current1 = this.step2a3__foldPtsEntries(innerVars, current1, ephPts);
        this.bindPts(current1);
        this.remove(eph);
    }

    void foldInnerVar(NumVar.AddrVar p, NumVar.AddrVar e, FoldMap outer, ListVarPair innerVars, PointsToSet current) {
        PointsToSet current1 = current;
        NumVar eph = outer.getEphemeral(current1.var);
        PointsToSet ephPts = this.getPts(eph);
        innerVars.add(current1.var, eph);
        current1 = this.step2a1__foldSumFlag(innerVars, current1, ephPts);
        current1 = this.step2a2__foldGhostNode(innerVars, current1, ephPts);
        current1 = this.step2a3__foldPtsEntries(p, e, innerVars, current1, ephPts);
        this.bindPts(current1);
        this.remove(eph);
    }

    PointsToSet step2a1__foldSumFlag(ListVarPair innerVars, PointsToSet tfst, PointsToSet tsnd) {
        boolean fstHasSum = tfst.sumOfFlags.isConstantZero();
        boolean sndHasSum = tsnd.sumOfFlags.isConstantZero();
        if (!sndHasSum && !fstHasSum) {
            innerVars.add(tfst.sumOfFlags.numVar, tsnd.sumOfFlags.numVar);
        } else if (!sndHasSum && fstHasSum) {
            NumVar v = this.introZeroVar();
            tfst = tfst.withSumVar(v);
            innerVars.add(v, tsnd.sumOfFlags.numVar);
        } else if (sndHasSum && !fstHasSum) {
            NumVar v = this.introZeroVar();
            innerVars.add(tfst.sumOfFlags.numVar, v);
        }
        return tfst;
    }

    PointsToSet step2a2__foldGhostNode(ListVarPair innerVars, PointsToSet tfst, PointsToSet tsnd) {
        boolean fstHasGhost = tfst.hasGhostNode();
        boolean sndHasGhost = tsnd.hasGhostNode();
        if (!fstHasGhost && sndHasGhost) {
            tfst = tfst.withGhostNode(this.introZeroVar());
            innerVars.add(tfst.outFlagOfGhostNode, tsnd.outFlagOfGhostNode);
        } else if (fstHasGhost && !sndHasGhost) {
            tsnd = tsnd.withGhostNode(this.introZeroVar());
            innerVars.add(tfst.outFlagOfGhostNode, tsnd.outFlagOfGhostNode);
        } else if (fstHasGhost && sndHasGhost) {
            innerVars.add(tfst.outFlagOfGhostNode, tsnd.outFlagOfGhostNode);
        }
        return tfst;
    }

    NumVar introZeroVar() {
        NumVar fstGhost = NumVar.fresh();
        this.getChildOps().addIntroZero(fstGhost);
        return fstGhost;
    }

    PointsToSet step2a3__foldPtsEntries(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair innerVars, PointsToSet tfst, PointsToSet tsnd) {
        PointsToSet.PointsToEntry sndSelfPtr = tsnd.getEntry(e);
        if (sndSelfPtr != null) {
            tsnd = tsnd.bind(p, sndSelfPtr.flag);
            tsnd = tsnd.remove(e);
        }
        return this.step2a3__foldPtsEntries(innerVars, tfst, tsnd);
    }

    PointsToSet step2a3__foldPtsEntries(ListVarPair innerVars, PointsToSet tfst, PointsToSet tsnd) {
        Set<NumVar.AddrVar> allAddresses = tsnd.allAddresses();
        allAddresses.addAll(tfst.allAddresses());
        for (NumVar.AddrVar av : allAddresses) {
            NumVar pvFlag;
            NumVar evFlag;
            PointsToSet.PointsToEntry ev = tsnd.getEntry(av);
            if (ev == null) {
                evFlag = NumVar.fresh();
                this.getChildOps().addIntroZero(evFlag);
            } else {
                evFlag = ev.flag;
            }
            PointsToSet.PointsToEntry pv = tfst.getEntry(av);
            if (pv == null) {
                pvFlag = NumVar.fresh();
                this.getChildOps().addIntroZero(pvFlag);
                tfst = tfst.bind(av, pvFlag);
            } else {
                pvFlag = pv.flag;
            }
            innerVars.add(pvFlag, evFlag);
        }
        return tfst;
    }

    void foldOuterVar(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair innerVars, PointsToSet current) {
        PointsToSet.PointsToEntry pe = current.getEntry(p);
        PointsToSet.PointsToEntry ee = current.getEntry(e);
        if (pe == null && ee != null) {
            NumVar freshVar = this.introZeroVar();
            pe = new PointsToSet.PointsToEntry(p, freshVar);
            PointsToSet removed = current.bind(pe).remove(ee);
            this.bindPts(removed);
            innerVars.add(pe.flag, ee.flag);
        } else if (pe != null && ee == null) {
            NumVar freshVar = this.introZeroVar();
            ee = new PointsToSet.PointsToEntry(e, freshVar);
            innerVars.add(pe.flag, ee.flag);
        } else if (pe != null && ee != null) {
            this.bindPts(current.remove(ee));
            innerVars.add(pe.flag, ee.flag);
        }
    }

    void foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        FoldMap outer = FoldMap.fromList(nvps);
        ListVarPair innerVars = new ListVarPair();
        for (PointsToSet current : this.pointsToMap) {
            if (outer.isPermanent(current.var)) {
                this.foldInnerVar(p, e, outer, innerVars, current);
                continue;
            }
            if (outer.isEphemeral(current.var)) continue;
            this.foldOuterVar(p, e, innerVars, current);
        }
        this.remove(e);
        this.getChildOps().addFoldNG(p, e, innerVars);
    }

    void foldNG(ListVarPair nvps) {
        FoldMap outer = FoldMap.fromList(nvps);
        ListVarPair innerVars = new ListVarPair();
        for (PointsToSet current : this.pointsToMap) {
            if (!outer.isPermanent(current.var)) continue;
            this.foldInnerVar(outer, innerVars, current);
        }
        this.getChildOps().addFoldNG(innerVars);
    }

    static NumVar makeExpansion(List<VarPair> innerVars, NumVar epf) {
        NumVar freshFlag = NumVar.fresh();
        innerVars.add(new VarPair(epf, freshFlag));
        return freshFlag;
    }
}

