/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.phased;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.decisiontree.DecisionTree;
import bindead.exceptions.Unreachable;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import rreil.lang.MemVar;

public class Phased<D extends ZenoDomain<D>>
extends DecisionTree<D> {
    public static final String NAME = "PHASED";

    public Phased(D child) {
        this(Option.some(child), DecisionTree.noChild(), null);
    }

    private Phased(Option<D> state, AVLMap<Zeno.Test, DecisionTree<D>> children, AnalysisCtx ctx) {
        super(NAME, state, children, ctx);
    }

    @Override
    protected Phased<D> build(Option<D> state, AVLMap<Zeno.Test, DecisionTree<D>> children) {
        return new Phased<D>(state, children, this.getContext());
    }

    @Override
    public Phased<D> setContext(AnalysisCtx ctx) {
        return new Phased<D>(this.state, this.children, ctx);
    }

    @Override
    public DecisionTree<D> eval(final Zeno.Test test) throws Unreachable {
        DecisionTree result = this.accept(new DecisionTree.UnaryVisitor<D>(){

            @Override
            public Option<D> visit(D state) {
                try {
                    return Option.some(state.eval(test));
                }
                catch (Unreachable _) {
                    return Option.none();
                }
            }

            @Override
            public AVLSet<Zeno.Test> newTests(D state) {
                if (ZenoTestHelper.isTautology(test)) {
                    return AVLSet.empty();
                }
                AVLSet<Zeno.Test> unsatisfiable = AVLSet.empty();
                AVLSet<Object> candidateTests = AVLSet.empty();
                if (test.getOperator() == Zeno.ZenoTestOp.NotEqualToZero || test.getOperator() == Zeno.ZenoTestOp.EqualToZero) {
                    P2<Zeno.Test, Zeno.Test> split = test.splitEquality();
                    Zeno.Test test2 = split._1().not();
                    Zeno.Test negatedTest2 = split._2().not();
                    candidateTests = candidateTests.add(test2);
                    candidateTests = candidateTests.add(negatedTest2);
                } else {
                    Zeno.Test negatedTest = test.not();
                    candidateTests = candidateTests.add(negatedTest);
                }
                for (Zeno.Test test3 : candidateTests) {
                    if (!this.isUnsatisfiable(test3, state)) continue;
                    unsatisfiable = unsatisfiable.add(test3);
                }
                return unsatisfiable;
            }

            private boolean isUnsatisfiable(Zeno.Test test2, D state) {
                try {
                    state.eval(test2);
                }
                catch (Unreachable _) {
                    return true;
                }
                return false;
            }
        });
        if (!result.isReachable()) {
            throw new Unreachable();
        }
        return result;
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        return SetOfEquations.empty();
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        assert (false) : "implement in PrettyDomain";
    }

    @Override
    public void toCompactString(StringBuilder builder) {
        assert (false) : "implement in PrettyDomain";
    }

    @Override
    public List<DecisionTree<D>> enumerateAlternatives() {
        throw new UnimplementedException();
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        throw new UnimplementedException();
    }
}

