/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.intervals;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.debug.DomainStringBuilder;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ZenoHeadDomain;
import bindead.domains.intervals.IntervalProperties;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import com.jamesmurty.utils.XMLBuilder;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.IntervalSet;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.util.Type;

public class IntervalSets
extends ZenoHeadDomain<IntervalSets> {
    private static final boolean DEBUGSUBSETOREQUAL = IntervalProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    private static final boolean DEBUGASSIGN = IntervalProperties.INSTANCE.debugAssignments.isTrue();
    private static final boolean DEBUGBINARIES = IntervalProperties.INSTANCE.debugBinaryOperations.isTrue();
    private static final boolean DEBUGTESTS = IntervalProperties.INSTANCE.debugTests.isTrue();
    private static final boolean DEBUGOTHER = IntervalProperties.INSTANCE.debugOther.isTrue();
    public static final String NAME = "INTERVALSETS";
    private final AVLMap<NumVar, IntervalSet> intervalSets;
    private final VarSet equalities;

    public IntervalSets() {
        super(NAME, AnalysisCtx.unknown());
        this.intervalSets = AVLMap.empty();
        this.equalities = VarSet.empty();
    }

    private IntervalSets(AVLMap<NumVar, IntervalSet> intervalSets, VarSet equalities, AnalysisCtx ctx) {
        super(NAME, ctx);
        this.intervalSets = intervalSets;
        this.equalities = equalities;
    }

    @Override
    public IntervalSets setContext(AnalysisCtx ctx) {
        return new IntervalSets(this.intervalSets, VarSet.empty(), ctx);
    }

    @Override
    public IntervalSets eval(Zeno.Assign stmt) {
        IntervalSet approx = this.evaluate(stmt.getRhs());
        VarSet equalities = VarSet.empty();
        if (approx.isConstant()) {
            equalities = equalities.add(stmt.getLhs().getId());
        }
        FiniteMap newIntervalSets = this.intervalSets.bind((Object)stmt.getLhs().getId(), (Object)approx);
        IntervalSets result = this.build((AVLMap<NumVar, IntervalSet>)newIntervalSets, equalities);
        if (DEBUGASSIGN) {
            System.out.println("INTERVALSETS:");
            System.out.println("  after " + stmt + " that is " + approx);
            System.out.println("  values: " + result);
        }
        return result;
    }

    @Override
    public IntervalSets eval(Zeno.Test test) {
        FiniteMap current = this.intervalSets;
        VarSet newEqualities = VarSet.empty();
        Linear expr = test.getExpr();
        boolean allReachable = true;
        if (expr.isConstantOnly()) {
            BigInt lhs = expr.getConstant();
            switch (test.getOperator()) {
                case EqualToZero: {
                    allReachable = lhs.isZero();
                    break;
                }
                case NotEqualToZero: {
                    allReachable = !lhs.isZero();
                    break;
                }
                case LessThanOrEqualToZero: {
                    allReachable = !lhs.isPositive();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            for (Linear.Term t : expr) {
                Option<IntervalSet> approxLhsOption = this.intervalSets.get(t.getId());
                if (approxLhsOption.isNone()) {
                    throw new DomainStateException.VariableSupportSetException();
                }
                IntervalSet approxLhs = approxLhsOption.get();
                Linear equation = expr.dropTerm(t.getId());
                IntervalSet approxRhs = this.evaluate(equation).negate();
                Option<IntervalSet> meet = IntervalSets.applyMeet(test.getOperator(), t.getCoeff(), approxLhs, approxRhs);
                if (meet.isNone()) {
                    allReachable = false;
                    continue;
                }
                current = current.bind(t.getId(), meet.get());
                if (!meet.get().isConstant()) continue;
                newEqualities = newEqualities.add(t.getId());
            }
        }
        if (!allReachable) {
            if (DEBUGTESTS) {
                System.out.println("INTERVALSETS: ");
                System.out.println("  evaluating test: " + test);
                System.out.println("  before: " + this);
                System.out.println("  after: unreachable");
            }
            throw new Unreachable();
        }
        IntervalSets result = this.build((AVLMap<NumVar, IntervalSet>)current, newEqualities);
        if (DEBUGTESTS) {
            System.out.println("INTERVALSETS: ");
            System.out.println("  evaluating test: " + test);
            System.out.println("  before: " + this);
            System.out.println("  after: " + result);
        }
        return result;
    }

    private static Option<IntervalSet> applyMeet(Zeno.ZenoTestOp testOp, BigInt lhsCoeff, IntervalSet lhs, IntervalSet rhs) {
        switch (testOp) {
            case EqualToZero: {
                rhs = rhs.divRoundInvards(lhsCoeff);
                return lhs.meet(rhs);
            }
            case NotEqualToZero: {
                Option<IntervalSet> leftPart = IntervalSets.applyMeet(Zeno.ZenoTestOp.LessThanOrEqualToZero, lhsCoeff, lhs, rhs.sub(Bound.ONE));
                Option<IntervalSet> rightPart = IntervalSets.applyMeet(Zeno.ZenoTestOp.LessThanOrEqualToZero, lhsCoeff.negate(), lhs, rhs.negate().sub(Bound.ONE));
                return IntervalSets.join(leftPart, rightPart);
            }
            case LessThanOrEqualToZero: {
                rhs = new IntervalSet(Interval.downFrom(rhs.high()).divRoundInvards(lhsCoeff));
                return lhs.meet(rhs);
            }
        }
        throw new IllegalStateException();
    }

    private static Option<IntervalSet> join(Option<IntervalSet> first, Option<IntervalSet> second) {
        if (first.isSome() && second.isSome()) {
            return Option.some(first.get().join(second.get()));
        }
        if (first.isNone() && second.isNone()) {
            return Option.none();
        }
        if (first.isSome()) {
            return first;
        }
        return second;
    }

    @Override
    public IntervalSets join(IntervalSets other) {
        ThreeWaySplit<AVLMap<NumVar, IntervalSet>> split = this.split(other);
        AVLMap<NumVar, IntervalSet> current = other.intervalSets.intersection(IntervalSet.join, split.inBothButDiffering());
        current = current.union(this.intervalSets);
        IntervalSets result = this.build(current);
        if (DEBUGBINARIES) {
            System.out.println("INTERVALSETS:");
            System.out.println("  differing:");
            System.out.println("    from fst: " + this.build(this.intervalSets.intersection(split.inBothButDiffering())));
            System.out.println("    from snd: " + this.build(other.intervalSets.intersection(split.inBothButDiffering())));
            System.out.println("  join: " + result);
        }
        return result;
    }

    @Override
    public IntervalSets widen(IntervalSets other) {
        AVLMap<NumVar, IntervalSet> differing = this.split(other).inBothButDiffering();
        FiniteMap widened = AVLMap.empty();
        for (P2<NumVar, IntervalSet> p2 : differing) {
            NumVar var = p2._1();
            IntervalSet thisValue = p2._2();
            IntervalSet otherValue = other.intervalSets.get(var).get();
            IntervalSet resultValue = var.isFlag() ? thisValue.join(otherValue) : thisValue.widen(otherValue);
            widened = widened.bind(var, resultValue);
        }
        IntervalSets result = this.build(widened.union(this.intervalSets));
        if (DEBUGBINARIES) {
            System.out.println("INTERVALSETS:");
            System.out.println("  differing:");
            System.out.println("    from fst: " + this.build(this.intervalSets.intersection(differing)));
            System.out.println("    from snd: " + this.build(other.intervalSets.intersection(differing)));
            System.out.println("  widen: " + result);
        }
        return result;
    }

    private ThreeWaySplit<AVLMap<NumVar, IntervalSet>> split(IntervalSets other) {
        ThreeWaySplit<AVLMap<NumVar, IntervalSet>> split = this.intervalSets.split(other.intervalSets);
        if (!split.onlyInFirst().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        if (!split.onlyInSecond().isEmpty()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        return split;
    }

    @Override
    public boolean subsetOrEqual(IntervalSets other) {
        ThreeWaySplit<AVLMap<NumVar, IntervalSet>> split = this.split(other);
        if (DEBUGSUBSETOREQUAL) {
            System.out.println("INTERVALSETS:");
            System.out.println(" subset-or-equal:");
            System.out.println("  differing:");
            System.out.println("    from fst: " + this.build(this.intervalSets.intersection(split.inBothButDiffering())));
            System.out.println("    from snd: " + this.build(other.intervalSets.intersection(split.inBothButDiffering())));
        }
        for (P2<NumVar, IntervalSet> p2 : split.inBothButDiffering()) {
            IntervalSet b;
            NumVar variable = p2._1();
            IntervalSet a = p2._2();
            if (a.subsetOrEqual(b = other.intervalSets.get(variable).get())) continue;
            return false;
        }
        return true;
    }

    @Override
    public IntervalSets introduce(NumVar variable, Type type, Option<BigInt> value) {
        FiniteMap updatedIntervalSets = this.intervalSets;
        IntervalSet initial = IntervalSet.TOP;
        switch (type) {
            case Bool: {
                initial = IntervalSet.BOOLEANTOP;
                break;
            }
            case Zeno: {
                initial = IntervalSet.TOP;
                break;
            }
            case Address: {
                initial = IntervalSet.GREATER_THAN_OR_EQUAL_TO_ZERO;
            }
        }
        if (value.isSome()) {
            initial = IntervalSet.valueOf(value.get());
        }
        updatedIntervalSets = updatedIntervalSets.bind(variable, initial);
        return this.build((AVLMap<NumVar, IntervalSet>)updatedIntervalSets);
    }

    @Override
    public IntervalSets project(VarSet vars) {
        FiniteMap result = this.intervalSets;
        for (NumVar variable : vars) {
            result = result.remove(variable);
        }
        if (DEBUGOTHER) {
            System.out.println("INTERVALSETS:");
            System.out.println("  project: " + vars);
            System.out.println("  values: " + result);
        }
        return this.build((AVLMap<NumVar, IntervalSet>)result);
    }

    @Override
    public IntervalSets substitute(NumVar x, NumVar y) {
        FiniteMap updatedIntervalSets = this.intervalSets;
        Option<IntervalSet> valueOfXOption = ((AVLMap)updatedIntervalSets).get((NumVar)x);
        if (valueOfXOption.isNone()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        IntervalSet valueOfX = valueOfXOption.get();
        updatedIntervalSets = ((AVLMap)updatedIntervalSets).remove(x);
        updatedIntervalSets = ((AVLMap)updatedIntervalSets).bind(y, valueOfX);
        return this.build((AVLMap<NumVar, IntervalSet>)updatedIntervalSets);
    }

    @Override
    public IntervalSets expand(FoldMap vars) {
        FiniteMap updatedIntervals = this.intervalSets;
        for (VarPair vp : vars) {
            Option<IntervalSet> valueOfPermanentOption = updatedIntervals.get((NumVar)vp.getPermanent());
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            IntervalSet valueOfPermanent = valueOfPermanentOption.get();
            updatedIntervals = updatedIntervals.bind(vp.getEphemeral(), valueOfPermanent);
        }
        return this.build((AVLMap<NumVar, IntervalSet>)updatedIntervals);
    }

    @Override
    public IntervalSets fold(FoldMap vars) {
        FiniteMap updatedIntervals = this.intervalSets;
        for (VarPair vp : vars) {
            Option<IntervalSet> valueOfPermanentOption = ((AVLMap)updatedIntervals).get(vp.getPermanent());
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            IntervalSet valueOfPermanent = valueOfPermanentOption.get();
            Option<IntervalSet> valueOfEphemeralOption = ((AVLMap)updatedIntervals).get(vp.getEphemeral());
            if (valueOfEphemeralOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            IntervalSet valueOfEphemeral = valueOfEphemeralOption.get();
            updatedIntervals = ((AVLMap)updatedIntervals).remove(vp.getEphemeral());
            updatedIntervals = ((AVLMap)updatedIntervals).bind(vp.getPermanent(), valueOfPermanent.join(valueOfEphemeral));
        }
        return this.build((AVLMap<NumVar, IntervalSet>)updatedIntervals);
    }

    @Override
    public IntervalSets copyAndPaste(VarSet vars, IntervalSets from) {
        FiniteMap updatedIntervals = this.intervalSets;
        for (NumVar var : vars) {
            IntervalSet value = from.intervalSets.get(var).getOrNull();
            if (value == null) {
                throw new DomainStateException.VariableSupportSetException();
            }
            updatedIntervals = updatedIntervals.bind(var, value);
        }
        return this.build((AVLMap<NumVar, IntervalSet>)updatedIntervals);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e(NAME);
        for (P2<NumVar, IntervalSet> p2 : this.intervalSets) {
            IntervalSet value = p2._2();
            builder = builder.e("Entry").a("type", "intervalSet").e("Variable").t(p2._1().toString()).up();
            for (Interval interval : value) {
                builder = builder.e("Value").e("lowerBound").t(interval.low().toString()).up().e("upperBound").t(interval.high().toString()).up();
                builder = builder.up();
            }
            builder = builder.up();
        }
        builder = builder.up();
        return builder;
    }

    @Override
    public void toString(DomainStringBuilder builder) {
        builder.append(NAME, this.toString());
    }

    @Override
    public Range queryRange(Linear lin) {
        IntervalSet intervalSet = this.evaluate(lin);
        Range.IntervalSetRange result = Range.from(intervalSet);
        if (DEBUGOTHER) {
            System.out.println("INTERVALSETS:");
            System.out.println("  query: " + lin);
            System.out.println("  values: " + this);
            System.out.println("  result: " + result);
        }
        return result;
    }

    @Override
    public SynthChannel getSynthChannel() {
        SynthChannel syn = new SynthChannel();
        for (NumVar var : this.equalities) {
            syn.addEquation(Linear.linear(this.intervalSets.get(var).get().getConstantOrNull().negate(), Linear.term(var)).toEquality());
        }
        return syn;
    }

    private IntervalSets build(AVLMap<NumVar, IntervalSet> intervals, VarSet equalities) {
        return new IntervalSets(intervals, equalities, this.getContext());
    }

    private IntervalSets build(AVLMap<NumVar, IntervalSet> intervals) {
        return this.build(intervals, VarSet.empty());
    }

    public String toString() {
        return "INTERVALSETS: #" + this.intervalSets.size() + " " + this.intervalSets.toString();
    }

    private IntervalSet evaluate(Zeno.Rhs rhs) {
        return rhs.accept(RhsEvaluator.INSTANCE, this);
    }

    private IntervalSet evaluate(Linear linear) {
        IntervalSet res = IntervalSet.ZERO;
        for (Linear.Term term : linear) {
            IntervalSet value = this.intervalSets.get(term.getId()).getOrElse(IntervalSet.TOP).mul(term.getCoeff());
            res = res.add(value);
        }
        res = res.add(linear.getConstant());
        return res;
    }

    @Override
    public SetOfEquations queryEqualities(NumVar variable) {
        return SetOfEquations.empty();
    }

    private static final class RhsEvaluator
    extends ZenoRhsVisitorSkeleton<IntervalSet, IntervalSets> {
        private static final RhsEvaluator INSTANCE = new RhsEvaluator();

        private RhsEvaluator() {
        }

        @Override
        public IntervalSet visit(Zeno.Bin stmt, IntervalSets intervals) {
            IntervalSet approximation;
            IntervalSet left = stmt.getLeft().accept(this, intervals);
            IntervalSet right = stmt.getRight().accept(this, intervals);
            if (left.isConstant() && right.isConstant()) {
                return IntervalSet.valueOf(RhsEvaluator.applyToConstants(stmt.getOp(), left.getConstantOrNull(), right.getConstantOrNull()));
            }
            switch (stmt.getOp()) {
                case Mul: {
                    approximation = left.mul(right);
                    break;
                }
                case Div: {
                    approximation = left.divRoundZero(right);
                    break;
                }
                case Shl: {
                    approximation = left.shl(right);
                    break;
                }
                case Shr: {
                    approximation = left.shr(right);
                    break;
                }
                case Mod: {
                    approximation = IntervalSet.TOP;
                    break;
                }
                default: {
                    approximation = IntervalSet.TOP;
                }
            }
            return approximation;
        }

        private static BigInt applyToConstants(Zeno.ZenoBinOp op, BigInt left, BigInt right) {
            switch (op) {
                case Div: {
                    if (right.isZero()) {
                        return Bound.ZERO;
                    }
                    return left.divRoundZero(right);
                }
                case Mod: {
                    return left.mod(right);
                }
                case Mul: {
                    return left.mul(right);
                }
                case Shl: {
                    return left.shl(right);
                }
                case Shr: {
                    return left.shr(right);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public IntervalSet visit(Zeno.Rlin stmt, IntervalSets intervals) {
            IntervalSet res = intervals.evaluate(stmt.getLinearTerm());
            return res.divRoundInvards(stmt.getDivisor());
        }

        @Override
        public IntervalSet visit(Zeno.RangeRhs zenoRange, IntervalSets intervals) {
            Range range = zenoRange.getRange();
            return range.asSet();
        }
    }
}

