/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.gauge;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domains.affine.Substitution;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;

class Wedge {
    private final P2<Option<Linear>, Option<Linear>> bounds;
    private final boolean is_empty;
    private static final P2<Option<Linear>, Option<Linear>> EMPTY_bounds = P2.tuple2(Option.some(Linear.linear(BigInt.of(1L))), Option.some(Linear.linear(BigInt.of(0L))));
    public static final Wedge EMPTY = new Wedge(EMPTY_bounds);
    private static final Option<Linear> NoneLinear = Option.none();
    public static final Wedge FULL = new Wedge(P2.tuple2(NoneLinear, NoneLinear));

    public static final Wedge wedge(P2<Option<Linear>, Option<Linear>> bounds) {
        return new Wedge(bounds);
    }

    public Wedge(P2<Option<Linear>, Option<Linear>> bounds) {
        this.bounds = bounds;
        boolean bl = this.is_empty = this.hasLowerBound() && this.hasUpperBound() && !Wedge.leq(this.lower(), this.upper());
        if (this.hasLowerBound() && this.lower() == null) {
            throw new IllegalArgumentException("WHAT THE FUCK.");
        }
        if (this.is_empty) {
            bounds = EMPTY_bounds;
        }
    }

    public VarSet getVars() {
        VarSet lowerVars = VarSet.empty();
        VarSet upperVars = VarSet.empty();
        if (this.hasLowerBound()) {
            lowerVars = this.lower().getVars();
        }
        if (this.hasUpperBound()) {
            upperVars = this.upper().getVars();
        }
        return lowerVars.union(upperVars);
    }

    public boolean hasLowerBound() {
        return this.bounds._1().isSome();
    }

    public boolean hasUpperBound() {
        return this.bounds._2().isSome();
    }

    public Linear lower() {
        return this.bounds._1().getOrElse(null);
    }

    public Option<Linear> lowerOption() {
        return this.bounds._1();
    }

    public Linear upper() {
        return this.bounds._2().getOrElse(null);
    }

    public Option<Linear> upperOption() {
        return this.bounds._2();
    }

    public boolean isSingleton() {
        return this.hasLowerBound() && this.hasUpperBound() && this.lower().isConstantOnly() && this.lower().equals(this.upper());
    }

    public Wedge add(Wedge other) {
        Option<Object> sumL = Option.none();
        Option<Object> sumU = Option.none();
        if (this.hasLowerBound() && other.hasLowerBound()) {
            sumL = Option.some(Linear.mulAdd(Bound.ONE, this.lower(), Bound.ONE, other.lower()));
        }
        if (this.hasUpperBound() && other.hasUpperBound()) {
            sumU = Option.some(Linear.mulAdd(Bound.ONE, this.upper(), Bound.ONE, other.upper()));
        }
        return Wedge.wedge(P2.tuple2(sumL, sumU));
    }

    public Wedge subtract(Wedge other) {
        Option<Object> sumL = Option.none();
        Option<Object> sumU = Option.none();
        if (this.hasLowerBound() && other.hasUpperBound()) {
            sumL = Option.some(Linear.mulAdd(Bound.ONE, this.lower(), Bound.MINUSONE, other.upper()));
        }
        if (this.hasUpperBound() && other.hasLowerBound()) {
            sumU = Option.some(Linear.mulAdd(Bound.ONE, this.upper(), Bound.MINUSONE, other.lower()));
        }
        return Wedge.wedge(P2.tuple2(sumL, sumU));
    }

    public Wedge multiply(Wedge other) {
        if (other.isSingleton()) {
            BigInt c = other.lower().getConstant();
            if (c.compareTo(Bound.ZERO) >= 0) {
                return Wedge.wedge(P2.tuple2(this.hasLowerBound() ? Option.some(this.lower().smul(c)) : NoneLinear, this.hasUpperBound() ? Option.some(this.upper().smul(c)) : NoneLinear));
            }
            return Wedge.wedge(P2.tuple2(this.hasUpperBound() ? Option.some(this.upper().smul(c)) : NoneLinear, this.hasLowerBound() ? Option.some(this.lower().smul(c)) : NoneLinear));
        }
        if (this.isSingleton()) {
            return other.multiply(this);
        }
        return FULL;
    }

    public Wedge inc(NumVar lambda, BigInt k) {
        if (!this.hasLowerBound() && !this.hasUpperBound()) {
            return FULL;
        }
        if (this.hasLowerBound() && !this.hasUpperBound()) {
            Linear l = this.lower();
            return Wedge.wedge(P2.tuple2(Option.some(l.dropConstant().add(l.getConstant().sub(k.mul(l.getCoeff(lambda))))), Option.none()));
        }
        if (!this.hasLowerBound() && this.hasUpperBound()) {
            Linear u = this.upper();
            return Wedge.wedge(P2.tuple2(Option.none(), Option.some(u.dropConstant().add(u.getConstant().sub(k.mul(u.getCoeff(lambda)))))));
        }
        Linear l = this.lower();
        Linear u = this.upper();
        BigInt lc = l.getConstant().sub(k.mul(l.getCoeff(lambda))).min(u.getConstant().sub(k.mul(u.getCoeff(lambda))));
        BigInt uc = l.getConstant().sub(k.mul(l.getCoeff(lambda))).max(u.getConstant().sub(k.mul(u.getCoeff(lambda))));
        return Wedge.wedge(P2.tuple2(Option.some(l.dropConstant().add(lc)), Option.some(u.dropConstant().add(uc))));
    }

    private static boolean leq(boolean smallUpper, Option<Linear> small, boolean bigUpper, Option<Linear> big) {
        if (small.isSome() && big.isSome()) {
            return Wedge.leq(small.get(), big.get());
        }
        if (smallUpper && bigUpper && small.isNone() && big.isSome()) {
            return false;
        }
        if (smallUpper && !bigUpper && big.isNone()) {
            return false;
        }
        return smallUpper || bigUpper || !small.isSome() || !big.isNone();
    }

    private static boolean leq(Linear small, Linear big) {
        if (small.getConstant().compareTo(big.getConstant()) > 0) {
            return false;
        }
        for (NumVar counter : small.getVars().union(big.getVars())) {
            if (small.getCoeff(counter).compareTo(big.getCoeff(counter)) <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean subsetOrEqualTo(Wedge other) {
        return Wedge.leq(false, other.lowerOption(), false, this.lowerOption()) && Wedge.leq(true, this.upperOption(), true, other.upperOption());
    }

    public boolean isEmpty() {
        return this.is_empty;
    }

    public Wedge partialJoin(Wedge other, VarSet I) {
        Option<Object> w_lower = this.hasLowerBound() && other.hasLowerBound() ? Option.some(Linear.linear(other.lower().getConstant().min(this.lower().getConstant()))) : Option.none();
        Option<Object> w_upper = this.hasUpperBound() && other.hasUpperBound() ? Option.some(Linear.linear(other.upper().getConstant().max(this.upper().getConstant()))) : Option.none();
        VarSet Lambda = this.getVars().union(other.getVars());
        for (NumVar v : Lambda) {
            if (I.contains(v)) {
                if (w_lower.isSome()) {
                    w_lower = Option.some(((Linear)w_lower.get()).addTerm(this.lower().getCoeff(v).min(other.lower().getCoeff(v)), v));
                }
                if (!w_upper.isSome()) continue;
                w_upper = Option.some(((Linear)w_upper.get()).addTerm(this.upper().getCoeff(v).max(other.upper().getCoeff(v)), v));
                continue;
            }
            if (w_lower.isSome()) {
                w_lower = Option.some(((Linear)w_lower.get()).addTerm(this.lower().getCoeff(v), v));
            }
            if (!w_upper.isSome()) continue;
            w_upper = Option.some(((Linear)w_upper.get()).addTerm(this.upper().getCoeff(v), v));
        }
        return Wedge.wedge(P2.tuple2(w_lower, w_upper));
    }

    public Wedge applySubstitution(Substitution sigma) {
        P2<Option<Linear>, Option<Linear>> new_bounds = P2.tuple2(this.bounds._1(), this.bounds._2());
        if (new_bounds._1().isSome()) {
            Linear lb = new_bounds._1().get();
            lb = lb.applySubstitution(sigma);
            new_bounds = P2.tuple2(Option.some(lb), new_bounds._2());
        }
        if (new_bounds._2().isSome()) {
            Linear ub = new_bounds._2().get();
            ub = ub.applySubstitution(sigma);
            new_bounds = P2.tuple2(new_bounds._1(), Option.some(ub));
        }
        return Wedge.wedge(new_bounds);
    }

    public Wedge applySubstitution(Substitution sigma_l, Substitution sigma_u) {
        P2<Option<Linear>, Option<Linear>> new_bounds = P2.tuple2(this.bounds._1(), this.bounds._2());
        if (new_bounds._1().isSome()) {
            Linear lb = new_bounds._1().get();
            lb = lb.applySubstitution(sigma_l);
            new_bounds = P2.tuple2(Option.some(lb), new_bounds._2());
        }
        if (new_bounds._2().isSome()) {
            Linear ub = new_bounds._2().get();
            ub = ub.applySubstitution(sigma_u);
            new_bounds = P2.tuple2(new_bounds._1(), Option.some(ub));
        }
        return Wedge.wedge(new_bounds);
    }

    public Wedge widenLI(Wedge other, NumVar lambda_i, BigInt u, BigInt v) {
        return this.widenLI(other, lambda_i, Option.some(u), Option.some(v));
    }

    public Wedge widenLI(Wedge other, NumVar lambda_i, Option<BigInt> u_option, Option<BigInt> v_option) {
        VarSet Lambda1 = this.getVars();
        VarSet Lambda2 = other.getVars();
        VarSet Lambda = Lambda1.union(Lambda2);
        if (!(this.hasLowerBound() && other.hasLowerBound() && this.hasUpperBound() && other.hasUpperBound())) {
            return FULL;
        }
        if (u_option.isNone()) {
            throw new IllegalArgumentException("Called WidenLI[u=T,v=*]");
        }
        if (Lambda1.contains(lambda_i) && Lambda2.contains(lambda_i)) {
            throw new IllegalArgumentException("Called WidenLI[u!=T,v!=T] with a counter that has nonzero coefficients in both wedges.");
        }
        if (!Lambda1.contains(lambda_i) && v_option.isNone()) {
            throw new IllegalArgumentException("Called WidenLI[u=*,v=T] where the counter does not occur on the left.");
        }
        BigInt alpha = null;
        BigInt beta = null;
        BigInt u = u_option.get();
        if (Lambda1.contains(lambda_i) && v_option.isNone()) {
            alpha = other.lower().getCoeff(lambda_i);
            beta = other.upper().getCoeff(lambda_i);
        } else {
            BigInt v = v_option.get();
            if (v.isEqualTo(u)) {
                throw new IllegalArgumentException("Called WidenLI with v=u");
            }
            BigInt v_sub_u = v.sub(u);
            if (this.hasLowerBound() && other.hasLowerBound()) {
                alpha = other.lower().getConstant().sub(this.lower().getConstant()).div(v_sub_u);
            }
            if (this.hasUpperBound() && other.hasUpperBound()) {
                BigInt[] divrem = other.upper().getConstant().sub(this.upper().getConstant()).divideAndRemainder(v_sub_u);
                beta = divrem[1].isEqualTo(Bound.ZERO) ? divrem[0] : divrem[0].add(Bound.ONE);
            }
        }
        assert (alpha != null && beta != null);
        BigInt alpha0 = this.lower().getConstant().sub(alpha.mul(u));
        BigInt beta0 = this.upper().getConstant().sub(beta.mul(u));
        BigInt c0 = alpha0.min(beta0);
        BigInt d0 = alpha0.max(beta0);
        Option<Linear> w_lower = Option.some(Linear.linear(c0));
        Option<Linear> w_upper = Option.some(Linear.linear(d0));
        Lambda = Lambda.add(lambda_i);
        for (NumVar var : Lambda) {
            BigInt coeff;
            if (var.equalTo(lambda_i)) {
                if (w_lower.isSome() && !alpha.min(beta).isEqualTo(Bound.ZERO)) {
                    w_lower = Option.some(w_lower.get().addTerm(alpha.min(beta), var));
                }
                if (!w_upper.isSome() || alpha.max(beta).isEqualTo(Bound.ZERO)) continue;
                w_upper = Option.some(w_upper.get().addTerm(alpha.max(beta), var));
                continue;
            }
            if (w_lower.isSome() && !(coeff = this.lower().getCoeff(var).min(other.lower().getCoeff(var))).isEqualTo(Bound.ZERO)) {
                w_lower = Option.some(w_lower.get().addTerm(coeff, var));
            }
            if (!w_upper.isSome() || (coeff = this.upper().getCoeff(var).max(other.upper().getCoeff(var))).isEqualTo(Bound.ZERO)) continue;
            w_upper = Option.some(w_upper.get().addTerm(coeff, var));
        }
        return Wedge.wedge(P2.tuple2(w_lower, w_upper));
    }

    public Wedge intervalWiden(Wedge other) {
        Wedge result = null;
        if (other.subsetOrEqualTo(this)) {
            result = this;
        }
        if (!Wedge.leq(true, other.upperOption(), true, this.upperOption()) && Wedge.leq(false, this.lowerOption(), true, other.upperOption())) {
            result = Wedge.wedge(P2.tuple2(this.lowerOption(), NoneLinear));
        }
        if (!Wedge.leq(false, this.lowerOption(), false, other.lowerOption()) && Wedge.leq(true, other.upperOption(), true, this.upperOption())) {
            result = Wedge.wedge(P2.tuple2(NoneLinear, this.upperOption()));
        }
        if (result == null) {
            result = FULL;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Wedge)) {
            return false;
        }
        Wedge other = (Wedge)o;
        return other.bounds.equals(this.bounds);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("W[");
        if (this.hasLowerBound()) {
            builder.append(this.lower());
        } else {
            builder.append("-oo");
        }
        builder.append(", ");
        if (this.hasUpperBound()) {
            builder.append(this.upper());
        } else {
            builder.append("+oo");
        }
        builder.append("]");
        return builder.toString();
    }

    public static Wedge singleton(BigInt value) {
        return Wedge.wedge(P2.tuple2(Option.some(Linear.linear(value)), Option.some(Linear.linear(value))));
    }

    public Wedge forgetCounter(NumVar lambda, Range lambda_range) {
        Substitution sigma_id;
        if (!this.getVars().contains(lambda)) {
            return this;
        }
        Interval I = lambda_range.convexHull();
        Substitution sigma_l = sigma_id = new Substitution(lambda, Linear.linear(lambda), Bound.ONE);
        Substitution sigma_u = sigma_id;
        if (I.low().isFinite()) {
            sigma_l = new Substitution(lambda, Linear.linear(I.low().asInteger()), Bound.ONE);
        }
        if (I.high().isFinite()) {
            sigma_u = new Substitution(lambda, Linear.linear(I.high().asInteger()), Bound.ONE);
        }
        return this.applySubstitution(sigma_l, sigma_u);
    }

    public Wedge join(Wedge other) {
        return this.partialJoin(other, this.getVars().union(other.getVars()));
    }
}

