/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.finitesupportset;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import com.jamesmurty.utils.XMLBuilder;

public class SupportSetState
extends FunctorState {
    private static final SupportSetState EMPTY = new SupportSetState(VarSet.empty());
    private final VarSet vars;

    private SupportSetState(VarSet vs) {
        this.vars = vs;
    }

    static SupportSetState empty() {
        return EMPTY;
    }

    public VarSet getSupportSet() {
        return this.vars;
    }

    void have(Linear lin) {
        this.have(lin.getVars());
    }

    void have(NumVar v) {
        assert (this.vars.contains(v)) : "variable " + v + " is not in support set";
    }

    void have(Finite.Rlin ptr) {
        this.have(ptr.getVars());
    }

    void have(VarSet vs) {
        VarSet difference = vs.difference(this.vars);
        assert (difference.isEmpty()) : "vars missing: " + difference;
    }

    void haveNot(NumVar v) {
        assert (!this.vars.contains(v)) : "variable " + v + " should not be in support set";
    }

    void haveNot(VarSet vs) {
        VarSet toomuch = this.vars.intersection(vs);
        assert (toomuch.isEmpty()) : "variables " + toomuch + " should not be in support set";
    }

    void sameAs(SupportSetState other) {
        VarSet thisWithoutOther = this.vars.difference(other.vars);
        VarSet otherWithoutThis = other.vars.difference(this.vars);
        assert (otherWithoutThis.isEmpty()) : "first set  " + this.vars + " does not contain " + otherWithoutThis;
        assert (thisWithoutOther.isEmpty()) : "second set " + other.vars + " does not contain " + thisWithoutOther;
    }

    SupportSetState with(NumVar v) {
        this.haveNot(v);
        return new SupportSetState(this.vars.add(v));
    }

    SupportSetState with(VarSet vs) {
        this.haveNot(vs);
        return new SupportSetState(this.vars.union(vs));
    }

    SupportSetState without(NumVar v) {
        this.have(v);
        return new SupportSetState(this.vars.remove(v));
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder;
        xml = xml.e("SupportSet").e("Entry");
        xml = xml.a("type", "SupportSet");
        for (NumVar variable : this.getSupportSet()) {
            xml = xml.e("Variable").t(variable.toString());
            xml = xml.up();
        }
        xml = xml.up();
        xml = xml.up();
        return xml;
    }

    public final String toString() {
        return "#" + this.vars.size() + " " + this.vars.toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }
}

