/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.finiteDisjunction;

import bindead.abstractsyntax.finite.Finite;
import bindead.data.Linear;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.debug.DomainPrintProperties;
import bindead.debug.DomainStringBuilder;
import bindead.domainnetwork.channels.DebugChannel;
import bindead.domainnetwork.channels.Domain;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.FiniteDomain;
import bindead.domainnetwork.interfaces.SemiLattice;
import bindead.exceptions.Unreachable;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLSet;
import rreil.lang.MemVar;
import rreil.lang.util.Type;

public final class FiniteDisjunction<D extends FiniteDomain<D>>
extends Domain<FiniteDisjunction<D>>
implements FiniteDomain<FiniteDisjunction<D>> {
    public static final String NAME = "DISJUNCTION";
    private final boolean compactPrinting;
    public final LinkedList<D> childState;

    public FiniteDisjunction(D child) {
        super(NAME);
        this.compactPrinting = DomainPrintProperties.INSTANCE.printCompact.isTrue();
        this.childState = this.newcs();
        this.childState.add(child);
    }

    public FiniteDisjunction(LinkedList<D> child) {
        super(NAME);
        this.compactPrinting = DomainPrintProperties.INSTANCE.printCompact.isTrue();
        this.childState = child;
    }

    private LinkedList<D> newcs() {
        return new LinkedList();
    }

    private FiniteDisjunction<D> build(LinkedList<D> cs) {
        if (cs.isEmpty()) {
            throw new Unreachable();
        }
        return new FiniteDisjunction<D>(cs);
    }

    @Override
    public FiniteDisjunction<D> copyAndPaste(VarSet vars, FiniteDisjunction<D> from) {
        D fromc = super.collapse();
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.copyAndPaste(vars, fromc));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    private D collapse() {
        Iterator it = this.childState.iterator();
        assert (it.hasNext());
        FiniteDomain collected = (FiniteDomain)it.next();
        while (it.hasNext()) {
            collected = (FiniteDomain)collected.join((SemiLattice)it.next());
        }
        return (D)collected;
    }

    @Override
    public List<P2<NumVar.AddrVar, FiniteDisjunction<D>>> deprecatedDeref(Finite.Rlin ptr, VarSet summaries) throws Unreachable {
        LinkedList<P2<NumVar.AddrVar, FiniteDisjunction<D>>> alts = new LinkedList<P2<NumVar.AddrVar, FiniteDisjunction<D>>>();
        for (FiniteDomain c : this.childState) {
            try {
                for (P2 ca : c.deprecatedDeref(ptr, summaries)) {
                    NumVar.AddrVar adr = ca._1();
                    alts.add(new P2<NumVar.AddrVar, FiniteDisjunction<FiniteDomain>>(adr, new FiniteDisjunction<FiniteDomain>((FiniteDomain)ca._2())));
                }
            }
            catch (Unreachable unreachable) {
            }
        }
        return alts;
    }

    @Override
    public FiniteDisjunction<D> eval(Finite.Assign stmt) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.eval(stmt));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> eval(Finite.Test test) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.eval(test));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> introduce(NumVar var, Type type, Option<BigInt> value) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.introduce(var, type, value));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> project(NumVar var) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.project(var));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public SetOfEquations queryEqualities(NumVar var) {
        return SetOfEquations.empty();
    }

    @Override
    public Range queryRange(Linear lin) {
        Iterator it = this.childState.iterator();
        assert (it.hasNext());
        Range result = ((FiniteDomain)it.next()).queryRange(lin);
        while (it.hasNext()) {
            result = result.union(((FiniteDomain)it.next()).queryRange(lin));
        }
        return result;
    }

    @Override
    public FiniteDisjunction<D> substitute(NumVar from, NumVar to) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.substitute(from, to));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> assumeConcrete(NumVar var) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.assumeConcrete(var));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> assumePointsToAndConcretize(Finite.Rlin refVar, NumVar.AddrVar target, VarSet contents) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.assumePointsToAndConcretize(refVar, target, contents));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public P2<AVLSet<NumVar.AddrVar>, FiniteDisjunction<D>> deref(Finite.Rlin ptr) throws Unreachable {
        AVLSet<NumVar.AddrVar> vs = AVLSet.empty();
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                P2 p2 = c.deref(ptr);
                vs = vs.union(p2._1());
                cs.add(p2._2());
            }
            catch (Unreachable unreachable) {}
        }
        return P2.tuple2(vs, this.build(cs));
    }

    @Override
    public Collection<NumVar.AddrVar> findPossiblePointerTargets(NumVar id) throws Unreachable {
        LinkedList<NumVar.AddrVar> cs = new LinkedList<NumVar.AddrVar>();
        for (FiniteDomain c : this.childState) {
            try {
                cs.addAll(c.findPossiblePointerTargets(id));
            }
            catch (Unreachable unreachable) {}
        }
        return cs;
    }

    @Override
    public FiniteDisjunction<D> join(FiniteDisjunction<D> other) {
        LinkedList<D> cs = new LinkedList<D>(this.childState);
        cs.addAll(other.childState);
        FiniteDisjunction<D> built = this.build(cs);
        return built;
    }

    @Override
    public FiniteDisjunction<D> widen(FiniteDisjunction<D> other) {
        return new FiniteDisjunction<FiniteDomain>((FiniteDomain)this.collapse().widen(super.collapse()));
    }

    @Override
    public boolean subsetOrEqual(FiniteDisjunction<D> other) {
        return this.collapse().subsetOrEqual(super.collapse());
    }

    @Override
    public FiniteDisjunction<D> addToState(FiniteDisjunction<D> newState, boolean isWideningPoint) {
        if (newState == this || newState.subsetOrEqual(this)) {
            return null;
        }
        if (isWideningPoint) {
            return this.widen(newState);
        }
        return this.join(newState);
    }

    @Override
    public AnalysisCtx getContext() {
        return ((FiniteDomain)this.childState.get(0)).getContext();
    }

    @Override
    public FiniteDisjunction<D> setContext(AnalysisCtx ctx) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.setContext(ctx));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public SynthChannel getSynthChannel() {
        return new SynthChannel();
    }

    @Override
    public DebugChannel getDebugChannel() {
        return new DebugChannel();
    }

    @Override
    public final XMLBuilder toXML(XMLBuilder builder) {
        assert (false) : "implement";
        return builder;
    }

    @Override
    public final void toString(DomainStringBuilder builder) {
        for (FiniteDomain c : this.childState) {
            builder.append(NAME, "\nAlternative:\n");
            c.toString(builder);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.compactPrinting) {
            this.toCompactString(builder);
        } else {
            for (FiniteDomain c : this.childState) {
                builder.append("\nAlternative:\n");
                builder.append(c.toString());
            }
        }
        return builder.toString();
    }

    @Override
    public final void toCompactString(StringBuilder builder) {
        for (FiniteDomain c : this.childState) {
            builder.append("\nAlternative:\n");
            c.toCompactString(builder);
        }
    }

    @Override
    public void varToCompactString(StringBuilder builder, NumVar var) {
        Iterator it = this.childState.iterator();
        assert (it.hasNext());
        FiniteDomain first = (FiniteDomain)it.next();
        if (!it.hasNext()) {
            first.varToCompactString(builder, var);
            return;
        }
        builder.append("(");
        first.varToCompactString(builder, var);
        while (it.hasNext()) {
            builder.append(" v ");
            ((FiniteDomain)it.next()).varToCompactString(builder, var);
        }
        builder.append(")");
    }

    @Override
    public Range queryEdgeFlag(NumVar src, NumVar.AddrVar tgt) {
        Iterator it = this.childState.iterator();
        assert (it.hasNext());
        Range result = ((FiniteDomain)it.next()).queryEdgeFlag(src, tgt);
        while (it.hasNext()) {
            result = result.union(((FiniteDomain)it.next()).queryEdgeFlag(src, tgt));
        }
        return result;
    }

    @Override
    public FiniteDisjunction<D> assumeEdgeFlag(NumVar refVar, NumVar.AddrVar target, BigInt value) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.assumeEdgeFlag(refVar, target, value));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> copyVariable(NumVar to, NumVar from) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.copyVariable(to, from));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> assumeEdgeNG(Finite.Rlin pointerVar, NumVar.AddrVar targetAddr) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.assumeEdgeNG(pointerVar, targetAddr));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> expandNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.expandNG(p, e, nvps));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> concretizeAndDisconnectNG(NumVar.AddrVar s, VarSet cs) {
        throw new UnimplementedException();
    }

    @Override
    public FiniteDisjunction<D> bendBackGhostEdgesNG(NumVar.AddrVar s, NumVar.AddrVar c, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        throw new UnimplementedException();
    }

    @Override
    public FiniteDisjunction<D> expandNG(ListVarPair nvps) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.expandNG(nvps));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> foldNG(ListVarPair nvps) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.foldNG(nvps));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> foldNG(NumVar.AddrVar p, NumVar.AddrVar e, ListVarPair nvps) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.foldNG(p, e, nvps));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public FiniteDisjunction<D> bendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        LinkedList<D> cs = this.newcs();
        for (FiniteDomain c : this.childState) {
            try {
                cs.add(c.bendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc));
            }
            catch (Unreachable unreachable) {}
        }
        return this.build(cs);
    }

    @Override
    public List<FiniteDisjunction<D>> enumerateAlternatives() {
        LinkedList<FiniteDisjunction<D>> cs = new LinkedList<FiniteDisjunction<D>>();
        for (FiniteDomain c : this.childState) {
            cs.add(new FiniteDisjunction<FiniteDomain>(c));
        }
        return cs;
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        throw new UnimplementedException();
    }

    @Override
    public FiniteDisjunction<D> assumeVarsAreEqual(int size, NumVar fst, NumVar snd) {
        throw new UnimplementedException();
    }
}

