/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.congruences;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.congruences.CongruenceProperties;
import bindead.domains.congruences.CongruenceStateBuilder;
import bindead.domains.congruences.Congruences;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Congruence;
import javalx.persistentcollections.FiniteMap;

class ScalingVisitor
extends ZenoRhsVisitorSkeleton<Zeno.Rhs, CongruenceStateBuilder> {
    private static final ZenoFactory zeno = ZenoFactory.getInstance();
    private static final ScalingVisitor visitor = new ScalingVisitor();

    ScalingVisitor() {
    }

    public static void run(Zeno.Assign ass, CongruenceStateBuilder sys) {
        Zeno.Rhs newRhs = ass.getRhs().accept(visitor, sys);
        sys.getChildOps().addAssignment(zeno.assign(ass.getLhs(), newRhs));
        Congruence approximation = RhsVisitor.run(ass.getRhs(), sys);
        sys.state = sys.state.bind((Object)ass.getLhs().getId(), (Object)approximation);
        if (approximation.getScale().isGreaterThan(Bound.ONE)) {
            sys.getChildOps().addScaleDown(ass.getLhs().getId(), approximation);
        }
    }

    public static void run(Zeno.Test test, CongruenceStateBuilder sys) {
        Linear.Divisor d;
        Linear le = test.getExpr();
        Linear res = sys.inlineIntoLinear(le, d = Linear.Divisor.one());
        Zeno.Test inlinedTest = zeno.comparison(zeno.linear(res, d.get()), test.getOperator());
        if (!ZenoTestHelper.isTautologyReportUnreachable(inlinedTest)) {
            sys.getChildOps().addTest(inlinedTest);
        }
        boolean DEBUGTESTS = CongruenceProperties.INSTANCE.debugTests.isTrue();
        Linear lin = test.getExpr();
        FiniteMap newState = sys.state;
        boolean allReachable = true;
        if (lin.isConstantOnly()) {
            BigInt constant = lin.getConstant();
            switch (test.getOperator()) {
                case EqualToZero: {
                    allReachable = constant.isZero();
                    break;
                }
                case NotEqualToZero: {
                    allReachable = !constant.isZero();
                    break;
                }
                case LessThanOrEqualToZero: {
                    allReachable = !constant.isPositive();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        } else {
            block5 : switch (test.getOperator()) {
                case EqualToZero: {
                    for (Linear.Term term : lin) {
                        NumVar var = term.getId();
                        Congruence currentVariableCongruence = sys.state.get(var).get();
                        Linear remaining = lin.dropTerm(var).negate();
                        BigInt varCoeff = term.getCoeff();
                        Congruence remainingTermsCongruence = Congruences.evaluateCongruences(remaining, sys.state);
                        if (remainingTermsCongruence.isConstantOnly() && !varCoeff.abs().isEqualTo(Bound.ONE)) continue;
                        remainingTermsCongruence = remainingTermsCongruence.div(varCoeff.abs());
                        Option<Congruence> meet = currentVariableCongruence.meet(remainingTermsCongruence = remainingTermsCongruence.mul(BigInt.of(varCoeff.sign())));
                        if (meet.isSome()) {
                            Congruence newVariableCongruence = meet.get();
                            if (newVariableCongruence.equals(currentVariableCongruence)) continue;
                            newState = newState.bind(var, newVariableCongruence);
                            if (newVariableCongruence.isConstantOnly()) {
                                Zeno.Assign assign = zeno.assign(zeno.variable(var), zeno.literal(newVariableCongruence.getOffset()));
                                sys.getChildOps().addAssignment(assign);
                                continue;
                            }
                            sys.getChildOps().addScale(var, currentVariableCongruence, newVariableCongruence);
                            continue;
                        }
                        allReachable = false;
                        break block5;
                    }
                    break;
                }
                case NotEqualToZero: {
                    break;
                }
                case LessThanOrEqualToZero: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!allReachable) {
            if (DEBUGTESTS) {
                System.out.println("CONGRUENCES: ");
                System.out.println("  evaluating test: " + test);
                System.out.println("  before: " + sys.state);
                System.out.println("  after: <unreachable>");
            }
            throw new Unreachable();
        }
        if (DEBUGTESTS) {
            System.out.println("CONGRUENCES: ");
            System.out.println("  evaluating test: " + test);
            System.out.println("  before: " + sys.state);
            System.out.println("  after: " + newState);
        }
        sys.state = newState;
    }

    @Override
    public Zeno.Rhs visit(Zeno.RangeRhs expr, CongruenceStateBuilder sys) {
        return expr;
    }

    @Override
    public Zeno.Rhs visit(Zeno.Bin expr, CongruenceStateBuilder sys) {
        Zeno.Rlin l = (Zeno.Rlin)expr.getLeft().accept(this, sys);
        Zeno.Rlin r = (Zeno.Rlin)expr.getRight().accept(this, sys);
        if (l.equals(expr.getLeft()) && r.equals(expr.getRight())) {
            return expr;
        }
        return zeno.binary(l, expr.getOp(), r);
    }

    @Override
    public Zeno.Rhs visit(Zeno.Rlin expr, CongruenceStateBuilder sys) {
        Linear.Divisor d;
        Linear res;
        Linear le = expr.getLinearTerm();
        if (le.equals(res = sys.inlineIntoLinear(le, d = new Linear.Divisor(expr.getDivisor()))) && d.get().isEqualTo(expr.getDivisor())) {
            return expr;
        }
        return zeno.linear(res, d.get());
    }

    private static final class RhsVisitor
    extends ZenoRhsVisitorSkeleton<Congruence, CongruenceStateBuilder> {
        private static final RhsVisitor $ = new RhsVisitor();

        private RhsVisitor() {
        }

        public static Congruence run(Zeno.Rhs rhs, CongruenceStateBuilder congruences) {
            return rhs.accept($, congruences);
        }

        @Override
        public Congruence visit(Zeno.Bin stmt, CongruenceStateBuilder congruences) {
            Congruence left = stmt.getLeft().accept(this, congruences);
            Congruence right = stmt.getRight().accept(this, congruences);
            switch (stmt.getOp()) {
                case Mul: {
                    return left.mul(right);
                }
                case Div: {
                    if (left.isConstantOnly() || !right.isConstantOnly()) break;
                    if (right.getOffset().isZero()) {
                        return Congruence.ZERO;
                    }
                    return left.div(right.getOffset());
                }
                case Shl: {
                    if (!right.isConstantOnly()) break;
                    return left.shl(right.getOffset());
                }
                case Shr: {
                    if (!right.isConstantOnly()) break;
                    return left.shr(right.getOffset());
                }
            }
            return Congruence.ONE;
        }

        @Override
        public Congruence visit(Zeno.Rlin stmt, CongruenceStateBuilder congruences) {
            Congruence res = Congruences.evaluateCongruences(stmt.getLinearTerm(), congruences.state);
            if (res.isConstantOnly()) {
                BigInt constant = res.getOffset();
                BigInt[] divResult = constant.divideAndRemainder(stmt.getDivisor());
                if (!divResult[1].isZero()) {
                    throw new Unreachable();
                }
                return new Congruence(Bound.ZERO, divResult[0]);
            }
            return res.div(stmt.getDivisor());
        }

        @Override
        public Congruence visit(Zeno.RangeRhs range, CongruenceStateBuilder congruences) {
            return range.getRange().getCongruence();
        }
    }
}

