/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import apron.Abstract1;
import apron.ApronException;
import apron.Manager;
import bindead.data.NumVar;
import bindead.debug.StringHelpers;
import bindead.domains.apron.Marshaller;
import bindead.domains.apron.OctagonsMatrixPrinter;
import java.util.Iterator;
import java.util.SortedSet;
import javalx.numeric.Interval;
import javalx.persistentcollections.BiMap;

class PrettyPrinters {
    PrettyPrinters() {
    }

    public static String asIntervals(Abstract1 state, BiMap<NumVar, String> variablesMapping, boolean withConstants) {
        Manager man = state.getCreationManager();
        try {
            if (state.isBottom(man)) {
                return "<empty>";
            }
            if (state.isTop(man)) {
                return "<universal>";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            PrettyPrinters.printIntervals(state, variablesMapping, builder, withConstants);
            builder.append('}');
            return builder.toString();
        }
        catch (ApronException e) {
            return "<caught exception: " + e.getMessage() + ">";
        }
    }

    private static void printIntervals(Abstract1 state, BiMap<NumVar, String> variablesMapping, StringBuilder builder, boolean withConstants) throws ApronException {
        SortedSet<NumVar> sorted = StringHelpers.sortLexically(variablesMapping.keys());
        Iterator iterator = sorted.iterator();
        while (iterator.hasNext()) {
            NumVar variable = (NumVar)iterator.next();
            String varName = variable.toString();
            Interval value = Marshaller.fromApronInterval(state.getBound(state.getCreationManager(), variablesMapping.get(variable).get()));
            if (!withConstants && value.isConstant()) continue;
            builder.append(varName);
            builder.append('=');
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
    }

    public static String compactOctagons(Abstract1 state, BiMap<NumVar, String> variablesMapping) {
        try {
            Manager man0 = state.getCreationManager();
            if (state.isBottom(man0)) {
                return "<empty>";
            }
            if (state.isTop(man0)) {
                return "<universal>";
            }
            OctagonsMatrixPrinter octagonsMatrix = new OctagonsMatrixPrinter(state, variablesMapping);
            return octagonsMatrix.printMinimalContraints();
        }
        catch (ApronException e) {
            return "<caught exception: " + e.getMessage() + ">";
        }
    }
}

