/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domains.affine.Equation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.persistentcollections.AVLMap;

public class Equations
extends Vector<Equation> {
    private static final long serialVersionUID = 28345902384L;

    public Equations(int capacity) {
        super(capacity);
    }

    protected Equations(HashMap<Integer, NumVar> intToVar, Linear ... ls) {
        super(ls.length);
        for (Linear l : ls) {
            this.add(l.toEquation(intToVar));
        }
        this.elementCount = ls.length;
        Arrays.sort(this.elementData, 0, this.elementCount);
    }

    public Equations(AVLMap<NumVar, Linear> c1, AVLMap<NumVar, Linear> c2, HashMap<Integer, NumVar> intToVar) {
        super(c1.size() + c2.size());
        Iterator<P2<NumVar, Linear>> iter1 = c1.iterator();
        Iterator<P2<NumVar, Linear>> iter2 = c2.iterator();
        P2<NumVar, Linear> e1 = null;
        P2<NumVar, Linear> e2 = null;
        while (true) {
            if (e1 == null) {
                if (!iter1.hasNext()) {
                    if (e2 != null) {
                        this.add(((Linear)e2._2()).toEquation(intToVar));
                    }
                    while (iter2.hasNext()) {
                        this.add(iter2.next()._2().toEquation(intToVar));
                    }
                    break;
                }
                e1 = iter1.next();
            }
            if (e2 == null) {
                if (!iter2.hasNext()) {
                    if (e1 != null) {
                        this.add(e1._2().toEquation(intToVar));
                    }
                    while (iter1.hasNext()) {
                        this.add(iter1.next()._2().toEquation(intToVar));
                    }
                    break;
                }
                e2 = iter2.next();
            }
            if (((NumVar)e1._1()).compareTo((NumVar)e2._1()) < 0) {
                this.add(e1._2().toEquation(intToVar));
                e1 = null;
                continue;
            }
            this.add(e2._2().toEquation(intToVar));
            e2 = null;
        }
    }

    private Equations(Equations common, Equations eqs) {
        super(Math.max(0, common.size() - eqs.size()));
        int cIdx = 0;
        int eIdx = 0;
        while (cIdx < common.size() && eIdx < eqs.size()) {
            int eKey;
            int cKey = ((Equation)common.get(cIdx)).getKey();
            if (cKey < (eKey = ((Equation)eqs.get(eIdx)).getKey())) {
                ++cIdx;
                continue;
            }
            if (cKey == eKey) {
                ++eIdx;
                continue;
            }
            this.add(eqs.get(eIdx++));
        }
        while (eIdx < eqs.size()) {
            this.add(eqs.get(eIdx++));
        }
    }

    static AffineHullResult affineHull(Equations cons1, Equations cons2) {
        int largest;
        if (cons1.isEmpty() && cons2.isEmpty()) {
            return new AffineHullResult(cons1);
        }
        int max = -1;
        for (Equation l : cons1) {
            largest = l.getLargestVar();
            if (largest <= max) continue;
            max = largest;
        }
        for (Equation l : cons2) {
            largest = l.getLargestVar();
            if (largest <= max) continue;
            max = largest;
        }
        assert (max >= 0);
        int lambda = max + 1;
        Equations matrix = new Equations(cons1.size() + cons2.size());
        for (Equation l : cons1) {
            matrix.add(l.transformForAffineHullFirst(lambda));
        }
        for (Equation l : cons2) {
            matrix.add(l.transformForAffineHullSecond(lambda));
        }
        matrix.gauss(cons1.size());
        int out = 0;
        for (int i = 0; i < matrix.size(); ++i) {
            Equation row = ((Equation)matrix.get(i)).transformForAffineHullBack(lambda);
            if (row == null) continue;
            matrix.set(out++, row);
        }
        matrix.setSize(out);
        return new AffineHullResult(matrix, cons1, cons2);
    }

    private int substEqInEqs(int start, int end, Equation eq, boolean keysInRangeAllLargerThanEqVars) {
        int key = eq.getKey();
        if (key < 0) {
            return end;
        }
        BigInt negKeyCoeff = eq.getCoeff(key).negate();
        int i = start;
        while (i < end) {
            Equation cur = (Equation)this.get(i);
            BigInt coeff = cur.getCoeff(key);
            if (!coeff.isZero()) {
                if ((cur = Equation.mulAdd(negKeyCoeff, cur, coeff, eq)).getKey() < 0) {
                    assert (!keysInRangeAllLargerThanEqVars);
                    if (i == --end) continue;
                    this.set(i, this.get(end));
                    continue;
                }
                this.set(i, cur);
            }
            ++i;
        }
        if (!keysInRangeAllLargerThanEqVars) {
            Arrays.sort(this.elementData, start, end);
        }
        return end;
    }

    public Equation substEqsInEq(Equation eq) {
        return this.substEqsInEq(0, this.size(), eq);
    }

    private Equation substEqsInEq(int start, int end, Equation eq) {
        int lower = start;
        for (Equation.Term t : eq.terms) {
            int curVar = t.getId();
            int upper = end;
            while (lower < upper) {
                int middle = (lower + upper) / 2;
                if (((Equation)this.get(middle)).getKey() < curVar) {
                    lower = middle + 1;
                    continue;
                }
                upper = middle;
            }
            if (lower == end) break;
            Equation other = (Equation)this.get(lower);
            if (curVar != other.getKey()) continue;
            eq = Equation.mulAdd(other.getCoeff(curVar).negate(), eq, eq.getCoeff(curVar), other);
        }
        return eq;
    }

    public void gauss() {
        this.gauss(0);
    }

    private void gauss(int current) {
        while (current < this.size()) {
            Equation pivot = this.substEqsInEq(0, current, (Equation)this.get(current));
            int startSnd = current + 1;
            int endFst = this.substEqInEqs(0, current, pivot, true);
            assert (current == endFst);
            int endSnd = this.substEqInEqs(startSnd, this.size(), pivot, true);
            if (pivot.getKey() != -1) {
                this.set(endFst, pivot);
                for (int i = endFst; i > 0 && ((Equation)this.get(i)).getKey() < ((Equation)this.get(i - 1)).getKey(); --i) {
                    this.set(i - 1, this.set(i, this.get(i - 1)));
                }
                ++endFst;
            }
            if (startSnd > endFst) {
                int length = endSnd - startSnd;
                System.arraycopy(this.elementData, startSnd, this.elementData, endFst, length);
                this.setSize(endFst + length);
            }
            current = endFst;
        }
    }

    @Override
    public String toString() {
        String res = "";
        for (Equation eq : this) {
            if (eq == null) {
                res = res + "n/a\n";
                continue;
            }
            res = res + eq.toString() + "\n";
        }
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Equations)) {
            return false;
        }
        Equations other = (Equations)o;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((Equation)this.elementAt(i)).equals(other.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        for (Equation l : this) {
            hash += l.hashCode();
        }
        return hash;
    }

    static final class AffineHullResult {
        public Equations common;
        public Equations onlyFst;
        public Equations onlySnd;

        public AffineHullResult(Equations common) {
            this.common = common;
            this.onlySnd = this.onlyFst = new Equations(0);
        }

        private AffineHullResult(Equations common, Equations cons1, Equations cons2) {
            this.common = common;
            this.onlyFst = new Equations(common, cons1);
            this.onlySnd = new Equations(common, cons2);
        }

        public String toString() {
            return "common:\n" + this.common.toString() + "only in first:\n" + this.onlyFst.toString() + "only in second:\n" + this.onlySnd.toString();
        }
    }
}

