/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.interfaces;

import bindead.domainnetwork.channels.WarningMessage;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.environment.AnalysisEnvironment;
import javalx.data.Option;

public class AnalysisCtx {
    private final Option<ProgramPoint> location;
    private final AnalysisEnvironment environment;
    private final WarningsContainer warnings;

    public AnalysisCtx(AnalysisEnvironment environment) {
        this(ProgramPoint.nowhere, environment, new WarningsContainer());
    }

    public AnalysisCtx(Option<ProgramPoint> location, AnalysisEnvironment environment, WarningsContainer warnings) {
        this.location = location;
        this.environment = environment;
        this.warnings = warnings;
    }

    public static AnalysisCtx unknown() {
        return new AnalysisCtx(null);
    }

    public AnalysisCtx withoutLocation() {
        return new AnalysisCtx(ProgramPoint.nowhere, this.environment, this.warnings);
    }

    public Option<ProgramPoint> getLocation() {
        return this.location;
    }

    public AnalysisEnvironment getEnvironment() {
        return this.environment;
    }

    public WarningsContainer getWarningsChannel() {
        return this.warnings;
    }

    public void addWarning(WarningMessage warning) {
        this.warnings.addWarning(warning);
    }

    public String toString() {
        return "ctx:\n" + this.getLocation() + "\n" + this.getWarningsChannel();
    }
}

