/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.combinators;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.ListVarPair;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.combinators.FiniteChildOp;
import bindead.domainnetwork.interfaces.FiniteDomain;
import java.util.ArrayList;
import java.util.List;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;

public class FiniteSequence {
    private final List<FiniteChildOp> childTrans = new ArrayList<FiniteChildOp>(6);

    public void addAssignment(Finite.Lhs lhs, Finite.Rhs rhs) {
        this.childTrans.add(new FiniteChildOp.Assignment(FiniteFactory.getInstance().assign(lhs, rhs)));
    }

    public void addHardcopy(NumVar to, NumVar from) {
        this.childTrans.add(new FiniteChildOp.Hardcopy(to, from));
    }

    public void addBottom() {
        this.childTrans.clear();
        this.childTrans.add(new FiniteChildOp.Bottom());
    }

    public void addIntro(NumVar var) {
        this.childTrans.add(new FiniteChildOp.Introduction(var));
    }

    public void addIntro(NumVar var, BigInt value) {
        this.childTrans.add(new FiniteChildOp.Introduction(var, value));
    }

    public void addIntroZero(NumVar var) {
        this.childTrans.add(new FiniteChildOp.Introduction(var, Bound.ZERO));
    }

    public void addKill(NumVar var) {
        this.childTrans.add(new FiniteChildOp.Kill(var));
    }

    public <D extends FiniteDomain<D>> void addCopyAndPaste(VarSet variables, D otherState) {
        if (!variables.isEmpty()) {
            this.childTrans.add(new FiniteChildOp.CopyAndPaste<D>(variables, otherState));
        }
    }

    public void addSubst(NumVar from, NumVar to) {
        this.childTrans.add(new FiniteChildOp.Subst(from, to));
    }

    public void addTest(Finite.Test test) {
        this.childTrans.add(new FiniteChildOp.Test(test));
    }

    public int length() {
        return this.childTrans.size();
    }

    public boolean isEmpty() {
        return this.childTrans.isEmpty();
    }

    <D extends FiniteDomain<D>> D apply(D state) {
        for (FiniteChildOp action : this.childTrans) {
            state = action.apply(state);
        }
        this.childTrans.clear();
        return state;
    }

    public String toString() {
        String res = "[";
        String sep = "";
        for (FiniteChildOp ct : this.childTrans) {
            res = res + sep + ct.toString();
            sep = "; ";
        }
        return res + "]";
    }

    public void addDerefTarget(Finite.Rlin pointerNumVar, NumVar.AddrVar target, VarSet contents) {
        this.childTrans.add(new FiniteChildOp.DerefTarget(pointerNumVar, target, contents));
    }

    public void addAssumeEdgeNG(Finite.Rlin pointerNumVar, NumVar.AddrVar address) {
        this.childTrans.add(new FiniteChildOp.AssumeEdgeNG(pointerNumVar, address));
    }

    public void addExpandNG(ListVarPair numVars) {
        this.childTrans.add(new FiniteChildOp.ExpandNG(numVars));
    }

    public void addExpandNG(NumVar.AddrVar address, NumVar.AddrVar address2, ListVarPair numVars) {
        this.childTrans.add(new FiniteChildOp.ExpandNG(address, address2, numVars));
    }

    public void addConcretiseAndDisconnectNG(NumVar.AddrVar summary, VarSet concreteVars) {
        this.childTrans.add(new FiniteChildOp.ConcretizeAndDisconnectNG(summary, concreteVars));
    }

    public void addBendBackGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        this.childTrans.add(new FiniteChildOp.BendBackGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc));
    }

    public void addFoldNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, ListVarPair vps) {
        this.childTrans.add(new FiniteChildOp.FoldNG(summary, concrete, vps));
    }

    public void addFoldNG(ListVarPair vps) {
        this.childTrans.add(new FiniteChildOp.FoldNG(null, null, vps));
    }

    public void addBendGhostEdgesNG(NumVar.AddrVar summary, NumVar.AddrVar concrete, VarSet svs, VarSet cvs, VarSet pts, VarSet ptc) {
        this.childTrans.add(new FiniteChildOp.BendGhostEdgesNG(summary, concrete, svs, cvs, pts, ptc));
    }
}

