/*
 * Decompiled with CFR 0.152.
 */
package bindead.domainnetwork.channels;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.Linear;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import javalx.data.products.P2;
import javalx.persistentcollections.MultiMap;

public class SynthChannel {
    private SetOfEquations equations = SetOfEquations.empty();
    private MultiMap<Zeno.Test, Zeno.Test> implications = MultiMap.empty();

    public SynthChannel clone() {
        SynthChannel newChannel = new SynthChannel();
        newChannel.equations = this.equations;
        newChannel.implications = this.implications;
        return newChannel;
    }

    public boolean isEmpty() {
        return this.equations.isEmpty() && this.implications.isEmpty();
    }

    public void setEquations(SetOfEquations newEquations) {
        this.equations = newEquations;
    }

    public void addEquations(SetOfEquations newEquations) {
        this.equations = this.equations.union(newEquations);
    }

    public void addEquation(Linear eq) {
        this.equations = this.equations.add(eq.toEquality());
    }

    public SetOfEquations getEquations() {
        return this.equations;
    }

    public MultiMap<Zeno.Test, Zeno.Test> getImplications() {
        return this.implications;
    }

    public void setImplications(MultiMap<Zeno.Test, Zeno.Test> implications) {
        this.implications = implications;
    }

    public SynthChannel intersect(SynthChannel other) {
        SynthChannel merged = new SynthChannel();
        merged.equations = this.equations.intersect(other.equations);
        merged.implications = this.implications.intersection(other.implications);
        return merged;
    }

    public VarSet getVariables() {
        VarSet vars = VarSet.empty();
        for (Linear linear : this.equations) {
            vars = vars.union(linear.getVars());
        }
        for (P2 p2 : this.implications) {
            vars = vars.union(((Zeno.Test)p2._1()).getVars()).union(((Zeno.Test)p2._2()).getVars());
        }
        return vars;
    }

    public SynthChannel removeVariables(VarSet toRemove) {
        if (toRemove.isEmpty()) {
            return this;
        }
        SynthChannel res = new SynthChannel();
        for (Linear eq : this.equations) {
            if (eq.getVars().containsAny(toRemove)) continue;
            res.equations = res.equations.add(eq);
        }
        MultiMap<Zeno.Test, Zeno.Test> newImplications = this.implications;
        for (P2<Zeno.Test, Zeno.Test> p2 : this.implications) {
            if (!p2._1().getVars().containsAny(toRemove) && !p2._2().getVars().containsAny(toRemove)) continue;
            newImplications = newImplications.remove(p2._1(), p2._2());
        }
        res.setImplications(newImplications);
        return res;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Equations: ");
        builder.append(this.equations);
        builder.append("\n");
        builder.append("Implications: ");
        builder.append(this.implications);
        builder.append("\n");
        return builder.toString();
    }
}

