/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlToHtml {
    public static String renderAsHtml(String xmlCode) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String htmlString = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xmlCode)));
            InputStream schemaFile = XmlToHtml.class.getResourceAsStream("XmlToHtmlStylesheet.xsl");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(schemaFile);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new StringWriter());
            String cssFileName = "domaintable.css";
            String jsFileName = "tablefunctions.js";
            transformer.setParameter("cssFile", XmlToHtml.class.getResource(cssFileName).toExternalForm());
            transformer.setParameter("jsFile", XmlToHtml.class.getResource(jsFileName).toExternalForm());
            transformer.transform(source, result);
            htmlString = result.getWriter().toString();
            String literal = Pattern.quote("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            htmlString = htmlString.replaceFirst(literal, "");
        }
        catch (TransformerConfigurationException tce) {
            System.out.println("\n** Transformer Factory error");
            System.out.println("   " + tce.getMessage());
            tce.printStackTrace();
        }
        catch (TransformerException te) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + te.getMessage());
            te.printStackTrace();
        }
        catch (SAXException sxe) {
            System.out.println("\n** Transformation error");
            System.out.println("   " + sxe.getMessage());
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return htmlString;
    }
}

