/*
 * Decompiled with CFR 0.152.
 */
package bindead.debug;

import bindead.analyses.BinaryCodeCache;
import bindead.analyses.RReilCodeCache;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.analyses.algorithms.data.StateSpace;
import bindead.analyses.warnings.WarningsMap;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.WarningMessage;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.ProgramPoint;
import binparse.BinaryFileFormat;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.EnumSet;
import java.util.List;
import javalx.data.products.P2;
import javalx.fn.Predicate;
import javalx.mutablecollections.CollectionHelpers;
import rreil.disassembler.Instruction;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;

public class AnalysisDebugger {
    private final Multiset<ProgramPoint> iterationsCounter = HashMultiset.create();
    private final boolean DEBUGNATIVECODE;
    private final boolean DEBUGRREILCODE;
    private final boolean DEBUGWARNINGS;
    private final boolean DEBUGEVAL;
    private final boolean DEBUGSUMMARY;
    private final BinaryCodeCache binaryCode;
    private final RReilCodeCache rreilCode;
    private final boolean hasNativeCode;

    public AnalysisDebugger(BinaryCodeCache binaryCode, RReilCodeCache rreilCode) {
        this.DEBUGNATIVECODE = AnalysisProperties.INSTANCE.debugNativeCode.isTrue();
        this.DEBUGRREILCODE = AnalysisProperties.INSTANCE.debugRReilCode.isTrue();
        this.DEBUGWARNINGS = AnalysisProperties.INSTANCE.debugWarnings.isTrue();
        this.DEBUGEVAL = AnalysisProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGSUMMARY = AnalysisProperties.INSTANCE.debugSummary.isTrue();
        this.binaryCode = binaryCode;
        this.rreilCode = rreilCode;
        this.hasNativeCode = !binaryCode.getBinary().getFileFormat().equals((Object)BinaryFileFormat.RREIL);
    }

    public void printSeparator() {
        if (this.DEBUGEVAL) {
            System.out.println(StringHelpers.repeatString("\u00af", 100));
        }
    }

    public void printInstruction(ProgramCtx programPoint) {
        this.iterationsCounter.add(programPoint);
        if (this.DEBUGEVAL) {
            CallString callString = programPoint.getCallString();
            RReilAddr address = programPoint.getAddress();
            if (this.hasNativeCode && address.offset() == 0) {
                Instruction nativeInstruction = this.binaryCode.getInstruction(address.base());
                String parentFunctionName = this.binaryCode.getEnclosingFunction(nativeInstruction);
                String instructionString = parentFunctionName + ":   " + this.binaryCode.toRichInstructionString(nativeInstruction);
                StringBuilder builder = new StringBuilder();
                builder.append(StringHelpers.repeatString("_", instructionString.length()));
                builder.append("\n");
                builder.append(instructionString);
                builder.append("\n");
                builder.append(StringHelpers.repeatString("\u203e", instructionString.length()));
                System.out.println(builder.toString());
            }
            StringBuilder builder = new StringBuilder();
            RReil instruction = this.rreilCode.getInstruction(address);
            String label = this.rreilCode.getLabel(instruction.getRReilAddress());
            if (!this.hasNativeCode && !label.isEmpty()) {
                builder.append(StringHelpers.repeatString("_", label.length()));
                builder.append("\n");
                builder.append(label + ":");
                builder.append("\n");
                builder.append(StringHelpers.repeatString("\u203e", label.length()));
                builder.append("\n");
            }
            String instructionString = this.rreilCode.toRichInstructionString(instruction);
            builder.append(String.format("#%-4d", this.iterationsCounter.count(programPoint)));
            builder.append(String.format("%s %s", callString.pretty(5), address));
            builder.append(String.format(" | %-40s", instructionString));
            System.out.print(builder.toString());
        }
    }

    public void printSuccessors(List<P2<Flows.Successor<?>, Boolean>> successors) {
        if (this.DEBUGEVAL) {
            StringBuilder builder = new StringBuilder();
            if (successors.isEmpty()) {
                builder.append(String.format("%-10s", "NO SUCCESSORS"));
            } else {
                List inWorkqueue = CollectionHelpers.filter(successors, new Predicate<P2<Flows.Successor<?>, Boolean>>(){

                    @Override
                    public Boolean apply(P2<Flows.Successor<?>, Boolean> tuple) {
                        return tuple._2();
                    }
                });
                List notInWorkqueue = CollectionHelpers.filter(successors, new Predicate<P2<Flows.Successor<?>, Boolean>>(){

                    @Override
                    public Boolean apply(P2<Flows.Successor<?>, Boolean> tuple) {
                        return tuple._2() == false;
                    }
                });
                if (!inWorkqueue.isEmpty()) {
                    builder.append(String.format("%-10s", this.toRichSuccessorsString(CollectionHelpers.split(inWorkqueue)._1())));
                }
                if (!notInWorkqueue.isEmpty()) {
                    builder.append(String.format("   STABLE: %-25s", this.toRichSuccessorsString(CollectionHelpers.split(notInWorkqueue)._1())));
                }
            }
            System.out.println(builder.toString());
        }
    }

    private String toRichSuccessorsString(List<Flows.Successor<?>> successors) {
        StringBuilder builder = new StringBuilder();
        EnumSet<Flows.FlowType> branchTypes = EnumSet.of(Flows.FlowType.Call, Flows.FlowType.Return, Flows.FlowType.Jump, Flows.FlowType.Next);
        for (Flows.Successor<?> successor : successors) {
            RReilAddr target;
            String targetLabel;
            builder.append("  \u00bb ");
            builder.append(successor);
            if (!branchTypes.contains((Object)successor.getType()) || (targetLabel = this.rreilCode.getLabel(target = successor.getAddress())).isEmpty()) continue;
            builder.append(" <" + targetLabel + ">");
        }
        return builder.toString();
    }

    public void printWarnings(ProgramCtx programPoint, WarningsMap warningsMap) {
        if (this.DEBUGWARNINGS) {
            WarningsContainer warnings = warningsMap.get(programPoint);
            if (warnings.isEmpty()) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (WarningMessage message : warnings) {
                builder.append(message.detailedMessage());
                builder.append("\n");
            }
            System.out.println(StringHelpers.indentMultiline("  Warning: ", builder.toString()));
        }
    }

    public void printSummary(StateSpace<?> states, WarningsMap warnings) {
        this.printCode();
        if (this.DEBUGSUMMARY) {
            int totalSteps = 0;
            int maxIterations = 0;
            for (ProgramPoint programPoint : this.iterationsCounter.elementSet()) {
                int iterationsForProgramPoint = this.iterationsCounter.count(programPoint);
                totalSteps += iterationsForProgramPoint;
                maxIterations = Math.max(maxIterations, iterationsForProgramPoint);
            }
            Multiset<ProgramPoint> wideningPoints = states.getWideningPoints();
            StringBuilder wideningPointsListBuilder = new StringBuilder();
            wideningPointsListBuilder.append("{");
            for (ProgramPoint programPoint : wideningPoints.elementSet()) {
                int timesWidened = wideningPoints.count(programPoint);
                wideningPointsListBuilder.append(timesWidened + "*");
                wideningPointsListBuilder.append(programPoint);
                wideningPointsListBuilder.append(", ");
            }
            if (!wideningPoints.isEmpty()) {
                wideningPointsListBuilder.setLength(wideningPointsListBuilder.length() - 2);
            }
            wideningPointsListBuilder.append("}");
            System.out.println();
            if (this.hasNativeCode) {
                String architecture = this.binaryCode.getBinary().getArchitectureName();
                System.out.println("Analyzed " + architecture + " code: " + this.binaryCode.instructionsCount() + " instructions");
            }
            System.out.println("Analyzed RREIL code: " + this.rreilCode.instructionsCount() + " instructions");
            if (this.rreilCode.instructionsCount() != 0) {
                System.out.println("Analysis steps: " + totalSteps + "  \u2248" + totalSteps / this.rreilCode.instructionsCount() + " iterations/instruction");
            }
            System.out.println("Max iterations to fixpoint: " + maxIterations);
            System.out.println("Widening points: " + wideningPoints.elementSet().size() + " @ " + wideningPointsListBuilder);
            System.out.println("Warnings: " + warnings.totalNumberOfWarnings());
            System.out.println();
        }
    }

    public void printCode() {
        if (this.DEBUGRREILCODE) {
            System.out.println();
            System.out.println("Disassembled RREIL code (" + this.rreilCode.instructionsCount() + " instructions):");
            if (this.hasNativeCode) {
                System.out.println(this.rreilCode.toDisassemblyString());
            } else {
                System.out.println(this.rreilCode);
            }
        }
        if (this.DEBUGNATIVECODE && this.hasNativeCode) {
            System.out.println();
            System.out.println(StringHelpers.repeatString("\u00af", 100));
            String architecture = this.binaryCode.getBinary().getArchitectureName();
            System.out.println("Disassembled native (" + architecture + ") code (" + this.binaryCode.instructionsCount() + " instructions):");
            System.out.println(this.binaryCode.toDisassemblyString());
            System.out.println(StringHelpers.repeatString("\u00af", 100));
        }
    }
}

