/*
 * Decompiled with CFR 0.152.
 */
package bindead.data;

import java.util.Map;
import java.util.TreeMap;
import rreil.lang.MemVar;

public class NumVar
implements Comparable<NumVar> {
    private static StampGen stamps = new StampGen(0);
    private static Map<NumVar, String> regionNames = new TreeMap<NumVar, String>();
    private static Map<String, NumVar> singletonsReverse = new TreeMap<String, NumVar>();
    private static boolean printMemVarOnly = false;
    private static boolean printNumVarOnly = false;
    private final int stamp;

    NumVar(int id) {
        assert (stamps.peek() > id);
        this.stamp = id;
    }

    private NumVar() {
        this.stamp = stamps.next();
    }

    private NumVar(String name) {
        this();
        if (name != null && !name.isEmpty()) {
            regionNames.put(this, name);
        }
    }

    public static void printMemVarOnly(boolean enabled) {
        printMemVarOnly = enabled;
    }

    public static void printNumVarOnly(boolean enabled) {
        printNumVarOnly = enabled;
    }

    protected String typePrefix() {
        return "v";
    }

    public static NumVar getSingleton(String name) {
        NumVar variable = singletonsReverse.get(name);
        if (variable != null) {
            return variable;
        }
        variable = NumVar.fresh(name);
        singletonsReverse.put(name, variable);
        return variable;
    }

    public static AddrVar getSingletonAddress(String name) {
        NumVar variable = singletonsReverse.get(name);
        if (variable != null) {
            assert (variable instanceof AddrVar);
            return (AddrVar)variable;
        }
        variable = NumVar.freshAddress(name);
        singletonsReverse.put(name, variable);
        return (AddrVar)variable;
    }

    public static NumVar fresh() {
        return new NumVar();
    }

    public static NumVar fresh(String name) {
        return new NumVar(name);
    }

    public static AddrVar freshAddress() {
        return new AddrVar();
    }

    public static AddrVar freshAddress(String name) {
        return new AddrVar(name);
    }

    public static FlagVar freshFlag() {
        return new FlagVar();
    }

    public static FlagVar freshFlag(String name) {
        return new FlagVar(name);
    }

    public String getName() {
        String region = this.getRegionName();
        String numId = this.typePrefix() + this.getStamp();
        if (region != null) {
            return region + "(" + numId + ")";
        }
        return numId;
    }

    public String getRegionName() {
        return regionNames.get(this);
    }

    public void setRegionName(MemVar region, int offset) {
        String regionName = region.getName();
        String offsetUnit = "bits";
        if (offset != 0 && offset % 8 == 0) {
            offsetUnit = "";
            offset /= 8;
        }
        if (offset != 0) {
            regionName = "[" + regionName + (offset > 0 ? "+" : "") + offset + offsetUnit + "]";
        }
        regionNames.put(this, regionName);
    }

    public boolean isAddress() {
        return false;
    }

    public boolean isFlag() {
        return false;
    }

    public int getStamp() {
        return this.stamp;
    }

    @Override
    public int compareTo(NumVar other) {
        return Integer.signum(this.stamp - other.stamp);
    }

    @Deprecated
    public boolean equals(Object other) {
        if (other instanceof NumVar) {
            return this.equalTo((NumVar)other);
        }
        return false;
    }

    public boolean equalTo(NumVar other) {
        return this.stamp == other.stamp;
    }

    public int hashCode() {
        return this.stamp;
    }

    public String toString() {
        String region = this.getRegionName();
        String numId = this.typePrefix() + this.getStamp();
        if (printNumVarOnly) {
            return numId;
        }
        if (region != null) {
            if (printMemVarOnly) {
                return region;
            }
            return region + "(" + numId + ")";
        }
        return numId;
    }

    public static void reset() {
        stamps = new StampGen();
        regionNames = new TreeMap<NumVar, String>();
        singletonsReverse = new TreeMap<String, NumVar>();
    }

    private static final class StampGen {
        private int state;

        StampGen(int start) {
            this.state = start;
        }

        public StampGen() {
            this(0);
        }

        public int peek() {
            return this.state;
        }

        public int next() {
            ++this.state;
            if (this.state == -1) {
                throw new IllegalStateException("Stamp generator overflow occured.");
            }
            return this.state;
        }
    }

    public static class FlagVar
    extends NumVar {
        protected FlagVar() {
        }

        private FlagVar(String name) {
            super(name);
        }

        @Override
        protected String typePrefix() {
            return "f";
        }

        @Override
        public boolean isFlag() {
            return true;
        }
    }

    public static class AddrVar
    extends NumVar {
        protected AddrVar() {
        }

        private AddrVar(String name) {
            super(name);
        }

        @Override
        protected String typePrefix() {
            return "a";
        }

        @Override
        public final boolean isAddress() {
            return true;
        }
    }
}

