/*
 * Decompiled with CFR 0.152.
 */
package bindead.data;

import java.util.Iterator;
import javalx.data.Option;
import javalx.persistentcollections.AVLSet;
import rreil.lang.MemVar;

public final class MemVarSet
implements Iterable<MemVar> {
    private static MemVarSet EMPTY = new MemVarSet(AVLSet.empty());
    private final AVLSet<MemVar> vars;

    private MemVarSet(AVLSet<MemVar> s) {
        this.vars = s;
    }

    public MemVarSet(Iterable<MemVar> regions) {
        this(MemVarSet.collect(regions));
    }

    private static AVLSet<MemVar> collect(Iterable<MemVar> regions) {
        AVLSet<MemVar> vars = AVLSet.empty();
        for (MemVar mv : regions) {
            vars = vars.add(mv);
        }
        return vars;
    }

    public static MemVarSet empty() {
        return EMPTY;
    }

    public static MemVarSet of(MemVar ... vars) {
        MemVarSet result = MemVarSet.empty();
        for (MemVar var : vars) {
            result = result.insert(var);
        }
        return result;
    }

    public static MemVarSet from(Iterable<MemVar> vars) {
        MemVarSet result = MemVarSet.empty();
        for (MemVar var : vars) {
            result = result.insert(var);
        }
        return result;
    }

    public MemVarSet insertAll(Iterable<MemVar> vars) {
        MemVarSet result = this;
        for (MemVar var : vars) {
            result = result.insert(var);
        }
        return result;
    }

    public MemVarSet insert(MemVar var) {
        return new MemVarSet(this.vars.add(var));
    }

    public int size() {
        return this.vars.size();
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    public Iterator<MemVar> iterator() {
        return this.vars.iterator();
    }

    public boolean contains(MemVar var) {
        return this.vars.contains(var);
    }

    public MemVarSet difference(MemVarSet other) {
        return new MemVarSet(this.vars.difference(other.vars));
    }

    public MemVarSet intersection(MemVarSet other) {
        return new MemVarSet(this.vars.intersection(other.vars));
    }

    public Option<MemVar> getMin() {
        return this.vars.getMin();
    }

    public String toString() {
        return this.vars.toString();
    }

    public MemVarSet remove(MemVar memId) {
        return new MemVarSet(this.vars.remove(memId));
    }

    public boolean containsTheSameAs(MemVarSet other) {
        return this.vars.equals(other.vars);
    }
}

