/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems.natives;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class RawDefinition {
    private final ByteBuffer data;

    protected RawDefinition(ByteBuffer data) {
        this.data = data;
    }

    public ByteBufferBackedInputStream wrap() {
        return new ByteBufferBackedInputStream(this.data);
    }

    public ByteBuffer getData() {
        return this.data;
    }

    private static class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        private ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

