/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.systems;

import bindead.analyses.systems.GenericSystemModel;
import bindead.analyses.systems.INativeHandler;
import bindead.analyses.systems.SystemModel;
import bindead.analyses.systems.natives.DefaultDefinitionProvider;
import bindead.analyses.systems.natives.DefinitionId;
import bindead.analyses.systems.natives.FileSystemLoader;
import bindead.analyses.systems.natives.FunctionDefinition;
import bindead.analyses.systems.natives.IDefinitionProvider;
import bindead.analyses.systems.natives.TemplateArguments;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.abi.ABI;
import bindead.environment.abi.X32SysVAbi;
import bindead.environment.abi.X64SysVAbi;
import binparse.Binary;
import binparse.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Range;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RhsFactory;

public class LinuxX86Model
extends GenericSystemModel {
    private static final Map<Integer, DefinitionId> SYSCALL_TABLE = new HashMap<Integer, DefinitionId>();
    private static final Byte _0x80;
    private static final String[] CLIB_DEF_PATH;
    private static final String[] SYSCALL_PATH;
    private final Binary binary;
    private final IDefinitionProvider syscallDefProvider;
    private final TemplateArguments syscallArgs;
    private final IDefinitionProvider clibDefProvider;
    private static final String[] IN_PARAM_NAMES;

    protected LinuxX86Model(ABI abi, Binary binary) {
        super(SystemModel.ESystemType.LINUX, abi);
        this.binary = binary;
        this.syscallArgs = new TemplateArguments(abi.getSyscallInputRegisterNames(), Arrays.asList(abi.getSyscallReturnRegisterName()), this.getPlatform().defaultArchitectureSize());
        this.syscallDefProvider = new DefaultDefinitionProvider(new FileSystemLoader(SYSCALL_PATH)).cached();
        this.registerNativeHandler("sysenter", new SysenterHandler());
        this.registerNativeHandler("syscall", new SyscallHandler());
        this.registerNativeHandler("int", new IntHandler());
        this.clibDefProvider = new DefaultDefinitionProvider(new FileSystemLoader(CLIB_DEF_PATH)).cached();
        this.addClibHandler("time", X64SysVAbi.EParamType.INTEGER, X64SysVAbi.EParamType.INTEGER);
        this.addClibHandler("syscall", X64SysVAbi.EParamType.INTEGER, X64SysVAbi.EParamType.INTEGER);
    }

    private void addClibHandler(String symbolName, X64SysVAbi.EParamType retType, X64SysVAbi.EParamType ... paramTypes) {
        Option<Symbol> optSymbol = this.binary.getSymbol(symbolName);
        if (optSymbol.isNone()) {
            return;
        }
        Symbol symbol = optSymbol.get();
        RReilAddr callAddr = RReilAddr.valueOf(symbol.getAddress());
        if (this.abi instanceof X64SysVAbi) {
            X64SysVAbi x64Abi = (X64SysVAbi)this.abi;
            X64SysVAbi.FunctionSignature signature = new X64SysVAbi.FunctionSignature(retType, paramTypes);
            this.registerFunctionHandler(callAddr, new X64ClibHandler(callAddr, symbol, this.clibDefProvider, x64Abi, signature));
        } else {
            X32SysVAbi x32Abi = (X32SysVAbi)this.abi;
            this.registerFunctionHandler(callAddr, new X32ClibHandler(callAddr, symbol, this.clibDefProvider, x32Abi, paramTypes.length));
        }
    }

    private <D extends RootDomain<D>> List<Option<FunctionDefinition>> handleSyscall(RReil.Native stmt, D state, ProgramPoint programPoint) {
        Range sysnrRange = state.queryRange(this.getPlatform().getRegisterAsVariable(this.abi.getSyscallNrRegisterName()));
        LinkedList<Option<FunctionDefinition>> possibleSyscalls = new LinkedList<Option<FunctionDefinition>>();
        if (!sysnrRange.isFinite()) {
            return this.defaultReaction(stmt, state, programPoint);
        }
        for (BigInt sysnr : sysnrRange) {
            DefinitionId id = SYSCALL_TABLE.get(sysnr.intValue());
            if (id != null) {
                possibleSyscalls.add(this.syscallDefProvider.getNativeFunction(id, this.syscallArgs));
                continue;
            }
            possibleSyscalls.add(Option.none());
        }
        return possibleSyscalls;
    }

    static {
        SYSCALL_TABLE.put(13, DefinitionId.valueOf("sys_time"));
        _0x80 = new Integer(128).byteValue();
        CLIB_DEF_PATH = new String[]{"natives/linux/generic"};
        SYSCALL_PATH = new String[]{"natives/linux/syscalls"};
        IN_PARAM_NAMES = new String[]{"param0", "param1", "param2", "param3", "param4", "param5", "param6"};
    }

    private static class X64ClibHandler
    extends GenericSystemModel.ANativeFunctionHandler {
        private static final RReilFactory rreilFactory = new RReilFactory();
        private static final int REGISTER_SIZE = 64;
        private final X64SysVAbi x64Abi;
        private final X64SysVAbi.FunctionSignature funcSignature;

        public X64ClibHandler(RReilAddr addr, Symbol symbol, IDefinitionProvider defProvider, X64SysVAbi amd64Abi, X64SysVAbi.FunctionSignature funcSignature) {
            super(addr, symbol, defProvider);
            this.x64Abi = amd64Abi;
            this.funcSignature = funcSignature;
        }

        @Override
        public <D extends RootDomain<D>> Option<FunctionDefinition> handleNativeFunction(RReilAddr addr, RReil stmt, D state) {
            X64SysVAbi.FunctionParameterAllocations funcAllocations = this.x64Abi.getParameterAllocationsFor(state, this.funcSignature);
            ArrayList<String> inputIds = new ArrayList<String>();
            int paramIndex = 0;
            for (P2<Rhs.Rvar, X64SysVAbi.EParamType> param : funcAllocations.getParams()) {
                String paramName;
                if (param._2() == X64SysVAbi.EParamType.MEMORY) {
                    paramName = IN_PARAM_NAMES[paramIndex];
                    ++paramIndex;
                } else {
                    paramName = param._1().getRegionId().getName();
                }
                inputIds.add(paramName);
            }
            String outputId = funcAllocations.getRetVar()._1().getRegionId().getName();
            TemplateArguments args = new TemplateArguments(inputIds, Arrays.asList(outputId), 64);
            Option<FunctionDefinition> optFunction = this.defProvider.getNativeFunction(this.defId, args);
            if (optFunction.isNone()) {
                return optFunction;
            }
            FunctionDefinition function = optFunction.get();
            ArrayList<Lhs> localVariables = new ArrayList<Lhs>();
            ArrayList<RReil> prolog = new ArrayList<RReil>();
            int paramIndex2 = 0;
            for (P2<Rhs.Rvar, X64SysVAbi.EParamType> param : funcAllocations.getParams()) {
                if (param._2() != X64SysVAbi.EParamType.MEMORY) continue;
                String name = (String)inputIds.get(paramIndex2);
                Lhs newVar = new Lhs(param._1().getSize(), 0, MemVar.fresh(name));
                prolog.add(rreilFactory.assign(null, newVar, param._1()));
                localVariables.add(newVar);
                ++paramIndex2;
            }
            function = function.prepend(prolog);
            ArrayList<RReil> epilog = new ArrayList<RReil>();
            Rhs.Rvar rhs = RhsFactory.getInstance().variable(64, 0, MemVar.getVarOrFresh("rdi"));
            Lhs lhs = new Lhs(64, 0, MemVar.getVarOrFresh("rax"));
            epilog.add(rreilFactory.assign(null, lhs, rhs));
            function = function.append(epilog);
            return Option.some(function);
        }
    }

    private static class X32ClibHandler
    extends GenericSystemModel.ANativeFunctionHandler {
        private static final RReilFactory rreilFactory = new RReilFactory();
        private static final int REGISTER_SIZE = 32;
        private final X32SysVAbi x32Abi;
        private final int paramsSize;

        public X32ClibHandler(RReilAddr addr, Symbol symbol, IDefinitionProvider defProvider, X32SysVAbi x32Abi, int paramsSize) {
            super(addr, symbol, defProvider);
            this.x32Abi = x32Abi;
            this.paramsSize = paramsSize;
        }

        @Override
        public <D extends RootDomain<D>> Option<FunctionDefinition> handleNativeFunction(RReilAddr addr, RReil stmt, D state) {
            ArrayList<String> inputIds = new ArrayList<String>();
            for (int i = 0; i < this.paramsSize; ++i) {
                inputIds.add(IN_PARAM_NAMES[i]);
            }
            String outputId = "eax";
            TemplateArguments args = new TemplateArguments(inputIds, Arrays.asList(outputId), 32);
            Option<FunctionDefinition> optFunction = this.defProvider.getNativeFunction(this.defId, args);
            if (optFunction.isNone()) {
                return optFunction;
            }
            FunctionDefinition function = optFunction.get();
            ArrayList<Lhs> localVariables = new ArrayList<Lhs>();
            ArrayList<RReil> prolog = new ArrayList<RReil>();
            for (int i = 0; i < this.paramsSize; ++i) {
                String name = IN_PARAM_NAMES[i];
                Lhs newVar = new Lhs(32, 0, MemVar.fresh(name));
                Rhs.Rvar rhs = this.x32Abi.getFunctionParameterAllocation(i, state);
                prolog.add(rreilFactory.assign(null, newVar, rhs));
                localVariables.add(newVar);
            }
            function = function.prepend(prolog);
            return Option.some(function);
        }
    }

    private class SyscallHandler
    extends SysenterHandler {
        private SyscallHandler() {
        }

        @Override
        public <D extends RootDomain<D>> List<Option<FunctionDefinition>> handleNative(RReil.Native stmt, D state, ProgramPoint programPoint) {
            return LinuxX86Model.this.handleSyscall(stmt, state, programPoint);
        }
    }

    private class SysenterHandler
    implements INativeHandler {
        private SysenterHandler() {
        }

        @Override
        public <D extends RootDomain<D>> List<Option<FunctionDefinition>> handleNative(RReil.Native stmt, D state, ProgramPoint programPoint) {
            return LinuxX86Model.this.handleSyscall(stmt, state, programPoint);
        }
    }

    private class IntHandler
    implements INativeHandler {
        private IntHandler() {
        }

        @Override
        public <D extends RootDomain<D>> List<Option<FunctionDefinition>> handleNative(RReil.Native stmt, D state, ProgramPoint programPoint) {
            Rhs.Rlit op0Val = stmt.getOpnd();
            if (op0Val.getValue().getValue().byteValue() == _0x80.byteValue()) {
                return LinuxX86Model.this.handleSyscall(stmt, state, programPoint);
            }
            return LinuxX86Model.this.defaultReaction(stmt, state, programPoint);
        }
    }
}

