/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.warnings.WarningsMap;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.AnalysisCtx;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javalx.data.Option;
import rreil.lang.RReilAddr;

public class StateSpace<D extends RootDomain<D>> {
    private final boolean DEBUGBINARIES;
    private final boolean DEBUGSUBSETOREQUAL;
    private final boolean DEBUGWIDENING;
    private final Map<ProgramPoint, D> states;
    private final Multimap<RReilAddr, ProgramPoint> stateSpaceForAddress;
    private final Set<ProgramPoint> junctionPoints;
    private final Multimap<ProgramPoint, ProgramPoint> incomingEdges;
    private final WarningsMap warningsMap;
    private final Multiset<ProgramPoint> iterationsCounter;
    private final Multiset<ProgramPoint> wideningPoints;

    public StateSpace() {
        this.DEBUGBINARIES = AnalysisProperties.INSTANCE.debugBinaryOperations.isTrue();
        this.DEBUGSUBSETOREQUAL = AnalysisProperties.INSTANCE.debugSubsetOrEqual.isTrue();
        this.DEBUGWIDENING = AnalysisProperties.INSTANCE.debugWidening.isTrue();
        this.states = new HashMap<ProgramPoint, D>();
        this.stateSpaceForAddress = HashMultimap.create();
        this.junctionPoints = new HashSet<ProgramPoint>();
        this.incomingEdges = HashMultimap.create();
        this.warningsMap = new WarningsMap();
        this.iterationsCounter = HashMultiset.create();
        this.wideningPoints = HashMultiset.create();
    }

    public void setInitial(ProgramPoint point, D state) {
        assert (this.get(point).isNone());
        this.putState(point, state);
    }

    private void putState(ProgramPoint point, D state) {
        AnalysisCtx newCtx = new AnalysisCtx(Option.some(point), state.getContext().getEnvironment(), new WarningsContainer());
        state = (RootDomain)state.setContext(newCtx);
        this.states.put(point, state);
        this.iterationsCounter.add(point);
        this.stateSpaceForAddress.put(point.getAddress(), point);
    }

    public boolean update(ProgramPoint from, Flows.FlowType flow, ProgramPoint to, D newState, boolean useWidening) {
        Object finalState;
        boolean isWideningPoint;
        this.updateTransitionsTopology(from, to, flow);
        RootDomain oldState = (RootDomain)this.get(to).getOrNull();
        boolean bl = isWideningPoint = useWidening && StateSpace.isBackedge(from, to);
        if (this.printDebugOutput(isWideningPoint)) {
            this.debugOldAndNewState(to, oldState, newState);
        }
        if (isWideningPoint) {
            this.wideningPoints.add(to);
        }
        if (oldState == null) {
            finalState = newState;
            if (this.printDebugOutput(isWideningPoint)) {
                System.out.println("  old state overwritten! Was bottom.");
            }
        } else if (!this.isJunction(to) && !isWideningPoint) {
            finalState = newState;
            if (this.printDebugOutput(isWideningPoint)) {
                System.out.println("  old state overwritten! Was not a junction or widening point.");
            }
        } else {
            if (this.printDebugOutput(isWideningPoint)) {
                String action = isWideningPoint ? "widened" : "joined";
                System.out.println("  states " + action + ".");
            }
            finalState = (RootDomain)oldState.addToState(newState, isWideningPoint);
            if (isWideningPoint && finalState != null) {
                assert (oldState.subsetOrEqual(finalState)) : "Widened state is smaller than its arguments!";
                assert (newState.subsetOrEqual(finalState)) : "Widened state is smaller than its arguments!";
            }
            if (isWideningPoint && this.printDebugOutput(isWideningPoint)) {
                if (finalState == null) {
                    System.out.println("new state was smaller or equal to the old state.");
                } else {
                    System.out.println("widened state:\n" + finalState);
                }
            }
        }
        if (finalState == null) {
            return false;
        }
        this.debugWideningCounter(to, isWideningPoint);
        this.putWarnings(from, newState.getContext().getWarningsChannel());
        this.putState(to, finalState);
        return true;
    }

    private void debugWideningCounter(ProgramPoint point, boolean isWideningPoint) {
        if (isWideningPoint && this.DEBUGWIDENING) {
            int timesWidenened = this.wideningPoints.count(point);
            System.out.println("ANALYSIS (widening #" + timesWidenened + ")@" + point + ":");
        }
    }

    private boolean printDebugOutput(boolean isWideningPoint) {
        return this.DEBUGBINARIES || this.DEBUGSUBSETOREQUAL || this.DEBUGWIDENING && isWideningPoint;
    }

    private void debugOldAndNewState(ProgramPoint at, D oldState, D newState) {
        System.out.println();
        System.out.println("ANALYSIS (updating state@" + at + "):");
        String oldStateAsText = oldState != null ? oldState.toString() : "_|_";
        System.out.println(StringHelpers.indentMultiline("  old-state: ", oldStateAsText) + "\n");
        System.out.println(StringHelpers.indentMultiline("  new-state: ", newState.toString()) + "\n");
    }

    private void updateTransitionsTopology(ProgramPoint pred, ProgramPoint succ, Flows.FlowType flow) {
        this.incomingEdges.put(succ, pred);
        switch (flow) {
            case Call: 
            case Jump: 
            case Return: {
                this.junctionPoints.add(succ);
                break;
            }
        }
    }

    private boolean isJunction(ProgramPoint point) {
        return this.incomingEdges.get(point).size() > 1 || this.junctionPoints.contains(point);
    }

    private static boolean isBackedge(ProgramPoint from, ProgramPoint to) {
        return from.getAddress().compareTo(to.getAddress()) > 0;
    }

    public Option<D> get(ProgramPoint point) {
        return Option.fromNullable(this.states.get(point));
    }

    public Set<ProgramPoint> get(RReilAddr address) {
        return (Set)this.stateSpaceForAddress.get(address);
    }

    public WarningsMap getWarnings() {
        return this.warningsMap;
    }

    public void putWarnings(ProgramPoint point, WarningsContainer warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        this.warningsMap.put(point, this.iterationsCounter.count(point), warnings);
    }

    public Multiset<ProgramPoint> getWideningPoints() {
        return this.wideningPoints;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Size: ");
        builder.append(this.states.entrySet());
        builder.append("\n");
        for (Map.Entry<ProgramPoint, D> entry : this.states.entrySet()) {
            ProgramPoint point = entry.getKey();
            builder.append(point);
            builder.append("\n");
        }
        return builder.toString();
    }
}

