/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.domainnetwork.interfaces.RootDomain;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import rreil.lang.RReilAddr;

public class Flows<D extends RootDomain<D>>
implements Iterable<Successor<D>> {
    private final List<Successor<D>> successors;
    private final Comparator<Successor<D>> smallerAddressesFirstComparator = new Comparator<Successor<D>>(){

        @Override
        public int compare(Successor<D> o1, Successor<D> o2) {
            if (o1.getAddress() == null && o2.getAddress() == null) {
                return 0;
            }
            if (o1.getAddress() == null) {
                return 1;
            }
            if (o2.getAddress() == null) {
                return -1;
            }
            return o1.getAddress().compareTo(o2.getAddress());
        }
    };

    public Flows() {
        this.successors = new ArrayList<Successor<D>>();
    }

    public static <D extends RootDomain<D>> Flows<D> next(RReilAddr address, D state) {
        return new Flows<D>().addNext(address, state);
    }

    public static <D extends RootDomain<D>> Flows<D> halt(D state) {
        return new Flows<D>().addHalt(state);
    }

    public static <D extends RootDomain<D>> Flows<D> error(D state) {
        return new Flows<D>().addError(state);
    }

    public Flows<D> addNext(RReilAddr address, D state) {
        this.successors.add(new Successor<D>(FlowType.Next, address, state));
        return this;
    }

    public Flows<D> addJump(RReilAddr address, D state) {
        this.successors.add(new Successor<D>(FlowType.Jump, address, state));
        return this;
    }

    public Flows<D> addCall(RReilAddr address, D state) {
        this.successors.add(new Successor<D>(FlowType.Call, address, state));
        return this;
    }

    public Flows<D> addReturn(RReilAddr address, D state) {
        this.successors.add(new Successor<D>(FlowType.Return, address, state));
        return this;
    }

    public Flows<D> addHalt(D state) {
        this.successors.add(new Successor<D>(FlowType.Halt, null, state));
        return this;
    }

    public Flows<D> addError(D state) {
        this.successors.add(new Successor<D>(FlowType.Error, null, state));
        return this;
    }

    public boolean isEmpty() {
        return this.successors.isEmpty();
    }

    @Override
    public Iterator<Successor<D>> iterator() {
        return this.successors.iterator();
    }

    public String toString() {
        return this.successors.toString();
    }

    public static class Successor<D extends RootDomain<D>> {
        final FlowType type;
        final RReilAddr address;
        final D state;

        public Successor(FlowType type, RReilAddr address, D state) {
            this.type = type;
            this.address = address;
            this.state = state;
        }

        public FlowType getType() {
            return this.type;
        }

        public RReilAddr getAddress() {
            return this.address;
        }

        public D getState() {
            return this.state;
        }

        public String toString() {
            if (this.address != null) {
                return (Object)((Object)this.type) + "(" + this.address.toShortString() + ")";
            }
            return this.type.toString();
        }
    }

    public static enum FlowType {
        Jump,
        Next,
        Call,
        Return,
        Halt,
        Error;

    }
}

