/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.exceptions.DomainStateException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import rreil.lang.RReilAddr;

public class CallString
implements Cloneable {
    private static final int defaultCallStringLength = 50;
    private final int maxSignificantLength;
    private final LinkedList<Transition> backLogString = new LinkedList();
    private final LinkedList<Transition> significantString = new LinkedList();

    private static CallString withMaxSignificantLength(int k) {
        return new CallString(k);
    }

    public static CallString root(int k) {
        return CallString.withMaxSignificantLength(k);
    }

    public static CallString root() {
        return CallString.withMaxSignificantLength(50);
    }

    private CallString(int maxSignificantLength) {
        if (maxSignificantLength < 0) {
            maxSignificantLength = 0;
        }
        this.maxSignificantLength = maxSignificantLength;
    }

    protected CallString clone() {
        return new CallString(this);
    }

    private CallString(CallString other) {
        this.maxSignificantLength = other.maxSignificantLength;
        this.significantString.addAll(other.significantString);
        this.backLogString.addAll(other.backLogString);
    }

    public CallString pop(Transition transition) {
        Transition lastTransition;
        CallString newCallString = this.clone();
        assert (newCallString.size() > 0);
        if (this.maxSignificantLength == 0) {
            lastTransition = newCallString.backLogString.removeLast();
        } else if (newCallString.backLogString.size() > 0) {
            assert (newCallString.significantString.size() == this.maxSignificantLength);
            lastTransition = newCallString.significantString.removeLast();
            Transition leastSignificantCall = newCallString.backLogString.removeLast();
            newCallString.significantString.addFirst(leastSignificantCall);
        } else {
            lastTransition = newCallString.significantString.removeLast();
        }
        if (!lastTransition.equals(transition)) {
            throw new DomainStateException.InvariantViolationException();
        }
        return newCallString;
    }

    public CallString unsafePop() {
        CallString newCallString = this.clone();
        assert (newCallString.size() > 0);
        if (this.maxSignificantLength == 0) {
            newCallString.backLogString.removeLast();
        } else if (newCallString.backLogString.size() > 0) {
            assert (newCallString.significantString.size() == this.maxSignificantLength);
            newCallString.significantString.removeLast();
            Transition leastSignificantCall = newCallString.backLogString.removeLast();
            newCallString.significantString.addFirst(leastSignificantCall);
        } else {
            newCallString.significantString.removeLast();
        }
        return newCallString;
    }

    public Transition peek() {
        return this.significantString.peekLast();
    }

    public CallString push(Transition transition) {
        CallString newCallString = this.clone();
        if (this.maxSignificantLength == 0) {
            newCallString.backLogString.addLast(transition);
        } else {
            if (newCallString.size() > this.maxSignificantLength) {
                Transition leastSignificantCall = newCallString.significantString.removeFirst();
                newCallString.backLogString.addLast(leastSignificantCall);
            }
            newCallString.significantString.addLast(transition);
        }
        return newCallString;
    }

    public int size() {
        return this.significantString.size() + this.backLogString.size();
    }

    public boolean isRoot() {
        return this.size() == 0;
    }

    public List<Transition> getSignificantTransitions() {
        return Collections.unmodifiableList(this.significantString);
    }

    public List<Transition> getAllTransitions() {
        LinkedList<Transition> all = new LinkedList<Transition>();
        all.addAll(this.backLogString);
        all.addAll(this.significantString);
        return Collections.unmodifiableList(all);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.significantString == null ? 0 : this.significantString.hashCode());
        result = 31 * result + this.maxSignificantLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallString)) {
            return false;
        }
        CallString other = (CallString)obj;
        if (this.significantString == null ? other.significantString != null : !this.significantString.equals(other.significantString)) {
            return false;
        }
        return this.maxSignificantLength == other.maxSignificantLength;
    }

    public String toString() {
        return this.significantString.toString();
    }

    public String pretty(int maxDisplayableCalls) {
        StringBuilder builder = new StringBuilder();
        if (this.getSignificantTransitions().isEmpty()) {
            return "";
        }
        List<Transition> transitions = this.getSignificantTransitions();
        if (transitions.size() > maxDisplayableCalls) {
            int callsSize = transitions.size();
            transitions = transitions.subList(callsSize - maxDisplayableCalls, callsSize);
            builder.append("(" + (callsSize - maxDisplayableCalls) + " more) [...] ");
        }
        for (Transition transition : transitions) {
            builder.append(transition.getTarget());
            builder.append("\u00bb ");
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    public static class Transition {
        private final RReilAddr source;
        private final RReilAddr target;

        public Transition(RReilAddr a, RReilAddr b) {
            this.source = a;
            this.target = b;
        }

        public RReilAddr getSource() {
            return this.source;
        }

        public RReilAddr getTarget() {
            return this.target;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            return builder.append('<').append(this.source).append("\u00bb").append(this.target).append('>').toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Transition)) {
                return false;
            }
            Transition other = (Transition)obj;
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }
    }
}

