/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.memderef;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.interfaces.MemoryDomain;
import javalx.data.Option;
import javalx.numeric.Range;

public class AbstractPointer {
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    public final NumVar.AddrVar address;
    public final Linear offset;

    public static AbstractPointer relativeTo(Linear offset, NumVar.AddrVar addr) {
        return new AbstractPointer(addr, offset.sub(addr));
    }

    public static AbstractPointer absolute(Linear offset) {
        return new AbstractPointer(null, offset);
    }

    private AbstractPointer(NumVar.AddrVar addr, Linear offset) {
        this.address = addr;
        this.offset = offset;
    }

    public final AbstractPointer setAddr(NumVar.AddrVar a) {
        return new AbstractPointer(a, this.offset);
    }

    public final AbstractPointer addOffset(Linear ofs) {
        return new AbstractPointer(this.address, this.offset.add(ofs));
    }

    public Option<NumVar.AddrVar> getAddrVar() {
        return Option.fromNullable(this.address);
    }

    public String toString() {
        return this.address + "[" + this.offset + "]";
    }

    public final Range getExplicitOffset(QueryChannel state) {
        return state.queryRange(this.offset);
    }

    public final <D extends MemoryDomain<D>> D calcBelowAccess(D state, Linear lower) {
        return state.eval(fin.unsignedLessThan(0, this.offset, lower));
    }

    public final <D extends MemoryDomain<D>> D calcAboveAccess(D state, Linear upper) {
        return state.eval(fin.unsignedLessThanOrEqualTo(0, upper, this.offset));
    }

    public boolean isAbsolute() {
        return this.address == null;
    }

    public static AbstractPointer createMemDeref(Finite.Rlin l, NumVar.AddrVar addr) {
        Linear linearTerm = l.getLinearTerm();
        if (addr != null) {
            linearTerm = linearTerm.sub(addr);
        }
        return new AbstractPointer(addr, linearTerm);
    }
}

