/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.finite;

import bindead.abstractsyntax.finite.Finite;

public abstract class FiniteBinOpVisitor<R> {
    public R visit(Finite.Bin stmt) {
        Finite.Rlin l = stmt.getLeft();
        Finite.Rlin r = stmt.getRight();
        switch (stmt.getOp()) {
            case Add: {
                return this.visitAdd(l, r);
            }
            case And: {
                return this.visitAnd(l, r);
            }
            case Divu: {
                return this.visitDiv(l, r);
            }
            case Divs: {
                return this.visitDivs(l, r);
            }
            case Mod: {
                return this.visitMod(l, r);
            }
            case Mul: {
                return this.visitMul(l, r);
            }
            case Or: {
                return this.visitOr(l, r);
            }
            case Shl: {
                return this.visitShl(l, r);
            }
            case Shr: {
                return this.visitShr(l, r);
            }
            case Shrs: {
                return this.visitShrs(l, r);
            }
            case Sub: {
                return this.visitSub(l, r);
            }
            case Xor: {
                return this.visitXor(l, r);
            }
        }
        throw new UnsupportedOperationException("Impossible");
    }

    protected abstract R visitAdd(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitAnd(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitDiv(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitDivs(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitMod(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitMul(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitOr(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitShl(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitShr(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitShrs(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitSub(Finite.Rlin var1, Finite.Rlin var2);

    protected abstract R visitXor(Finite.Rlin var1, Finite.Rlin var2);
}

