/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Environment;
import apron.Texpr0BinNode;
import apron.Texpr0Node;
import apron.Texpr1Node;
import java.io.Serializable;
import java.util.HashSet;

public class Texpr1BinNode
extends Texpr1Node
implements Cloneable,
Serializable {
    public int op;
    public int rtype;
    public int rdir;
    public Texpr1Node lArg;
    public Texpr1Node rArg;
    public static final int OP_ADD = 0;
    public static final int OP_SUB = 1;
    public static final int OP_MUL = 2;
    public static final int OP_DIV = 3;
    public static final int OP_MOD = 4;
    public static final int OP_POW = 5;

    public Texpr1BinNode(int n, int n2, int n3, Texpr1Node texpr1Node, Texpr1Node texpr1Node2) {
        this.op = n;
        this.rtype = n2;
        this.rdir = n3;
        this.lArg = texpr1Node;
        this.rArg = texpr1Node2;
    }

    public Texpr1BinNode(int n, Texpr1Node texpr1Node, Texpr1Node texpr1Node2) {
        this(n, 0, 4, texpr1Node, texpr1Node2);
    }

    @Override
    public Texpr1Node shallowCopy() {
        return new Texpr1BinNode(this.op, this.rtype, this.rdir, this.lArg, this.rArg);
    }

    @Override
    public Texpr1Node deepCopy() {
        return new Texpr1BinNode(this.op, this.rtype, this.rdir, this.lArg.deepCopy(), this.rArg.deepCopy());
    }

    @Override
    public Texpr0Node toTexpr0Node(Environment environment) {
        return new Texpr0BinNode(this.op, this.rtype, this.rdir, this.lArg.toTexpr0Node(environment), this.rArg.toTexpr0Node(environment));
    }

    @Override
    public String toString() {
        String string = Texpr0BinNode.opName(this.op);
        String string2 = this.rtype == 0 ? "" : "_" + Texpr0Node.suffixRType(this.rtype) + "," + Texpr0Node.suffixRDir(this.rdir);
        String string3 = this.lArg.toString();
        String string4 = this.rArg.toString();
        if (this.lArg.getPrecedence() < Texpr0BinNode.opPrecedence(this.op)) {
            string3 = "(" + string3 + ")";
        }
        if (this.rArg.getPrecedence() <= Texpr0BinNode.opPrecedence(this.op)) {
            string4 = "(" + string4 + ")";
        }
        return string3 + " " + string + string2 + " " + string4;
    }

    public int getOperation() {
        return this.op;
    }

    public void setOperation(int n) {
        this.op = n;
    }

    public int getRoundingType() {
        return this.rtype;
    }

    public void setRoundingType(int n) {
        this.rtype = n;
    }

    public int getRoundingDirection() {
        return this.rdir;
    }

    public void setRoundingDirection(int n) {
        this.rdir = n;
    }

    public Texpr1Node getLeftArgument() {
        return this.lArg;
    }

    public void setLeftArgument(Texpr1Node texpr1Node) {
        this.lArg = texpr1Node;
    }

    public Texpr1Node getRightArgument() {
        return this.rArg;
    }

    public void setRightArgument(Texpr1Node texpr1Node) {
        this.rArg = texpr1Node;
    }

    @Override
    public int getDepth() {
        int n;
        int n2 = this.lArg.getDepth();
        return (n2 > (n = this.rArg.getDepth()) ? n2 : n) + 1;
    }

    @Override
    public int getSize() {
        return this.lArg.getSize() + this.rArg.getSize() + 1;
    }

    @Override
    public boolean hasVar(String string) {
        return this.lArg.hasVar(string) || this.rArg.hasVar(string);
    }

    @Override
    protected void fillVars(HashSet<String> hashSet) {
        this.lArg.fillVars(hashSet);
        this.rArg.fillVars(hashSet);
    }

    @Override
    public boolean isIntervalCst() {
        return this.lArg.isIntervalCst() && this.rArg.isIntervalCst();
    }

    @Override
    public boolean isIntervalLinear() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalLinear();
            }
            case 2: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalCst() || this.rArg.isIntervalLinear() && this.lArg.isIntervalCst();
            }
            case 3: {
                return this.lArg.isIntervalLinear() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isIntervalPolynomial() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalPolynomial();
            }
            case 3: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalCst();
            }
            case 5: {
                return this.lArg.isIntervalPolynomial() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isIntervalPolyfrac() {
        if (this.rtype != 0) {
            return false;
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.lArg.isIntervalPolyfrac() && this.rArg.isIntervalPolyfrac();
            }
            case 5: {
                return this.lArg.isIntervalPolyfrac() && this.rArg.isIntervalCst();
            }
        }
        return false;
    }

    @Override
    public boolean isScalar() {
        return this.lArg.isScalar() && this.rArg.isScalar();
    }

    @Override
    public Texpr1Node substitute(String string, Texpr1Node texpr1Node) {
        this.lArg = this.lArg.substitute(string, texpr1Node);
        this.rArg = this.rArg.substitute(string, texpr1Node);
        return this;
    }

    @Override
    public int hashCode() {
        return this.lArg.hashCode() ^ this.rArg.hashCode() ^ this.rtype ^ this.rdir ^ this.op;
    }

    @Override
    public boolean isEqual(Texpr1Node texpr1Node) {
        if (texpr1Node instanceof Texpr1BinNode) {
            Texpr1BinNode texpr1BinNode = (Texpr1BinNode)texpr1Node;
            return this.op == texpr1BinNode.op && this.rtype == texpr1BinNode.rtype && this.rdir == texpr1BinNode.rdir && this.lArg.isEqual(texpr1BinNode.lArg) && this.rArg.isEqual(texpr1BinNode.rArg);
        }
        return false;
    }

    @Override
    public int getPrecedence() {
        return Texpr0BinNode.opPrecedence(this.op);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Texpr1BinNode && this.isEqual((Texpr1BinNode)object);
    }
}

