/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.Dimchange;
import apron.Dimperm;
import apron.Environment;
import apron.Linexpr0;
import apron.Linterm0;
import apron.Texpr0BinNode;
import apron.Texpr0CstNode;
import apron.Texpr0DimNode;
import apron.Texpr1Node;
import java.io.Serializable;

public abstract class Texpr0Node
implements Cloneable,
Serializable {
    public static final int RTYPE_REAL = 0;
    public static final int RTYPE_INT = 1;
    public static final int RTYPE_SINGLE = 2;
    public static final int RTYPE_DOUBLE = 3;
    public static final int RTYPE_EXTENDED = 4;
    public static final int RTYPE_QUAD = 5;
    public static final int RDIR_NEAREST = 0;
    public static final int RDIR_ZERO = 1;
    public static final int RDIR_UP = 2;
    public static final int RDIR_DOWN = 3;
    public static final int RDIR_RND = 4;

    public abstract Texpr0Node shallowCopy();

    public abstract Texpr0Node deepCopy();

    protected Texpr0Node() {
    }

    public static Texpr0Node fromLinexpr0(Linexpr0 linexpr0) {
        Texpr0Node texpr0Node = null;
        Coeff coeff = linexpr0.getCst();
        if (!coeff.isZero()) {
            texpr0Node = new Texpr0CstNode(coeff.copy());
        }
        Linterm0[] linterm0Array = linexpr0.getLinterms();
        for (int i = 0; i < linterm0Array.length; ++i) {
            if (linterm0Array[i].coeff.isZero()) continue;
            Texpr0BinNode texpr0BinNode = new Texpr0BinNode(2, new Texpr0CstNode(linterm0Array[i].coeff.copy()), new Texpr0DimNode(linterm0Array[i].dim));
            texpr0Node = texpr0Node == null ? texpr0BinNode : new Texpr0BinNode(0, texpr0Node, texpr0BinNode);
        }
        if (texpr0Node == null) {
            return new Texpr0CstNode();
        }
        return texpr0Node;
    }

    public abstract Texpr1Node toTexpr1Node(Environment var1);

    public String toString() {
        return this.toString(null);
    }

    public abstract String toString(String[] var1);

    public abstract int getDepth();

    public abstract int getSize();

    public abstract int maxDim();

    public abstract boolean hasDim(int var1);

    protected abstract void fillDims(boolean[] var1);

    public int[] getDims() {
        int n;
        boolean[] blArray = new boolean[this.maxDim()];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        this.fillDims(blArray);
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    public abstract boolean isIntervalCst();

    public abstract boolean isIntervalLinear();

    public abstract boolean isIntervalPolynomial();

    public abstract boolean isIntervalPolyfrac();

    public abstract boolean isScalar();

    public abstract Texpr0Node substitute(int var1, Texpr0Node var2);

    public Texpr0Node substituteCopy(int n, Texpr0Node texpr0Node) {
        Texpr0Node texpr0Node2 = this.deepCopy();
        return texpr0Node2.substitute(n, texpr0Node);
    }

    public abstract void addDimensions(Dimchange var1);

    public Texpr0Node addDimensionsCopy(Dimchange dimchange) {
        Texpr0Node texpr0Node = this.deepCopy();
        texpr0Node.addDimensions(dimchange);
        return texpr0Node;
    }

    public abstract Texpr0Node removeDimensions(Dimchange var1);

    public Texpr0Node removeDimensionsCopy(Dimchange dimchange) {
        Texpr0Node texpr0Node = this.deepCopy();
        return texpr0Node.removeDimensions(dimchange);
    }

    public abstract void permuteDimensions(Dimperm var1);

    public Texpr0Node permuteDimensionsCopy(Dimperm dimperm) {
        Texpr0Node texpr0Node = this.deepCopy();
        texpr0Node.permuteDimensions(dimperm);
        return texpr0Node;
    }

    public abstract int hashCode();

    public abstract boolean isEqual(Texpr0Node var1);

    public abstract int getPrecedence();

    public static String suffixRType(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "i";
            }
            case 2: {
                return "f";
            }
            case 3: {
                return "d";
            }
            case 4: {
                return "l";
            }
            case 5: {
                return "q";
            }
        }
        throw new IllegalArgumentException("unknown rounding type: " + n);
    }

    public static String suffixRDir(int n) {
        switch (n) {
            case 0: {
                return "n";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "+oo";
            }
            case 3: {
                return "-oo";
            }
            case 4: {
                return "?";
            }
        }
        throw new IllegalArgumentException("unknown rounding direction: " + n);
    }

    public Texpr0Node clone() throws CloneNotSupportedException {
        return this.deepCopy();
    }

    public abstract boolean equals(Object var1);
}

