/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Dimchange;
import apron.Dimperm;
import apron.Environment;
import apron.Interval;
import apron.Texpr0CstNode;
import apron.Texpr0Node;
import apron.Texpr1Node;
import apron.Texpr1VarNode;
import java.io.Serializable;

public class Texpr0DimNode
extends Texpr0Node
implements Cloneable,
Serializable {
    public int dim;

    public Texpr0DimNode(int n) {
        this.dim = n;
    }

    @Override
    public Texpr0Node shallowCopy() {
        return new Texpr0DimNode(this.dim);
    }

    @Override
    public Texpr0Node deepCopy() {
        return new Texpr0DimNode(this.dim);
    }

    @Override
    public Texpr1Node toTexpr1Node(Environment environment) {
        return new Texpr1VarNode(environment.varOfDim(this.dim));
    }

    @Override
    public String toString(String[] stringArray) {
        if (stringArray == null) {
            return "x" + this.dim;
        }
        return stringArray[this.dim];
    }

    public int getDimension() {
        return this.dim;
    }

    public void setDimension(int n) {
        this.dim = n;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public int maxDim() {
        return this.dim + 1;
    }

    @Override
    public boolean hasDim(int n) {
        return n == this.dim;
    }

    @Override
    protected void fillDims(boolean[] blArray) {
        blArray[this.dim] = true;
    }

    @Override
    public boolean isIntervalCst() {
        return false;
    }

    @Override
    public boolean isIntervalLinear() {
        return true;
    }

    @Override
    public boolean isIntervalPolynomial() {
        return true;
    }

    @Override
    public boolean isIntervalPolyfrac() {
        return true;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public Texpr0Node substitute(int n, Texpr0Node texpr0Node) {
        if (this.dim == n) {
            return texpr0Node;
        }
        return this;
    }

    @Override
    public void addDimensions(Dimchange dimchange) {
        this.dim = dimchange.afterAdd(this.dim);
    }

    @Override
    public Texpr0Node removeDimensions(Dimchange dimchange) {
        this.dim = dimchange.afterRemove(this.dim);
        if (this.dim == -1) {
            Interval interval = new Interval();
            interval.setTop();
            return new Texpr0CstNode(interval);
        }
        return this;
    }

    @Override
    public void permuteDimensions(Dimperm dimperm) {
        this.dim = dimperm.getElem(this.dim);
    }

    @Override
    public int hashCode() {
        return this.dim;
    }

    @Override
    public boolean isEqual(Texpr0Node texpr0Node) {
        return texpr0Node instanceof Texpr0DimNode && this.dim == ((Texpr0DimNode)texpr0Node).dim;
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Texpr0DimNode && this.isEqual((Texpr0DimNode)object);
    }
}

