/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Abstract0;
import apron.Abstract1;
import apron.ApronException;
import apron.Box;
import apron.Coeff;
import apron.Dimchange;
import apron.Dimperm;
import apron.DoubleScalar;
import apron.Environment;
import apron.Generator0;
import apron.Generator1;
import apron.Interval;
import apron.Lincons0;
import apron.Lincons1;
import apron.Linexpr0;
import apron.Linexpr1;
import apron.Linterm0;
import apron.Linterm1;
import apron.Manager;
import apron.MpfrScalar;
import apron.MpqScalar;
import apron.NotImplementedException;
import apron.Octagon;
import apron.Polka;
import apron.PplPoly;
import apron.Tcons0;
import apron.Tcons1;
import apron.Texpr0BinNode;
import apron.Texpr0CstNode;
import apron.Texpr0DimNode;
import apron.Texpr0Intern;
import apron.Texpr0Node;
import apron.Texpr1BinNode;
import apron.Texpr1CstNode;
import apron.Texpr1Intern;
import apron.Texpr1Node;
import apron.Texpr1VarNode;
import gmp.Mpfr;
import gmp.Mpq;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class Test {
    public static Object testSerialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            System.out.println("OUT: " + object);
            System.out.println("IN : " + object2);
            return object2;
        }
        catch (Exception exception) {
            System.out.println("caught exception " + exception);
            return null;
        }
    }

    public static void testDomain(Manager manager) throws ApronException {
        byte[] byArray;
        Interval[] intervalArray = new Interval[]{new Interval(1, 2), new Interval(-3, 5), new Interval(3, 4, 6, 5)};
        Linterm0[] linterm0Array = new Linterm0[]{new Linterm0(1, new MpqScalar(-5)), new Linterm0(0, new Interval(0.1, 0.6)), new Linterm0(2, new MpfrScalar(0.1, 2))};
        Linexpr0 linexpr0 = new Linexpr0(linterm0Array, (Coeff)new MpqScalar(2));
        Linterm0[] linterm0Array2 = new Linterm0[]{new Linterm0(1, new MpqScalar(-5)), new Linterm0(0, new MpqScalar(1, 2))};
        Linexpr0 linexpr02 = new Linexpr0(linterm0Array2, (Coeff)new MpqScalar(2));
        Texpr0BinNode texpr0BinNode = new Texpr0BinNode(0, new Texpr0BinNode(2, new Texpr0DimNode(0), new Texpr0DimNode(1)), new Texpr0BinNode(3, new Texpr0DimNode(2), new Texpr0CstNode(new MpqScalar(2))));
        Texpr0Intern texpr0Intern = new Texpr0Intern(texpr0BinNode);
        Lincons0 lincons0 = new Lincons0(1, linexpr0);
        Lincons0 lincons02 = new Lincons0(0, linexpr02);
        Lincons0[] lincons0Array = new Lincons0[]{lincons0, lincons02};
        Tcons0 tcons0 = new Tcons0(1, texpr0Intern);
        Generator0 generator0 = new Generator0(1, linexpr02);
        Generator0[] generator0Array = new Generator0[]{generator0};
        int[] nArray = new int[]{0, 1, 2};
        Dimchange dimchange = new Dimchange(2, 1, nArray);
        int[] nArray2 = new int[]{1, 0, 2};
        Dimperm dimperm = new Dimperm(nArray2);
        String[] stringArray = new String[]{"me", "myself", "I"};
        String[] stringArray2 = new String[]{"z", "a"};
        String[] stringArray3 = new String[]{"z", "t"};
        String[] stringArray4 = new String[]{"b"};
        String[] stringArray5 = new String[]{"a", "b", "z"};
        Environment environment = new Environment(stringArray2, stringArray4);
        Environment environment2 = new Environment(stringArray3, stringArray4);
        Linterm1[] linterm1Array = new Linterm1[]{new Linterm1("z", new MpqScalar(-5)), new Linterm1("b", new Interval(0.1, 0.6)), new Linterm1("a", new MpfrScalar(0.1, 2))};
        Linexpr1 linexpr1 = new Linexpr1(environment, linterm1Array, (Coeff)new MpqScalar(2));
        Linterm1[] linterm1Array2 = new Linterm1[]{new Linterm1("a", new MpqScalar(-5)), new Linterm1("z", new MpqScalar(1, 2))};
        Linexpr1 linexpr12 = new Linexpr1(environment, linterm1Array2, (Coeff)new MpqScalar(2));
        Texpr1BinNode texpr1BinNode = new Texpr1BinNode(0, new Texpr1BinNode(2, new Texpr1VarNode("a"), new Texpr1VarNode("z")), new Texpr1BinNode(3, new Texpr1VarNode("b"), new Texpr1CstNode(new MpqScalar(2))));
        Texpr1Intern texpr1Intern = new Texpr1Intern(environment, texpr1BinNode);
        Lincons1 lincons1 = new Lincons1(1, linexpr1);
        Lincons1 lincons12 = new Lincons1(0, linexpr12);
        Lincons1[] lincons1Array = new Lincons1[]{lincons1, lincons12};
        Tcons1 tcons1 = new Tcons1(1, texpr1Intern);
        Generator1 generator1 = new Generator1(1, linexpr12);
        Generator1[] generator1Array = new Generator1[]{generator1};
        System.out.println("lib: " + manager.getLibrary());
        System.out.println("ver: " + manager.getVersion());
        Abstract0 abstract0 = new Abstract0(manager, 2, 1);
        Abstract0 abstract02 = new Abstract0(manager, 2, 1, true);
        Abstract0 abstract03 = new Abstract0(manager, 2, 1, intervalArray);
        System.out.println("full: " + abstract0);
        System.out.println("empty: " + abstract02);
        System.out.println("a0: " + abstract03);
        System.out.println("a0: " + abstract03.toString(manager, stringArray));
        assert (!abstract0.isBottom(manager));
        assert (abstract0.isTop(manager));
        assert (abstract02.isBottom(manager));
        assert (!abstract02.isTop(manager));
        assert (!abstract03.isBottom(manager));
        assert (!abstract03.isTop(manager));
        assert (abstract03.isEqual(manager, abstract03));
        assert (abstract02.isEqual(manager, abstract02));
        assert (abstract0.isEqual(manager, abstract0));
        assert (abstract02.isIncluded(manager, abstract03));
        assert (abstract03.isIncluded(manager, abstract0));
        assert (abstract03.isIncluded(manager, abstract03));
        assert (!abstract03.isIncluded(manager, abstract02));
        assert (!abstract0.isIncluded(manager, abstract03));
        System.out.println("size: " + abstract03.getSize(manager));
        System.out.println("hash: " + abstract03.hashCode(manager));
        System.out.println("dim:  " + abstract03.getDimension(manager));
        Manager manager2 = abstract03.getCreationManager();
        assert (manager.getLibrary().equals(manager2.getLibrary()));
        abstract03.isBottom(manager2);
        System.out.println("to-lcons: " + Arrays.toString(abstract03.toLincons(manager)));
        System.out.println("to-box: " + Arrays.toString(abstract03.toBox(manager)));
        System.out.println("to-tcons: " + Arrays.toString(abstract03.toTcons(manager)));
        try {
            System.out.println("to-gen: " + Arrays.toString(abstract03.toGenerator(manager)));
        }
        catch (ApronException apronException) {
            System.out.println("got exception: " + apronException);
        }
        System.out.println("bound 0:   " + abstract03.getBound(manager, 0));
        System.out.println("bound lin: " + linexpr0 + " -> " + abstract03.getBound(manager, linexpr0));
        System.out.println("bound t:  " + texpr0Intern + " -> " + abstract03.getBound(manager, texpr0Intern));
        System.out.println("sat lin:  " + abstract03.satisfy(manager, lincons0));
        System.out.println("sat t:    " + abstract03.satisfy(manager, tcons0));
        System.out.println("sat 0:    " + intervalArray[0] + " -> " + abstract03.satisfy(manager, 0, intervalArray[0]));
        System.out.println("sat 1:    " + intervalArray[0] + " -> " + abstract03.satisfy(manager, 1, intervalArray[0]));
        System.out.println("uncons 0: " + abstract03.isDimensionUnconstrained(manager, 0));
        Abstract0 abstract04 = new Abstract0(manager, abstract03);
        assert (abstract03.isEqual(manager, abstract04));
        abstract04.addRay(manager, generator0);
        System.out.println("+ gen: " + generator0 + " -> " + abstract04);
        assert (!abstract03.isEqual(manager, abstract04));
        assert (abstract03.isIncluded(manager, abstract04));
        assert (!abstract04.isIncluded(manager, abstract03));
        assert (abstract04.isEqual(manager, abstract03.addRayCopy(manager, generator0)));
        Abstract0 abstract05 = new Abstract0(manager, abstract03);
        System.out.println("assign-lexp: " + abstract03.assignCopy(manager, 0, linexpr0, null));
        System.out.println("assign-texp: " + abstract03.assignCopy(manager, 0, texpr0Intern, null));
        System.out.println("subst-lexp: " + abstract03.substituteCopy(manager, 0, linexpr0, null));
        System.out.println("subst-texp: " + abstract03.substituteCopy(manager, 0, texpr0Intern, null));
        assert (abstract03.isEqual(manager, abstract05));
        abstract05.assign(manager, 0, linexpr0, null);
        assert (abstract05.isEqual(manager, abstract03.assignCopy(manager, 0, linexpr0, null)));
        assert (!abstract05.isEqual(manager, abstract03));
        abstract05.assign(manager, 0, texpr0Intern, null);
        abstract05.substitute(manager, 0, linexpr0, null);
        abstract05.substitute(manager, 0, texpr0Intern, null);
        assert (abstract03.meetCopy(manager, abstract0).isEqual(manager, abstract03));
        assert (abstract03.joinCopy(manager, abstract02).isEqual(manager, abstract03));
        assert (abstract03.meetCopy(manager, abstract02).isEqual(manager, abstract02));
        assert (abstract03.joinCopy(manager, abstract0).isEqual(manager, abstract0));
        assert (abstract03.meetCopy(manager, abstract03).isEqual(manager, abstract03));
        assert (abstract03.joinCopy(manager, abstract03).isEqual(manager, abstract03));
        assert (abstract03.meetCopy(manager, lincons0).isIncluded(manager, abstract03));
        assert (abstract03.meetCopy(manager, lincons02).isIncluded(manager, abstract03));
        assert (abstract03.meetCopy(manager, tcons0).isIncluded(manager, abstract03));
        System.out.println("+ const: " + lincons02 + " -> " + abstract03.meetCopy(manager, lincons02));
        Abstract0 abstract06 = abstract0.meetCopy(manager, lincons02);
        System.out.println("widen: " + abstract03.widening(manager, abstract06));
        System.out.println("widen threshold: " + abstract03.wideningThreshold(manager, abstract06, lincons0Array));
        Abstract0 abstract07 = new Abstract0(manager, abstract03);
        abstract07.meet(manager, lincons0Array);
        abstract07.assign(manager, 0, linexpr0, abstract03);
        abstract07.substitute(manager, 0, linexpr02, null);
        abstract07.meet(manager, tcons0);
        abstract07.join(manager, abstract03);
        Abstract0[] abstract0Array = new Abstract0[]{abstract03, abstract05, abstract07, abstract02, abstract0};
        assert (Abstract0.join(manager, abstract0Array).isTop(manager));
        assert (Abstract0.meet(manager, abstract0Array).isBottom(manager));
        try {
            abstract07.minimize(manager);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            abstract07.canonicalize(manager);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            abstract07.approximate(manager, 12);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        System.out.println("forget: " + abstract03.forgetCopy(manager, 0, true));
        Abstract0 abstract08 = new Abstract0(manager, abstract03);
        abstract08.forget(manager, 0, false);
        System.out.println("forget: " + abstract08);
        System.out.println("add-dim: " + abstract03.addDimensionsCopy(manager, dimchange, true));
        Abstract0 abstract09 = new Abstract0(manager, abstract03);
        abstract09.addDimensions(manager, dimchange, false);
        assert (abstract09.isEqual(manager, abstract03.addDimensionsCopy(manager, dimchange, false)));
        dimchange.addInvert();
        assert (abstract03.isEqual(manager, abstract09.removeDimensionsCopy(manager, dimchange)));
        abstract09.removeDimensions(manager, dimchange);
        assert (abstract09.isEqual(manager, abstract03));
        System.out.println("permute: " + abstract03.permuteDimensionsCopy(manager, dimperm));
        Abstract0 abstract010 = new Abstract0(manager, abstract03);
        abstract010.permuteDimensions(manager, dimperm);
        assert (abstract010.isEqual(manager, abstract03.permuteDimensionsCopy(manager, dimperm)));
        dimperm.invert();
        assert (abstract03.isEqual(manager, abstract010.permuteDimensionsCopy(manager, dimperm)));
        abstract010.permuteDimensions(manager, dimperm);
        assert (abstract010.isEqual(manager, abstract03));
        System.out.println("expand: " + abstract03.expandCopy(manager, 0, 2));
        Abstract0 abstract011 = new Abstract0(manager, abstract03);
        abstract011.expand(manager, 0, 2);
        assert (abstract011.isEqual(manager, abstract03.expandCopy(manager, 0, 2)));
        int[] nArray3 = new int[]{1, 2, 3};
        assert (abstract03.isEqual(manager, abstract011.foldCopy(manager, nArray3)));
        abstract011.fold(manager, nArray3);
        assert (abstract011.isEqual(manager, abstract03));
        Abstract0 abstract012 = new Abstract0(manager, abstract03);
        abstract012.closure(manager);
        assert (abstract012.isEqual(manager, abstract03.closureCopy(manager)));
        System.out.println("--------");
        Abstract1 abstract1 = new Abstract1(manager, environment);
        Abstract1 abstract12 = new Abstract1(manager, environment, true);
        Abstract1 abstract13 = new Abstract1(manager, environment, stringArray5, intervalArray);
        System.out.println("full: " + abstract1);
        System.out.println("empty: " + abstract12);
        System.out.println("a0:  " + abstract13);
        System.out.println("a0:  " + abstract13.toString(manager));
        assert (!abstract1.isBottom(manager));
        assert (abstract1.isTop(manager));
        assert (abstract12.isBottom(manager));
        assert (!abstract12.isTop(manager));
        assert (!abstract13.isBottom(manager));
        assert (!abstract13.isTop(manager));
        assert (abstract13.isEqual(manager, abstract13));
        assert (abstract12.isEqual(manager, abstract12));
        assert (abstract1.isEqual(manager, abstract1));
        assert (abstract12.isIncluded(manager, abstract13));
        assert (abstract13.isIncluded(manager, abstract1));
        assert (abstract13.isIncluded(manager, abstract13));
        assert (!abstract13.isIncluded(manager, abstract12));
        assert (!abstract1.isIncluded(manager, abstract13));
        System.out.println("size: " + abstract13.getSize(manager));
        System.out.println("hash: " + abstract13.hashCode(manager));
        System.out.println("env:  " + abstract13.getEnvironment());
        System.out.println("lvl0: " + abstract13.getAbstract0(manager));
        Manager manager3 = abstract13.getCreationManager();
        assert (manager.getLibrary().equals(manager3.getLibrary()));
        abstract13.isBottom(manager3);
        System.out.println("to-lcons: " + Arrays.toString(abstract13.toLincons(manager)));
        System.out.println("to-box: " + Arrays.toString(abstract13.toBox(manager)));
        System.out.println("to-tcons: " + Arrays.toString(abstract13.toTcons(manager)));
        try {
            System.out.println("to-gen: " + Arrays.toString(abstract13.toGenerator(manager)));
        }
        catch (ApronException apronException) {
            System.out.println("got exception: " + apronException);
        }
        System.out.println("bound a:   " + abstract13.getBound(manager, "a"));
        System.out.println("bound lin: " + linexpr1 + " -> " + abstract13.getBound(manager, linexpr1));
        System.out.println("bound t:  " + texpr1Intern + " -> " + abstract13.getBound(manager, texpr1Intern));
        System.out.println("sat lin:  " + abstract13.satisfy(manager, lincons1));
        System.out.println("sat t:    " + abstract13.satisfy(manager, tcons1));
        System.out.println("sat a:    " + intervalArray[0] + " -> " + abstract13.satisfy(manager, "a", intervalArray[0]));
        System.out.println("sat z:    " + intervalArray[0] + " -> " + abstract13.satisfy(manager, "z", intervalArray[0]));
        System.out.println("uncons a: " + abstract13.isDimensionUnconstrained(manager, "a"));
        Abstract1 abstract14 = new Abstract1(manager, abstract13);
        assert (abstract13.isEqual(manager, abstract14));
        abstract14.addRay(manager, generator1);
        System.out.println("+ gen: " + generator1 + " -> " + abstract14);
        assert (!abstract13.isEqual(manager, abstract14));
        assert (abstract13.isIncluded(manager, abstract14));
        assert (!abstract14.isIncluded(manager, abstract13));
        assert (abstract14.isEqual(manager, abstract13.addRayCopy(manager, generator1)));
        Abstract1 abstract15 = new Abstract1(manager, abstract13);
        System.out.println("assign-lexp: " + abstract13.assignCopy(manager, "a", linexpr1, null));
        System.out.println("assign-texp: " + abstract13.assignCopy(manager, "a", texpr1Intern, null));
        System.out.println("subst-lexp: " + abstract13.substituteCopy(manager, "a", linexpr1, null));
        System.out.println("subst-texp: " + abstract13.substituteCopy(manager, "a", texpr1Intern, null));
        assert (abstract13.isEqual(manager, abstract15));
        abstract15.assign(manager, "a", linexpr1, null);
        assert (abstract15.isEqual(manager, abstract13.assignCopy(manager, "a", linexpr1, null)));
        assert (!abstract15.isEqual(manager, abstract13));
        abstract15.assign(manager, "z", texpr1Intern, null);
        abstract15.substitute(manager, "z", linexpr1, null);
        abstract15.substitute(manager, "z", texpr1Intern, null);
        assert (abstract13.meetCopy(manager, abstract1).isEqual(manager, abstract13));
        assert (abstract13.joinCopy(manager, abstract12).isEqual(manager, abstract13));
        assert (abstract13.meetCopy(manager, abstract12).isEqual(manager, abstract12));
        assert (abstract13.joinCopy(manager, abstract1).isEqual(manager, abstract1));
        assert (abstract13.meetCopy(manager, abstract13).isEqual(manager, abstract13));
        assert (abstract13.joinCopy(manager, abstract13).isEqual(manager, abstract13));
        assert (abstract13.meetCopy(manager, lincons1).isIncluded(manager, abstract13));
        assert (abstract13.meetCopy(manager, lincons12).isIncluded(manager, abstract13));
        assert (abstract13.meetCopy(manager, tcons1).isIncluded(manager, abstract13));
        System.out.println("+ const: " + lincons12 + " -> " + abstract13.meetCopy(manager, lincons12));
        Abstract1 abstract16 = abstract1.meetCopy(manager, lincons12);
        System.out.println("widen: " + abstract13.widening(manager, abstract16));
        System.out.println("widen threshold: " + abstract13.wideningThreshold(manager, abstract16, lincons1Array));
        Abstract1 abstract17 = new Abstract1(manager, abstract13);
        abstract17.meet(manager, lincons1Array);
        abstract17.assign(manager, "a", linexpr1, abstract13);
        abstract17.substitute(manager, "a", linexpr12, null);
        abstract17.meet(manager, tcons1);
        abstract17.join(manager, abstract13);
        Abstract1[] abstract1Array = new Abstract1[]{abstract13, abstract15, abstract17, abstract12, abstract1};
        assert (Abstract1.join(manager, abstract1Array).isTop(manager));
        assert (Abstract1.meet(manager, abstract1Array).isBottom(manager));
        try {
            abstract17.minimize(manager);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            abstract17.canonicalize(manager);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            abstract17.approximate(manager, 12);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        System.out.println("forget: " + abstract13.forgetCopy(manager, "z", true));
        Abstract1 abstract18 = new Abstract1(manager, abstract13);
        abstract18.forget(manager, "a", false);
        System.out.println("forget: " + abstract18);
        String[] stringArray6 = new String[]{"a0", "z0"};
        System.out.println("expand: " + abstract13.expandCopy(manager, "a", stringArray6));
        Abstract1 abstract19 = new Abstract1(manager, abstract13);
        abstract19.expand(manager, "z", stringArray6);
        assert (abstract19.isEqual(manager, abstract13.expandCopy(manager, "z", stringArray6)));
        String[] stringArray7 = new String[]{"z", "z0", "a0"};
        assert (abstract13.isEqual(manager, abstract19.foldCopy(manager, stringArray7)));
        String[] stringArray8 = new String[]{"z0", "a0", "z"};
        System.out.println("fold: " + abstract19.foldCopy(manager, stringArray8));
        abstract19.fold(manager, stringArray7);
        assert (abstract19.isEqual(manager, abstract13));
        Abstract1 abstract110 = new Abstract1(manager, abstract13);
        abstract110.closure(manager);
        assert (abstract110.isEqual(manager, abstract13.closureCopy(manager)));
        Abstract1 abstract111 = new Abstract1(manager, environment2);
        try {
            abstract13.isEqual(manager, abstract111);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Abstract1 abstract112 = new Abstract1(manager, abstract13);
        abstract112.changeEnvironment(manager, environment2, true);
        System.out.println("chg-env: " + abstract112);
        assert (abstract112.isEqual(manager, abstract13.changeEnvironmentCopy(manager, environment2, true)));
        try {
            abstract13.isEqual(manager, abstract112);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println("unify: " + abstract112.unifyCopy(manager, abstract13));
        Abstract1 abstract113 = new Abstract1(manager, abstract13);
        abstract113.unify(manager, abstract112);
        assert (abstract112.unifyCopy(manager, abstract13).isEqual(manager, abstract113));
        String[] stringArray9 = new String[]{"a"};
        String[] stringArray10 = new String[]{"zz99"};
        Abstract1 abstract114 = new Abstract1(manager, abstract13);
        abstract114.rename(manager, stringArray9, stringArray10);
        System.out.println("rename: " + abstract114);
        assert (abstract114.isEqual(manager, abstract13.renameCopy(manager, stringArray9, stringArray10)));
        Abstract1 abstract115 = abstract13.forgetCopy(manager, "z", false);
        Abstract1 abstract116 = new Abstract1(manager, abstract115);
        abstract116.minimizeEnvironment(manager);
        System.out.println("min-env: " + abstract116.getEnvironment() + " : " + abstract116);
        assert (abstract116.isEqual(manager, abstract115.minimizeEnvironmentCopy(manager)));
        try {
            byArray = abstract03.serialize(manager);
            assert (abstract03.isEqual(manager, Abstract0.deserialize(manager, byArray)));
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        try {
            byArray = abstract13.serialize(manager);
            assert (abstract13.isEqual(manager, Abstract1.deserialize(manager, environment, byArray)));
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws ApronException, CloneNotSupportedException {
        for (int i = 0; i < 10; ++i) {
            Test.mainx(stringArray);
            System.gc();
            System.runFinalization();
        }
    }

    public static void mainx(String[] stringArray) throws ApronException, CloneNotSupportedException {
        System.out.println("Dimperm test");
        System.out.println("============");
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 0};
        Dimperm dimperm = new Dimperm(nArray);
        Dimperm dimperm2 = new Dimperm(7);
        System.out.println("shift:      " + dimperm);
        System.out.println("id:         " + dimperm2);
        System.out.println("inv shift:  " + dimperm.invert());
        System.out.println("shift+id:   " + dimperm.compose(dimperm2));
        dimperm2.setElem(0, 1);
        dimperm2.setElem(1, 0);
        assert (dimperm2.getElem(0) == 1);
        assert (dimperm2.getSize() == 7);
        System.out.println("swap:       " + dimperm2);
        System.out.println("shift+swap: " + dimperm.compose(dimperm2));
        dimperm.setId();
        System.out.println("id:         " + dimperm);
        assert (dimperm.equals(Test.testSerialize(dimperm)));
        System.out.println("");
        System.out.println("Dimchange test");
        System.out.println("==============");
        int[] nArray2 = new int[]{0, 3, 4};
        Dimchange dimchange = new Dimchange(2, 1, nArray2);
        System.out.println(dimchange);
        System.out.println(dimchange.getDimension() + ", " + Arrays.toString(dimchange.getContents()));
        assert (dimchange.equals(Test.testSerialize(dimchange)));
        System.out.println("");
        System.out.println("Linexpr0 test");
        System.out.println("=============");
        Linexpr0 linexpr0 = new Linexpr0();
        Linexpr0 linexpr02 = new Linexpr0(10);
        linexpr0.setCst(new MpqScalar(1, 2));
        linexpr0.setCoeff(0, new MpfrScalar(1.23, 2));
        linexpr0.setCoeff(1, new DoubleScalar(1.56));
        linexpr0.setCoeff(2, new Interval(1, 2, 3, 4));
        linexpr0.setCoeff(3, new Interval(new Mpq(4, 5), new Mpq(6, 7)));
        linexpr0.setCoeff(4, new Interval(new Mpfr(9.23, 2), new Mpfr(6.09, 2)));
        linexpr0.setCoeff(5, new Interval(1.23, 4.56));
        Interval interval = new Interval();
        interval.setTop();
        linexpr0.setCoeff(6, interval);
        linexpr02.setCoeff(2, new DoubleScalar(-2.0));
        linexpr02.setCoeff(3, new MpqScalar(-2, 3));
        try {
            linexpr0.setCoeff(-9, interval);
            assert (false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            linexpr02.setCoeff(99, interval);
            assert (false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        String[] stringArray2 = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        System.out.println("l1: " + linexpr0);
        System.out.println("l2: " + linexpr02.toString(stringArray2));
        linexpr0.permuteDimensions(dimperm2);
        System.out.println("permuted:  " + linexpr0);
        linexpr02.addDimensions(dimchange);
        System.out.println("dim added: " + linexpr02.toString(stringArray2));
        System.out.println("l1 terms: " + Arrays.toString(linexpr0.getLinterms()));
        System.out.println("l2 terms: " + Arrays.toString(linexpr02.getLinterms()));
        System.out.println("l1 coefs: " + Arrays.toString(linexpr0.getCoeffs()));
        System.out.println("l2 coefs: " + Arrays.toString(linexpr02.getCoeffs()));
        System.out.println("l1 hash: " + linexpr0.hashCode());
        System.out.println("l2 hash: " + linexpr02.hashCode());
        System.out.println("l1 pred: " + linexpr0.isSparse() + ", " + linexpr0.isInteger(3) + ", " + linexpr0.isReal(3) + ", " + linexpr0.isLinear() + ", " + linexpr0.isQuasilinear());
        System.out.println("l2 pred: " + linexpr02.isSparse() + ", " + linexpr02.isInteger(3) + ", " + linexpr02.isReal(3) + ", " + linexpr02.isLinear() + ", " + linexpr02.isQuasilinear());
        assert (linexpr0.isEqual(linexpr0));
        assert (linexpr02.isEqual(linexpr02));
        assert (!linexpr0.isEqual(linexpr02));
        assert (!linexpr02.isEqual(linexpr0));
        assert (linexpr0.isEqual(new Linexpr0(linexpr0)));
        assert (linexpr0.equals(Test.testSerialize(linexpr0)));
        assert (linexpr02.equals(Test.testSerialize(linexpr02)));
        System.out.println("");
        System.out.println("Texpr0 test");
        System.out.println("===========");
        Texpr0Intern texpr0Intern = new Texpr0Intern(linexpr0);
        Texpr0Node texpr0Node = Texpr0Node.fromLinexpr0(linexpr0);
        System.out.println("ti:     " + texpr0Intern);
        System.out.println("ti cvt: " + texpr0Intern.toTexpr0Node());
        System.out.println("tn:     " + texpr0Node);
        System.out.println("tn cvt: " + new Texpr0Intern(texpr0Node).toTexpr0Node());
        System.out.println("tn cpy: " + texpr0Node.deepCopy());
        System.out.println("depth: " + texpr0Intern.getDepth() + ", size: " + texpr0Intern.getSize() + ", max: " + texpr0Intern.maxDim() + ", cst: " + texpr0Intern.isIntervalCst() + ", lin: " + texpr0Intern.isIntervalLinear() + ", poly: " + texpr0Intern.isIntervalPolynomial() + ", frac: " + texpr0Intern.isIntervalPolyfrac() + ", scalar: " + texpr0Intern.isScalar() + ", hash: " + texpr0Intern.hashCode());
        System.out.println("depth: " + texpr0Node.getDepth() + ", size: " + texpr0Node.getSize() + ", max: " + texpr0Node.maxDim() + ", cst: " + texpr0Node.isIntervalCst() + ", lin: " + texpr0Node.isIntervalLinear() + ", poly: " + texpr0Node.isIntervalPolynomial() + ", frac: " + texpr0Node.isIntervalPolyfrac() + ", scalar: " + texpr0Node.isScalar() + ", hash: " + texpr0Node.hashCode());
        System.out.println("ti dims: " + Arrays.toString(texpr0Intern.getDims()));
        System.out.println("tn dims: " + Arrays.toString(texpr0Node.getDims()));
        Texpr0BinNode texpr0BinNode = new Texpr0BinNode(3, 2, 2, new Texpr0DimNode(2), new Texpr0DimNode(12));
        assert (!texpr0Intern.isEqual(new Texpr0Intern(texpr0BinNode)));
        assert (!texpr0Node.isEqual(texpr0BinNode));
        texpr0Intern.substitute(2, new Texpr0Intern(texpr0BinNode));
        texpr0Node.substitute(2, texpr0BinNode);
        System.out.println("ti susbt: " + texpr0Intern);
        System.out.println("tn subst: " + texpr0Node);
        assert (texpr0Intern.isEqual(new Texpr0Intern(texpr0Intern)));
        assert (texpr0Node.isEqual(texpr0Node.shallowCopy()));
        assert (texpr0Node.isEqual(texpr0Node.deepCopy()));
        assert (texpr0Intern.isEqual(new Texpr0Intern(texpr0Node)));
        assert (texpr0Node.isEqual(texpr0Intern.toTexpr0Node()));
        texpr0Intern.addDimensions(dimchange);
        texpr0Node.addDimensions(dimchange);
        System.out.println("ti add: " + texpr0Intern);
        assert (texpr0Node.isEqual(texpr0Intern.toTexpr0Node()));
        texpr0Intern.removeDimensions(dimchange);
        texpr0Node.removeDimensions(dimchange);
        System.out.println("ti rem: " + texpr0Intern);
        assert (texpr0Node.isEqual(texpr0Intern.toTexpr0Node()));
        texpr0Intern.removeDimensions(dimchange);
        texpr0Node.removeDimensions(dimchange);
        System.out.println("ti rem: " + texpr0Intern);
        assert (texpr0Node.isEqual(texpr0Intern.toTexpr0Node()));
        assert (texpr0Intern.equals(Test.testSerialize(texpr0Intern)));
        assert (texpr0Node.equals(Test.testSerialize(texpr0Node)));
        System.out.println("");
        System.out.println("Lincons0");
        System.out.println("========");
        Lincons0 lincons0 = new Lincons0(1, linexpr0);
        Lincons0 lincons02 = new Lincons0(false);
        Lincons0 lincons03 = new Lincons0(3, linexpr0, new MpqScalar(1, 2));
        System.out.println("lc1: " + lincons0);
        System.out.println("lc2: " + lincons02);
        System.out.println("lc3: " + lincons03);
        System.out.println("unsat: " + lincons0.isUnsat() + ", " + lincons02.isUnsat() + ", " + lincons03.isUnsat());
        System.out.println("lc1 pred: " + lincons0.isSparse() + ", " + lincons0.isInteger(3) + ", " + lincons0.isReal(3) + ", " + lincons0.isLinear() + ", " + lincons0.isQuasilinear());
        System.out.println("lc2 pred: " + lincons02.isSparse() + ", " + lincons02.isInteger(3) + ", " + lincons02.isReal(3) + ", " + lincons02.isLinear() + ", " + lincons02.isQuasilinear());
        System.out.println("lc3 pred: " + lincons03.isSparse() + ", " + lincons03.isInteger(3) + ", " + lincons03.isReal(3) + ", " + lincons03.isLinear() + ", " + lincons03.isQuasilinear());
        System.out.println("kind: " + lincons0.getKind() + ", " + lincons02.getKind() + ", " + lincons03.getKind());
        System.out.println("scalar: " + lincons0.getScalar() + ", " + lincons02.getScalar() + ", " + lincons03.getScalar());
        assert (lincons0.equals(Test.testSerialize(lincons0)));
        assert (lincons02.equals(Test.testSerialize(lincons02)));
        assert (lincons03.equals(Test.testSerialize(lincons03)));
        System.out.println("");
        System.out.println("Environments");
        System.out.println("============");
        Environment environment = new Environment();
        String[] stringArray3 = new String[]{"aa", "zz", "cc"};
        String[] stringArray4 = new String[]{"zzz", "cz", "a0"};
        String[] stringArray5 = new String[]{"kk", "ll"};
        Environment environment2 = new Environment(stringArray3, stringArray4);
        environment.add(stringArray4, stringArray3);
        environment2.add(null, null);
        environment2.remove(stringArray3);
        environment2.remove(stringArray4);
        System.out.println("empty: " + environment);
        System.out.println("env: " + environment2);
        System.out.println("env: " + Arrays.toString(environment2.getVars()));
        System.out.println("dim: " + environment2.getDimension());
        System.out.println("contains: " + environment2.hasVar("zzz") + ", " + environment2.hasVar("zzzz"));
        System.out.println("dim a0: " + environment2.dimOfVar("a0"));
        System.out.println("isint: " + environment2.isInt("zz") + ", " + environment2.isInt("a0"));
        System.out.println("var 1: " + environment2.varOfDim(1));
        System.out.println("hash: " + environment2.hashCode());
        System.out.println("add:  " + environment2.add(null, stringArray5));
        Dimperm[] dimpermArray = new Dimperm[1];
        System.out.println("add:  " + environment2.addPerm(null, stringArray5, dimpermArray));
        System.out.println("perm: " + dimpermArray[0]);
        Environment environment3 = environment2.add(null, stringArray5);
        System.out.println("rem: " + environment3.remove(stringArray4));
        assert (environment3.isEqual(environment2.add(null, stringArray5)));
        assert (!environment3.isEqual(environment2));
        assert (environment2.isIncluded(environment3));
        assert (!environment3.isIncluded(environment2));
        assert (environment3.cmp(environment2) == 1);
        assert (environment3.remove(stringArray5).isEqual(environment2));
        Environment environment4 = new Environment(stringArray3, stringArray5);
        System.out.println("lce: " + environment2.lce(environment4));
        Environment[] environmentArray = new Environment[]{environment, environment3, environment4};
        Environment environment5 = Environment.lce(environmentArray);
        System.out.println("lce: " + environment5);
        String[] stringArray6 = new String[]{"aa", "a0"};
        String[] stringArray7 = new String[]{"z0", "z1"};
        System.out.println("rename: " + environment2.rename(stringArray6, stringArray7));
        System.out.println("rename: " + environment2.rename(stringArray6, stringArray7, dimpermArray));
        System.out.println("perm:   " + dimpermArray[0]);
        System.out.println("dimchange: " + environment2.dimchange(environment3));
        System.out.println("dimchange2: " + Arrays.toString(environment2.dimchange2(environment4)));
        assert (environment.equals(Test.testSerialize(environment)));
        assert (environment2.equals(Test.testSerialize(environment2)));
        assert (environment3.equals(Test.testSerialize(environment3)));
        System.out.println("");
        System.out.println("Linexpr1 test");
        System.out.println("=============");
        Linexpr1 linexpr1 = new Linexpr1(environment2);
        Linexpr1 linexpr12 = new Linexpr1(environment2, 3);
        linexpr1.setCst(new MpqScalar(1, 2));
        linexpr1.setCoeff("aa", new MpfrScalar(1.23, 2));
        linexpr1.setCoeff("zz", new DoubleScalar(1.56));
        linexpr1.setCoeff("cc", new Interval(1, 2, 3, 4));
        linexpr1.setCoeff("zzz", new Interval(new Mpq(4, 5), new Mpq(6, 7)));
        linexpr1.setCoeff("cz", new Interval(new Mpfr(9.23, 2), new Mpfr(6.09, 2)));
        linexpr1.setCoeff("a0", new Interval(1.23, 4.56));
        linexpr12.setCoeff("zz", new DoubleScalar(-2.0));
        linexpr12.setCoeff("zzz", new MpqScalar(-2, 3));
        linexpr12.setCoeff("aa", new MpqScalar(0));
        linexpr12.setCoeff("cz", new Interval(new Mpfr(2.34, 2), new Mpfr(2.34, 2)));
        try {
            linexpr1.setCoeff("toto", interval);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            linexpr12.setCoeff("blurg", interval);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.out.println("ll1: " + linexpr1);
        System.out.println("ll2: " + linexpr12);
        linexpr12.minimize();
        System.out.println("minimized ll2: " + linexpr12);
        System.out.println("ll1 terms: " + Arrays.toString(linexpr1.getLinterms()));
        System.out.println("ll2 terms: " + Arrays.toString(linexpr12.getLinterms()));
        System.out.println("ll1 lvl0: " + linexpr1.getLinexpr0());
        System.out.println("ll2 lvl0: " + linexpr12.getLinexpr0());
        System.out.println("ll1 hash: " + linexpr1.hashCode());
        System.out.println("ll2 hash: " + linexpr12.hashCode());
        System.out.println("ll1 pred: " + linexpr1.isSparse() + ", " + linexpr1.isInteger() + ", " + linexpr1.isReal() + ", " + linexpr1.isLinear() + ", " + linexpr1.isQuasilinear());
        System.out.println("ll2 pred: " + linexpr12.isSparse() + ", " + linexpr12.isInteger() + ", " + linexpr12.isReal() + ", " + linexpr12.isLinear() + ", " + linexpr12.isQuasilinear());
        assert (linexpr1.isEqual(linexpr1));
        assert (linexpr12.isEqual(linexpr12));
        assert (!linexpr1.isEqual(linexpr12));
        assert (!linexpr12.isEqual(linexpr1));
        assert (linexpr1.isEqual(new Linexpr1(linexpr1)));
        System.out.println("ll1 ext: " + linexpr1.extendEnvironmentCopy(environment5));
        System.out.println("ll2 ext: " + linexpr12.extendEnvironmentCopy(environment5));
        assert (linexpr1.equals(Test.testSerialize(linexpr1)));
        assert (linexpr12.equals(Test.testSerialize(linexpr12)));
        System.out.println("");
        System.out.println("Texpr1 test");
        System.out.println("===========");
        Texpr1Intern texpr1Intern = new Texpr1Intern(linexpr1);
        Texpr1Node texpr1Node = Texpr1Node.fromLinexpr1(linexpr1);
        System.out.println("tti:      " + texpr1Intern);
        System.out.println("tti cvt:  " + texpr1Intern.toTexpr1Node());
        System.out.println("ttn:      " + texpr1Node);
        System.out.println("ttn cvt:  " + new Texpr1Intern(environment2, texpr1Node).toTexpr1Node());
        System.out.println("ttn cpy:  " + texpr1Node.deepCopy());
        System.out.println("tti lvl0: " + texpr1Intern.getTexpr0Intern());
        System.out.println("ttn lvl0: " + texpr1Node.toTexpr0Node(environment2));
        System.out.println("depth: " + texpr1Intern.getDepth() + ", size: " + texpr1Intern.getSize() + ", max: " + ", cst: " + texpr1Intern.isIntervalCst() + ", lin: " + texpr1Intern.isIntervalLinear() + ", poly: " + texpr1Intern.isIntervalPolynomial() + ", frac: " + texpr1Intern.isIntervalPolyfrac() + ", scalar: " + texpr1Intern.isScalar() + ", hash: " + texpr1Intern.hashCode());
        System.out.println("depth: " + texpr1Node.getDepth() + ", size: " + texpr1Node.getSize() + ", max: " + ", cst: " + texpr1Node.isIntervalCst() + ", lin: " + texpr1Node.isIntervalLinear() + ", poly: " + texpr1Node.isIntervalPolynomial() + ", frac: " + texpr1Node.isIntervalPolyfrac() + ", scalar: " + texpr1Node.isScalar() + ", hash: " + texpr1Node.hashCode());
        System.out.println("tti vars: " + Arrays.toString(texpr1Intern.getVars()));
        System.out.println("ttn vars: " + Arrays.toString(texpr1Node.getVars()));
        Texpr1BinNode texpr1BinNode = new Texpr1BinNode(3, 2, 2, new Texpr1VarNode("aa"), new Texpr1VarNode("zz"));
        assert (!texpr1Intern.isEqual(new Texpr1Intern(environment2, texpr1BinNode)));
        assert (!texpr1Node.isEqual(texpr1BinNode));
        texpr1Intern.substitute("zz", new Texpr1Intern(environment2, texpr1BinNode));
        texpr1Node.substitute("zz", texpr1BinNode);
        System.out.println("tti subst: " + texpr1Intern);
        System.out.println("ttn subst: " + texpr1Node);
        assert (texpr1Intern.isEqual(new Texpr1Intern(texpr1Intern)));
        assert (texpr1Node.isEqual(texpr1Node.shallowCopy()));
        assert (texpr1Node.isEqual(texpr1Node.deepCopy()));
        assert (texpr1Intern.isEqual(new Texpr1Intern(environment2, texpr1Node)));
        assert (texpr1Node.isEqual(texpr1Intern.toTexpr1Node()));
        texpr1Intern.extendEnvironment(environment5);
        System.out.println("tti ext: " + texpr1Intern);
        assert (texpr1Node.isEqual(texpr1Intern.toTexpr1Node()));
        assert (texpr1Intern.equals(Test.testSerialize(texpr1Intern)));
        assert (texpr1Node.equals(Test.testSerialize(texpr1Node)));
        System.out.println("");
        System.out.println("Lincons1");
        System.out.println("========");
        Lincons1 lincons1 = new Lincons1(1, linexpr1);
        Lincons1 lincons12 = new Lincons1(environment2, false);
        Lincons1 lincons13 = new Lincons1(3, linexpr1, new MpqScalar(1, 2));
        System.out.println("llc1: " + lincons1);
        System.out.println("llc2: " + lincons12);
        System.out.println("llc3: " + lincons13);
        System.out.println("llc1 lvl0: " + lincons1.getLincons0());
        System.out.println("llc2 lvl0: " + lincons12.getLincons0());
        System.out.println("llc3 lvl0: " + lincons13.getLincons0());
        System.out.println(lincons1.isUnsat() + ", " + lincons12.isUnsat() + ", " + lincons13.isUnsat());
        System.out.println("llc1 pred: " + lincons1.isSparse() + ", " + lincons1.isInteger() + ", " + lincons1.isReal() + ", " + lincons1.isLinear() + ", " + lincons1.isQuasilinear());
        System.out.println("llc2 pred: " + lincons12.isSparse() + ", " + lincons12.isInteger() + ", " + lincons12.isReal() + ", " + lincons12.isLinear() + ", " + lincons12.isQuasilinear());
        System.out.println("llc3 pred: " + lincons13.isSparse() + ", " + lincons13.isInteger() + ", " + lincons13.isReal() + ", " + lincons13.isLinear() + ", " + lincons13.isQuasilinear());
        System.out.println("kind: " + lincons1.getKind() + ", " + lincons12.getKind() + ", " + lincons13.getKind());
        System.out.println("scalar: " + lincons1.getScalar() + ", " + lincons12.getScalar() + ", " + lincons13.getScalar());
        assert (lincons1.equals(Test.testSerialize(lincons1)));
        assert (lincons12.equals(Test.testSerialize(lincons12)));
        assert (lincons13.equals(Test.testSerialize(lincons13)));
        System.out.println("");
        System.out.println("");
        System.out.println("Box");
        System.out.println("=========");
        Test.testDomain(new Box());
        System.out.println("");
        System.out.println("Octagons");
        System.out.println("=========");
        Test.testDomain(new Octagon());
        System.out.println("");
        System.out.println("Polyhedra");
        System.out.println("=========");
        Test.testDomain(new Polka(false));
        System.out.println("");
        Test.testDomain(new Polka(true));
        System.out.println("");
        System.out.println("PPL Polyhedra");
        System.out.println("=============");
        Test.testDomain(new PplPoly(false));
    }
}

