/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Environment;
import apron.Lincons1;
import apron.Scalar;
import apron.Tcons0;
import apron.Texpr1Intern;
import apron.Texpr1Node;
import java.io.Serializable;

public class Tcons1
implements Cloneable,
Serializable {
    protected Tcons0 cons;
    protected Environment env;
    public static final int EQ = 0;
    public static final int SUPEQ = 1;
    public static final int SUP = 2;
    public static final int EQMOD = 3;
    public static final int DISEQ = 4;

    private Tcons1() {
    }

    public static Tcons1 make(Environment environment, Tcons0 tcons0) {
        Tcons1 tcons1 = new Tcons1();
        tcons1.cons = tcons0;
        tcons1.env = environment;
        return tcons1;
    }

    public Tcons1(int n, Texpr1Intern texpr1Intern) {
        this.cons = new Tcons0(n, texpr1Intern.getTexpr0Intern());
        this.env = texpr1Intern.getEnvironment();
    }

    public Tcons1(int n, Texpr1Intern texpr1Intern, Scalar scalar) {
        this.cons = new Tcons0(n, texpr1Intern.getTexpr0Intern(), scalar);
        this.env = texpr1Intern.getEnvironment();
    }

    public Tcons1(Environment environment, int n, Texpr1Node texpr1Node) {
        this.cons = new Tcons0(n, texpr1Node.toTexpr0Node(environment));
        this.env = environment;
    }

    public Tcons1(Environment environment, int n, Texpr1Node texpr1Node, Scalar scalar) {
        this.cons = new Tcons0(n, texpr1Node.toTexpr0Node(environment), scalar);
        this.env = environment;
    }

    public Tcons1(Tcons1 tcons1) {
        this.cons = new Tcons0(tcons1.cons);
        this.env = tcons1.env;
    }

    public Tcons1(Lincons1 lincons1) {
        this.cons = new Tcons0(lincons1.getLincons0Ref());
        this.env = lincons1.getEnvironment();
    }

    public Tcons1(Environment environment, Tcons0 tcons0) {
        if (environment.getSize() < tcons0.expr.maxDim()) {
            throw new IllegalArgumentException("environment is too small");
        }
        this.cons = new Tcons0(tcons0);
        this.env = environment;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public int getKind() {
        return this.cons.kind;
    }

    public Scalar getScalar() {
        return this.cons.scalar;
    }

    public Texpr1Node toTexpr1Node() {
        return this.cons.expr.toTexpr0Node().toTexpr1Node(this.env);
    }

    public Tcons0 getTcons0() {
        return new Tcons0(this.cons);
    }

    public Tcons0 getTcons0Ref() {
        return this.cons;
    }

    public int getDepth() {
        return this.cons.getDepth();
    }

    public int getSize() {
        return this.cons.getSize();
    }

    public boolean hasVar(String string) {
        return this.env.hasVar(string) && this.cons.hasDim(this.env.dimOfVar(string));
    }

    public String[] getVars() {
        int[] nArray = this.cons.getDims();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.env.varOfDim(nArray[i]);
        }
        return stringArray;
    }

    public boolean isIntervalCst() {
        return this.cons.isIntervalCst();
    }

    public boolean isIntervalLinear() {
        return this.cons.isIntervalLinear();
    }

    public boolean isIntervalPolynomial() {
        return this.cons.isIntervalPolynomial();
    }

    public boolean isIntervalPolyfrac() {
        return this.cons.isIntervalPolyfrac();
    }

    public boolean isScalar() {
        return this.cons.isScalar();
    }

    public String toString() {
        return this.cons.toString(this.env.getVars());
    }

    public int hashCode() {
        return this.cons.hashCode() ^ this.env.hashCode();
    }

    public void setKind(int n) {
        this.cons.kind = n;
    }

    public void setScalar(Scalar scalar) {
        this.cons.scalar = scalar == null ? null : scalar.copy();
    }

    public void substitute(String string, Texpr1Intern texpr1Intern) {
        if (!this.env.isEqual(texpr1Intern.env)) {
            throw new IllegalArgumentException("incompatible environments");
        }
        this.cons.substitute(this.env.dimOfVar(string), texpr1Intern.getTexpr0InternRef());
    }

    public Tcons1 substituteCopy(String string, Texpr1Intern texpr1Intern) {
        Tcons1 tcons1 = new Tcons1(this);
        tcons1.substitute(string, texpr1Intern);
        return tcons1;
    }

    public void extendEnvironment(Environment environment) {
        this.cons.addDimensions(this.env.dimchange(environment));
        this.env = environment;
    }

    public Tcons1 extendEnvironmentCopy(Environment environment) {
        return Tcons1.make(environment, this.cons.addDimensionsCopy(this.env.dimchange(environment)));
    }

    public Tcons1 clone() throws CloneNotSupportedException {
        return new Tcons1(this);
    }

    public boolean isEqual(Tcons1 tcons1) {
        return this.env.isEqual(tcons1.env) && this.cons.isEqual(tcons1.cons);
    }

    public boolean equals(Object object) {
        return object instanceof Tcons1 && this.isEqual((Tcons1)object);
    }
}

