/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.DoubleScalar;
import apron.Interval;
import gmp.Mpfr;
import gmp.Mpq;
import java.io.Serializable;

public abstract class Scalar
extends Coeff
implements Cloneable,
Serializable {
    public static Scalar create() {
        return new DoubleScalar();
    }

    @Override
    public abstract Scalar copy();

    public abstract void setInfty(int var1);

    public abstract void set(int var1);

    public abstract int toMpq(Mpq var1, int var2);

    public abstract int toMpfr(Mpfr var1, int var2);

    public abstract int toDouble(double[] var1, int var2);

    @Override
    public abstract String toString();

    @Override
    public abstract int hashCode();

    @Override
    public Scalar inf() {
        return this;
    }

    @Override
    public Scalar sup() {
        return this;
    }

    public abstract int isInfty();

    @Override
    public abstract boolean isZero();

    public abstract int sgn();

    public abstract int cmp(Scalar var1);

    public abstract int cmp(int var1);

    public abstract boolean isEqual(Scalar var1);

    @Override
    public abstract boolean isEqual(int var1);

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEqual(Coeff coeff) {
        if (coeff instanceof Scalar) {
            return this.isEqual((Scalar)coeff);
        }
        if (coeff instanceof Interval) {
            Interval interval = (Interval)coeff;
            return interval.inf.isEqual(this) && interval.sup.isEqual(this);
        }
        throw new IllegalArgumentException("unknown Coeff subtype");
    }

    @Override
    public int cmp(Coeff coeff) {
        if (coeff instanceof Scalar) {
            return this.cmp((Scalar)coeff);
        }
        if (coeff instanceof Interval) {
            return ((Interval)coeff).cmp(new Interval(this, this));
        }
        throw new IllegalArgumentException("unknown Coeff subtype");
    }

    @Override
    public abstract void neg();

    public abstract void inv();
}

