/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.Dimchange;
import apron.Dimperm;
import apron.Linexpr0;
import apron.Linterm0;
import apron.Scalar;
import java.io.Serializable;

public class Generator0
implements Cloneable,
Serializable {
    public Linexpr0 coord;
    public int kind;
    public static final int LINE = 0;
    public static final int RAY = 1;
    public static final int VERTEX = 2;
    public static final int LINEMOD = 3;
    public static final int RAYMOD = 4;

    public Generator0(int n, Linexpr0 linexpr0) {
        this.coord = linexpr0;
        this.kind = n;
    }

    public Generator0(Generator0 generator0) {
        this.coord = new Linexpr0(generator0.coord);
        this.kind = generator0.kind;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Linterm0[] linterm0Array = this.coord.getLinterms();
        switch (this.kind) {
            case 0: {
                stringBuffer.append("LINE:    ");
                break;
            }
            case 1: {
                stringBuffer.append("RAY:     ");
                break;
            }
            case 2: {
                stringBuffer.append("VERTEX:  ");
                break;
            }
            case 3: {
                stringBuffer.append("LINEMOD: ");
                break;
            }
            case 4: {
                stringBuffer.append("RAYMOD:  ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown generator kind");
            }
        }
        for (int i = 0; i < linterm0Array.length; ++i) {
            Coeff coeff = linterm0Array[i].coeff;
            if (coeff.isZero()) continue;
            if (!(bl || coeff instanceof Scalar && ((Scalar)coeff).sgn() < 0)) {
                stringBuffer.append(" +");
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(coeff.toString());
            if (stringArray == null) {
                stringBuffer.append('x');
                stringBuffer.append(linterm0Array[i].dim);
            } else {
                stringBuffer.append(stringArray[linterm0Array[i].dim]);
            }
            bl = false;
        }
        if (bl) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.coord.hashCode() ^ this.kind;
    }

    public void addDimensions(Dimchange dimchange) {
        this.coord.addDimensions(dimchange);
    }

    public void permuteDimensions(Dimperm dimperm) {
        this.coord.permuteDimensions(dimperm);
    }

    public Generator0 addDimensionsCopy(Dimchange dimchange) {
        Generator0 generator0 = new Generator0(this);
        generator0.addDimensions(dimchange);
        return generator0;
    }

    public Generator0 permuteDimensionsCopy(Dimperm dimperm) {
        Generator0 generator0 = new Generator0(this);
        generator0.permuteDimensions(dimperm);
        return generator0;
    }

    public Generator0 clone() throws CloneNotSupportedException {
        return new Generator0(this);
    }

    public boolean isEqual(Generator0 generator0) {
        return this.coord.isEqual(generator0.coord) && this.kind == generator0.kind;
    }

    public boolean equals(Object object) {
        return object instanceof Generator0 && this.isEqual((Generator0)object);
    }

    public Linexpr0 getCoordinate() {
        return this.coord;
    }

    public int getKind() {
        return this.kind;
    }

    public void setCoordinate(Linexpr0 linexpr0) {
        this.coord = linexpr0;
    }

    public void setKind(int n) {
        this.kind = n;
    }
}

