/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Abstract0;
import apron.ApronException;
import apron.Dimchange;
import apron.Dimension;
import apron.Dimperm;
import apron.Environment;
import apron.Generator0;
import apron.Generator1;
import apron.Interval;
import apron.Lincons0;
import apron.Lincons1;
import apron.Linexpr0;
import apron.Linexpr1;
import apron.Manager;
import apron.Tcons0;
import apron.Tcons1;
import apron.Texpr0Intern;
import apron.Texpr1Intern;
import java.util.Arrays;

public class Abstract1
implements Cloneable {
    protected Abstract0 abs;
    protected Environment env;

    private Abstract1(Environment environment, Abstract0 abstract0) {
        this.abs = abstract0;
        this.env = environment;
    }

    private static void checkEnv(Environment environment, Environment environment2) {
        if (!environment.isEqual(environment2)) {
            throw new IllegalArgumentException("different environments");
        }
    }

    private void checkEnv(Environment environment) {
        Abstract1.checkEnv(this.env, environment);
    }

    private Abstract0 makeAbstract0Opt(Abstract1 abstract1) {
        if (abstract1 == null) {
            return null;
        }
        this.checkEnv(abstract1.env);
        return abstract1.abs;
    }

    private static Abstract0[] makeAbstract0Array(Abstract1[] abstract1Array) {
        int n;
        Abstract0[] abstract0Array = new Abstract0[abstract1Array.length];
        for (n = 0; n < abstract1Array.length; ++n) {
            abstract0Array[n] = abstract1Array[n].abs;
        }
        for (n = 1; n < abstract1Array.length; ++n) {
            Abstract1.checkEnv(abstract1Array[0].env, abstract1Array[n].env);
        }
        return abstract0Array;
    }

    private Lincons0[] makeLincons0Array(Lincons1[] lincons1Array) {
        Lincons0[] lincons0Array = new Lincons0[lincons1Array.length];
        for (int i = 0; i < lincons1Array.length; ++i) {
            lincons0Array[i] = lincons1Array[i].getLincons0Ref();
            this.checkEnv(lincons1Array[i].getEnvironment());
        }
        return lincons0Array;
    }

    private Tcons0[] makeTcons0Array(Tcons1[] tcons1Array) {
        Tcons0[] tcons0Array = new Tcons0[tcons1Array.length];
        for (int i = 0; i < tcons1Array.length; ++i) {
            tcons0Array[i] = tcons1Array[i].getTcons0Ref();
            this.checkEnv(tcons1Array[i].getEnvironment());
        }
        return tcons0Array;
    }

    private Generator0[] makeGenerator0Array(Generator1[] generator1Array) {
        Generator0[] generator0Array = new Generator0[generator1Array.length];
        for (int i = 0; i < generator1Array.length; ++i) {
            generator0Array[i] = generator1Array[i].getGenerator0Ref();
            this.checkEnv(generator1Array[i].getEnvironment());
        }
        return generator0Array;
    }

    private Linexpr0[] makeLinexpr0Array(Linexpr1[] linexpr1Array) {
        Linexpr0[] linexpr0Array = new Linexpr0[linexpr1Array.length];
        for (int i = 0; i < linexpr1Array.length; ++i) {
            linexpr0Array[i] = linexpr1Array[i].getLinexpr0Ref();
            this.checkEnv(linexpr1Array[i].getEnvironment());
        }
        return linexpr0Array;
    }

    private Texpr0Intern[] makeTexpr0InternArray(Texpr1Intern[] texpr1InternArray) {
        Texpr0Intern[] texpr0InternArray = new Texpr0Intern[texpr1InternArray.length];
        for (int i = 0; i < texpr1InternArray.length; ++i) {
            texpr0InternArray[i] = texpr1InternArray[i].getTexpr0InternRef();
            this.checkEnv(texpr1InternArray[i].getEnvironment());
        }
        return texpr0InternArray;
    }

    private int[] makeDimArray(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.env.dimOfVar(stringArray[i]);
        }
        return nArray;
    }

    public Abstract1(Manager manager, Abstract1 abstract1) throws ApronException {
        this.abs = new Abstract0(manager, abstract1.abs);
        this.env = abstract1.env;
    }

    public Abstract1(Manager manager, Environment environment) throws ApronException {
        Dimension dimension = environment.getDimension();
        this.abs = new Abstract0(manager, dimension.intDim, dimension.realDim);
        this.env = environment;
    }

    public Abstract1(Manager manager, Environment environment, boolean bl) throws ApronException {
        Dimension dimension = environment.getDimension();
        this.abs = new Abstract0(manager, dimension.intDim, dimension.realDim, bl);
        this.env = environment;
    }

    public Abstract1(Manager manager, Environment environment, String[] stringArray, Interval[] intervalArray) throws ApronException {
        int n;
        if (stringArray.length != intervalArray.length) {
            throw new IllegalArgumentException("incompatible array sizes");
        }
        Dimension dimension = environment.getDimension();
        Interval[] intervalArray2 = new Interval[dimension.intDim + dimension.realDim];
        Interval interval = new Interval();
        interval.setTop();
        for (n = 0; n < dimension.intDim + dimension.realDim; ++n) {
            intervalArray2[n] = interval;
        }
        for (n = 0; n < stringArray.length; ++n) {
            intervalArray2[environment.dimOfVar((String)stringArray[n])] = intervalArray[n];
        }
        this.abs = new Abstract0(manager, dimension.intDim, dimension.realDim, intervalArray2);
        this.env = environment;
    }

    public Abstract1(Manager manager, Lincons1[] lincons1Array) throws ApronException {
        this(manager, lincons1Array[0].getEnvironment());
        this.meet(manager, lincons1Array);
    }

    public Abstract1(Manager manager, Tcons1[] tcons1Array) throws ApronException {
        this(manager, tcons1Array[0].getEnvironment());
        this.meet(manager, tcons1Array);
    }

    public int getSize(Manager manager) throws ApronException {
        return this.abs.getSize(manager);
    }

    public int hashCode(Manager manager) throws ApronException {
        return this.abs.hashCode(manager) ^ this.env.hashCode();
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public Abstract0 getAbstract0(Manager manager) throws ApronException {
        return new Abstract0(manager, this.abs);
    }

    public Abstract0 getAbstract0Ref() {
        return this.abs;
    }

    public Manager getCreationManager() {
        return this.abs.getCreationManager();
    }

    public String toString() {
        return this.toString(this.getCreationManager());
    }

    public String toString(Manager manager) {
        return this.abs.toString(manager, this.env.getVars());
    }

    public Interval getBound(Manager manager, Linexpr1 linexpr1) throws ApronException {
        this.checkEnv(linexpr1.getEnvironment());
        return this.abs.getBound(manager, linexpr1.getLinexpr0Ref());
    }

    public Interval getBound(Manager manager, Texpr1Intern texpr1Intern) throws ApronException {
        this.checkEnv(texpr1Intern.getEnvironment());
        return this.abs.getBound(manager, texpr1Intern.getTexpr0InternRef());
    }

    public Interval getBound(Manager manager, String string) throws ApronException {
        return this.abs.getBound(manager, this.env.dimOfVar(string));
    }

    public Lincons1[] toLincons(Manager manager) throws ApronException {
        Lincons0[] lincons0Array = this.abs.toLincons(manager);
        Lincons1[] lincons1Array = new Lincons1[lincons0Array.length];
        for (int i = 0; i < lincons0Array.length; ++i) {
            lincons1Array[i] = Lincons1.make(this.env, lincons0Array[i]);
        }
        return lincons1Array;
    }

    public Tcons1[] toTcons(Manager manager) throws ApronException {
        Tcons0[] tcons0Array = this.abs.toTcons(manager);
        Tcons1[] tcons1Array = new Tcons1[tcons0Array.length];
        for (int i = 0; i < tcons0Array.length; ++i) {
            tcons1Array[i] = Tcons1.make(this.env, tcons0Array[i]);
        }
        return tcons1Array;
    }

    public Interval[] toBox(Manager manager) throws ApronException {
        return this.abs.toBox(manager);
    }

    public Generator1[] toGenerator(Manager manager) throws ApronException {
        Generator0[] generator0Array = this.abs.toGenerator(manager);
        Generator1[] generator1Array = new Generator1[generator0Array.length];
        for (int i = 0; i < generator0Array.length; ++i) {
            generator1Array[i] = Generator1.make(this.env, generator0Array[i]);
        }
        return generator1Array;
    }

    public boolean isBottom(Manager manager) throws ApronException {
        return this.abs.isBottom(manager);
    }

    public boolean isTop(Manager manager) throws ApronException {
        return this.abs.isTop(manager);
    }

    public boolean isIncluded(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        return this.abs.isIncluded(manager, abstract1.abs);
    }

    public boolean isEqual(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        return this.abs.isEqual(manager, abstract1.abs);
    }

    public boolean satisfy(Manager manager, Lincons1 lincons1) throws ApronException {
        this.checkEnv(lincons1.getEnvironment());
        return this.abs.satisfy(manager, lincons1.getLincons0Ref());
    }

    public boolean satisfy(Manager manager, Tcons1 tcons1) throws ApronException {
        this.checkEnv(tcons1.getEnvironment());
        return this.abs.satisfy(manager, tcons1.getTcons0Ref());
    }

    public boolean satisfy(Manager manager, String string, Interval interval) throws ApronException {
        return this.abs.satisfy(manager, this.env.dimOfVar(string), interval);
    }

    public boolean isDimensionUnconstrained(Manager manager, String string) throws ApronException {
        return this.abs.isDimensionUnconstrained(manager, this.env.dimOfVar(string));
    }

    public void minimize(Manager manager) throws ApronException {
        this.abs.minimize(manager);
    }

    public void canonicalize(Manager manager) throws ApronException {
        this.abs.canonicalize(manager);
    }

    public void approximate(Manager manager, int n) throws ApronException {
        this.abs.approximate(manager, n);
    }

    public Abstract1 meetCopy(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        return new Abstract1(this.env, this.abs.meetCopy(manager, abstract1.abs));
    }

    public static Abstract1 meet(Manager manager, Abstract1[] abstract1Array) throws ApronException {
        return new Abstract1(abstract1Array[0].env, Abstract0.meet(manager, Abstract1.makeAbstract0Array(abstract1Array)));
    }

    public void meet(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        this.abs.meet(manager, abstract1.abs);
    }

    public Abstract1 joinCopy(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        return new Abstract1(this.env, this.abs.joinCopy(manager, abstract1.abs));
    }

    public static Abstract1 join(Manager manager, Abstract1[] abstract1Array) throws ApronException {
        return new Abstract1(abstract1Array[0].env, Abstract0.join(manager, Abstract1.makeAbstract0Array(abstract1Array)));
    }

    public void join(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        this.abs.join(manager, abstract1.abs);
    }

    public Abstract1 meetCopy(Manager manager, Lincons1[] lincons1Array) throws ApronException {
        return new Abstract1(this.env, this.abs.meetCopy(manager, this.makeLincons0Array(lincons1Array)));
    }

    public Abstract1 meetCopy(Manager manager, Tcons1[] tcons1Array) throws ApronException {
        return new Abstract1(this.env, this.abs.meetCopy(manager, this.makeTcons0Array(tcons1Array)));
    }

    public void meet(Manager manager, Lincons1[] lincons1Array) throws ApronException {
        this.abs.meet(manager, this.makeLincons0Array(lincons1Array));
    }

    public void meet(Manager manager, Tcons1[] tcons1Array) throws ApronException {
        this.abs.meet(manager, this.makeTcons0Array(tcons1Array));
    }

    public Abstract1 meetCopy(Manager manager, Lincons1 lincons1) throws ApronException {
        this.checkEnv(lincons1.getEnvironment());
        return new Abstract1(this.env, this.abs.meetCopy(manager, lincons1.getLincons0Ref()));
    }

    public Abstract1 meetCopy(Manager manager, Tcons1 tcons1) throws ApronException {
        this.checkEnv(tcons1.getEnvironment());
        return new Abstract1(this.env, this.abs.meetCopy(manager, tcons1.getTcons0Ref()));
    }

    public void meet(Manager manager, Lincons1 lincons1) throws ApronException {
        this.checkEnv(lincons1.getEnvironment());
        this.abs.meet(manager, lincons1.getLincons0Ref());
    }

    public void meet(Manager manager, Tcons1 tcons1) throws ApronException {
        this.checkEnv(tcons1.getEnvironment());
        this.abs.meet(manager, tcons1.getTcons0Ref());
    }

    public Abstract1 addRayCopy(Manager manager, Generator1[] generator1Array) throws ApronException {
        return new Abstract1(this.env, this.abs.addRayCopy(manager, this.makeGenerator0Array(generator1Array)));
    }

    public void addRay(Manager manager, Generator1[] generator1Array) throws ApronException {
        this.abs.addRay(manager, this.makeGenerator0Array(generator1Array));
    }

    public Abstract1 addRayCopy(Manager manager, Generator1 generator1) throws ApronException {
        this.checkEnv(generator1.getEnvironment());
        return new Abstract1(this.env, this.abs.addRayCopy(manager, generator1.getGenerator0Ref()));
    }

    public void addRay(Manager manager, Generator1 generator1) throws ApronException {
        this.checkEnv(generator1.getEnvironment());
        this.abs.addRay(manager, generator1.getGenerator0Ref());
    }

    public void assign(Manager manager, String[] stringArray, Linexpr1[] linexpr1Array, Abstract1 abstract1) throws ApronException {
        this.abs.assign(manager, this.makeDimArray(stringArray), this.makeLinexpr0Array(linexpr1Array), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 assignCopy(Manager manager, String[] stringArray, Linexpr1[] linexpr1Array, Abstract1 abstract1) throws ApronException {
        return new Abstract1(this.env, this.abs.assignCopy(manager, this.makeDimArray(stringArray), this.makeLinexpr0Array(linexpr1Array), this.makeAbstract0Opt(abstract1)));
    }

    public void assign(Manager manager, String[] stringArray, Texpr1Intern[] texpr1InternArray, Abstract1 abstract1) throws ApronException {
        this.abs.assign(manager, this.makeDimArray(stringArray), this.makeTexpr0InternArray(texpr1InternArray), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 assignCopy(Manager manager, String[] stringArray, Texpr1Intern[] texpr1InternArray, Abstract1 abstract1) throws ApronException {
        return new Abstract1(this.env, this.abs.assignCopy(manager, this.makeDimArray(stringArray), this.makeTexpr0InternArray(texpr1InternArray), this.makeAbstract0Opt(abstract1)));
    }

    public void substitute(Manager manager, String[] stringArray, Linexpr1[] linexpr1Array, Abstract1 abstract1) throws ApronException {
        this.abs.substitute(manager, this.makeDimArray(stringArray), this.makeLinexpr0Array(linexpr1Array), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 substituteCopy(Manager manager, String[] stringArray, Linexpr1[] linexpr1Array, Abstract1 abstract1) throws ApronException {
        return new Abstract1(this.env, this.abs.substituteCopy(manager, this.makeDimArray(stringArray), this.makeLinexpr0Array(linexpr1Array), this.makeAbstract0Opt(abstract1)));
    }

    public void substitute(Manager manager, String[] stringArray, Texpr1Intern[] texpr1InternArray, Abstract1 abstract1) throws ApronException {
        this.abs.substitute(manager, this.makeDimArray(stringArray), this.makeTexpr0InternArray(texpr1InternArray), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 substituteCopy(Manager manager, String[] stringArray, Texpr1Intern[] texpr1InternArray, Abstract1 abstract1) throws ApronException {
        return new Abstract1(this.env, this.abs.substituteCopy(manager, this.makeDimArray(stringArray), this.makeTexpr0InternArray(texpr1InternArray), this.makeAbstract0Opt(abstract1)));
    }

    public void assign(Manager manager, String string, Linexpr1 linexpr1, Abstract1 abstract1) throws ApronException {
        this.checkEnv(linexpr1.getEnvironment());
        this.abs.assign(manager, this.env.dimOfVar(string), linexpr1.getLinexpr0Ref(), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 assignCopy(Manager manager, String string, Linexpr1 linexpr1, Abstract1 abstract1) throws ApronException {
        this.checkEnv(linexpr1.getEnvironment());
        return new Abstract1(this.env, this.abs.assignCopy(manager, this.env.dimOfVar(string), linexpr1.getLinexpr0Ref(), this.makeAbstract0Opt(abstract1)));
    }

    public void assign(Manager manager, String string, Texpr1Intern texpr1Intern, Abstract1 abstract1) throws ApronException {
        this.checkEnv(texpr1Intern.getEnvironment());
        this.abs.assign(manager, this.env.dimOfVar(string), texpr1Intern.getTexpr0InternRef(), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 assignCopy(Manager manager, String string, Texpr1Intern texpr1Intern, Abstract1 abstract1) throws ApronException {
        this.checkEnv(texpr1Intern.getEnvironment());
        return new Abstract1(this.env, this.abs.assignCopy(manager, this.env.dimOfVar(string), texpr1Intern.getTexpr0InternRef(), this.makeAbstract0Opt(abstract1)));
    }

    public void substitute(Manager manager, String string, Linexpr1 linexpr1, Abstract1 abstract1) throws ApronException {
        this.checkEnv(linexpr1.getEnvironment());
        this.abs.substitute(manager, this.env.dimOfVar(string), linexpr1.getLinexpr0Ref(), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 substituteCopy(Manager manager, String string, Linexpr1 linexpr1, Abstract1 abstract1) throws ApronException {
        this.checkEnv(linexpr1.getEnvironment());
        return new Abstract1(this.env, this.abs.substituteCopy(manager, this.env.dimOfVar(string), linexpr1.getLinexpr0Ref(), this.makeAbstract0Opt(abstract1)));
    }

    public void substitute(Manager manager, String string, Texpr1Intern texpr1Intern, Abstract1 abstract1) throws ApronException {
        this.checkEnv(texpr1Intern.getEnvironment());
        this.abs.substitute(manager, this.env.dimOfVar(string), texpr1Intern.getTexpr0InternRef(), this.makeAbstract0Opt(abstract1));
    }

    public Abstract1 substituteCopy(Manager manager, String string, Texpr1Intern texpr1Intern, Abstract1 abstract1) throws ApronException {
        this.checkEnv(texpr1Intern.getEnvironment());
        return new Abstract1(this.env, this.abs.substituteCopy(manager, this.env.dimOfVar(string), texpr1Intern.getTexpr0InternRef(), this.makeAbstract0Opt(abstract1)));
    }

    public Abstract1 forgetCopy(Manager manager, String[] stringArray, boolean bl) throws ApronException {
        return new Abstract1(this.env, this.abs.forgetCopy(manager, this.makeDimArray(stringArray), bl));
    }

    public void forget(Manager manager, String[] stringArray, boolean bl) throws ApronException {
        this.abs.forget(manager, this.makeDimArray(stringArray), bl);
    }

    public Abstract1 forgetCopy(Manager manager, String string, boolean bl) throws ApronException {
        return new Abstract1(this.env, this.abs.forgetCopy(manager, this.env.dimOfVar(string), bl));
    }

    public void forget(Manager manager, String string, boolean bl) throws ApronException {
        this.abs.forget(manager, this.env.dimOfVar(string), bl);
    }

    public Abstract1 changeEnvironmentCopy(Manager manager, Environment environment, boolean bl) throws ApronException {
        Dimchange[] dimchangeArray = this.env.dimchange2(environment);
        Abstract0 abstract0 = this.abs.addDimensionsCopy(manager, dimchangeArray[0], bl);
        abstract0.removeDimensions(manager, dimchangeArray[1]);
        return new Abstract1(environment, abstract0);
    }

    public void changeEnvironment(Manager manager, Environment environment, boolean bl) throws ApronException {
        Dimchange[] dimchangeArray = this.env.dimchange2(environment);
        this.abs.addDimensions(manager, dimchangeArray[0], bl);
        this.abs.removeDimensions(manager, dimchangeArray[1]);
        this.env = environment;
    }

    private Environment withoutUnconstrained(Manager manager) throws ApronException {
        int n;
        int n2 = this.env.getSize();
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            blArray[n] = this.abs.isDimensionUnconstrained(manager, n);
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!blArray[i]) continue;
            stringArray[n3] = this.env.varOfDim(i);
            ++n3;
        }
        return this.env.remove(stringArray);
    }

    public Abstract1 minimizeEnvironmentCopy(Manager manager) throws ApronException {
        return this.changeEnvironmentCopy(manager, this.withoutUnconstrained(manager), false);
    }

    public void minimizeEnvironment(Manager manager) throws ApronException {
        this.changeEnvironment(manager, this.withoutUnconstrained(manager), false);
    }

    public Abstract1 renameCopy(Manager manager, String[] stringArray, String[] stringArray2) throws ApronException {
        Dimperm[] dimpermArray = new Dimperm[1];
        Environment environment = this.env.rename(stringArray, stringArray2, dimpermArray);
        return new Abstract1(environment, this.abs.permuteDimensionsCopy(manager, dimpermArray[0]));
    }

    public void rename(Manager manager, String[] stringArray, String[] stringArray2) throws ApronException {
        Dimperm[] dimpermArray = new Dimperm[1];
        this.env = this.env.rename(stringArray, stringArray2, dimpermArray);
        this.abs.permuteDimensions(manager, dimpermArray[0]);
    }

    public Abstract1 unifyCopy(Manager manager, Abstract1 abstract1) throws ApronException {
        Environment environment = this.env.lce(abstract1.env);
        Abstract1 abstract12 = this.changeEnvironmentCopy(manager, environment, false);
        abstract12.meet(manager, abstract1.changeEnvironmentCopy(manager, environment, false));
        return abstract12;
    }

    public void unify(Manager manager, Abstract1 abstract1) throws ApronException {
        Environment environment = this.env.lce(abstract1.env);
        this.changeEnvironment(manager, environment, false);
        this.meet(manager, abstract1.changeEnvironmentCopy(manager, environment, false));
    }

    public Abstract1 expandCopy(Manager manager, String string, String[] stringArray) throws ApronException {
        Abstract0 abstract0 = this.abs.expandCopy(manager, this.env.dimOfVar(string), stringArray.length);
        Dimperm[] dimpermArray = new Dimperm[1];
        Environment environment = this.env.isInt(string) ? this.env.addPerm(stringArray, null, dimpermArray) : this.env.addPerm(null, stringArray, dimpermArray);
        abstract0.permuteDimensions(manager, dimpermArray[0]);
        return new Abstract1(environment, abstract0);
    }

    public void expand(Manager manager, String string, String[] stringArray) throws ApronException {
        this.abs.expand(manager, this.env.dimOfVar(string), stringArray.length);
        Dimperm[] dimpermArray = new Dimperm[1];
        this.env = this.env.isInt(string) ? this.env.addPerm(stringArray, null, dimpermArray) : this.env.addPerm(null, stringArray, dimpermArray);
        this.abs.permuteDimensions(manager, dimpermArray[0]);
    }

    public Abstract1 foldCopy(Manager manager, String[] stringArray) throws ApronException {
        int[] nArray = this.makeDimArray(stringArray);
        Arrays.sort(nArray);
        String[] stringArray2 = new String[]{this.env.varOfDim(nArray[0])};
        String[] stringArray3 = new String[]{stringArray[0]};
        Environment environment = this.env.remove(stringArray);
        environment = this.env.isInt(stringArray2[0]) ? environment.add(stringArray2, null) : environment.add(null, stringArray2);
        Abstract1 abstract1 = new Abstract1(environment, this.abs.foldCopy(manager, nArray));
        if (!stringArray2[0].equals(stringArray3[0])) {
            abstract1.rename(manager, stringArray2, stringArray3);
        }
        return abstract1;
    }

    public void fold(Manager manager, String[] stringArray) throws ApronException {
        int[] nArray = this.makeDimArray(stringArray);
        Arrays.sort(nArray);
        String[] stringArray2 = new String[]{this.env.varOfDim(nArray[0])};
        String[] stringArray3 = new String[]{stringArray[0]};
        this.env = this.env.isInt(stringArray2[0]) ? this.env.remove(stringArray).add(stringArray2, null) : this.env.remove(stringArray).add(null, stringArray2);
        this.abs.fold(manager, nArray);
        if (!stringArray2[0].equals(stringArray3[0])) {
            this.rename(manager, stringArray2, stringArray3);
        }
    }

    public Abstract1 widening(Manager manager, Abstract1 abstract1) throws ApronException {
        this.checkEnv(abstract1.env);
        return new Abstract1(this.env, this.abs.widening(manager, abstract1.abs));
    }

    public Abstract1 wideningThreshold(Manager manager, Abstract1 abstract1, Lincons1[] lincons1Array) throws ApronException {
        this.checkEnv(abstract1.env);
        return new Abstract1(this.env, this.abs.wideningThreshold(manager, abstract1.abs, this.makeLincons0Array(lincons1Array)));
    }

    public Abstract1 closureCopy(Manager manager) throws ApronException {
        return new Abstract1(this.env, this.abs.closureCopy(manager));
    }

    public void closure(Manager manager) throws ApronException {
        this.abs.closure(manager);
    }

    public byte[] serialize(Manager manager) throws ApronException {
        return this.abs.serialize(manager);
    }

    public static Abstract1 deserialize(Manager manager, Environment environment, byte[] byArray) throws ApronException {
        return new Abstract1(environment, Abstract0.deserialize(manager, byArray));
    }
}

