/*
 * Decompiled with CFR 0.152.
 */
import gdsl.BareFrontend;
import gdsl.Frontend;
import gdsl.Gdsl;
import gdsl.HeapExpiredException;
import gdsl.ResourceUnavailableException;
import gdsl.arch.ArchId;
import gdsl.decoder.Decoder;
import gdsl.decoder.NativeInstruction;
import gdsl.rreil.DefaultRReilBuilder;
import gdsl.rreil.IRReilCollection;
import gdsl.rreil.statement.IStatement;
import gdsl.translator.OptimizationOptions;
import gdsl.translator.TranslatedBlock;
import gdsl.translator.Translator;
import java.nio.ByteBuffer;
import org.junit.Test;

public class GdslTest {
    private ByteBuffer buffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)-61);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)-61);
        byteBuffer.position(0);
        return byteBuffer;
    }

    private Frontend frontendFromListEnv() {
        Frontend[] frontendArray;
        for (Frontend frontend : frontendArray = Gdsl.getFrontends()) {
            System.out.println("Frontend: " + frontend);
        }
        return frontendArray[0];
    }

    private Frontend frontendFromListBase() {
        Frontend[] frontendArray;
        for (Frontend frontend : frontendArray = Gdsl.getFrontends("/home/jucs/projects/gdsl-toolkit/lib")) {
            System.out.println("Frontend: " + frontend);
        }
        return frontendArray[0];
    }

    private Frontend frontend() {
        return new BareFrontend(ArchId.X86);
    }

    private void block(Gdsl gdsl) {
        Translator translator = new Translator(gdsl, new DefaultRReilBuilder());
        TranslatedBlock translatedBlock = translator.translateOptimizeBlock(gdsl.getBuffer().limit() - gdsl.getBuffer().position(), OptimizationOptions.PRESERVE_EVERYWHERE.config());
        System.out.println(translatedBlock);
    }

    private void single(Gdsl gdsl) {
        Decoder decoder = new Decoder(gdsl);
        NativeInstruction nativeInstruction = decoder.decodeOne();
        System.out.println(nativeInstruction);
        for (int i = 0; i < nativeInstruction.operands(); ++i) {
            System.out.println("\tOperand " + i + ": " + nativeInstruction.operandToString(i));
            System.out.println("\tOperandType " + i + ": " + (Object)((Object)nativeInstruction.operandType(i)));
        }
        Translator translator = new Translator(gdsl, new DefaultRReilBuilder());
        IRReilCollection<IStatement> iRReilCollection = translator.translate(nativeInstruction);
        System.out.println(iRReilCollection);
    }

    @Test
    public void testBlock() {
        System.out.println("testBlock()");
        Gdsl gdsl = new Gdsl(this.frontend());
        gdsl.setCode(this.buffer(), 0L, 0L);
        this.block(gdsl);
    }

    @Test
    public void testSingle() {
        System.out.println("testSingle()");
        Gdsl gdsl = new Gdsl(this.frontendFromListEnv());
        gdsl.setCode(this.buffer(), 0L, 0L);
        this.single(gdsl);
    }

    @Test
    public void testBlockSingleOneFrontend() {
        System.out.println("testBlockSingleOneFrontend()");
        Frontend frontend = this.frontendFromListBase();
        Gdsl gdsl = new Gdsl(frontend);
        gdsl.setCode(this.buffer(), 0L, 0L);
        this.block(gdsl);
        Gdsl gdsl2 = new Gdsl(frontend);
        gdsl2.setCode(this.buffer(), 0L, 0L);
        this.single(gdsl2);
    }

    @Test(expected=ResourceUnavailableException.class)
    public void testBlockDestroyedFrontend() {
        System.out.println("testBlockDestroyedFrontend()");
        Frontend frontend = this.frontendFromListBase();
        Gdsl gdsl = new Gdsl(frontend);
        frontend.free();
        gdsl.setCode(this.buffer(), 0L, 0L);
        Translator translator = new Translator(gdsl, new DefaultRReilBuilder());
        TranslatedBlock translatedBlock = translator.translateOptimizeBlock(gdsl.getBuffer().limit() - gdsl.getBuffer().position(), OptimizationOptions.PRESERVE_EVERYWHERE.config());
        System.out.println(translatedBlock);
    }

    @Test(expected=HeapExpiredException.class)
    public void testBlockDestroyedHeap() {
        System.out.println("testBlockDestroyedGdsl()");
        Frontend frontend = this.frontendFromListBase();
        Gdsl gdsl = new Gdsl(frontend);
        gdsl.setCode(this.buffer(), 0L, 0L);
        Translator translator = new Translator(gdsl, new DefaultRReilBuilder());
        TranslatedBlock translatedBlock = translator.translateOptimizeBlock(gdsl.getBuffer().limit() - gdsl.getBuffer().position(), OptimizationOptions.PRESERVE_EVERYWHERE.config());
        gdsl.free();
        System.out.println(translatedBlock);
    }
}

