/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import ui.KeyHandler;

public class KeyBindings
implements KeyEventDispatcher {
    protected Map bindings = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String description, KeyHandler handler) {
        KeyBindings keyBindings = this;
        synchronized (keyBindings) {
            this.bindings.put(description, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchKeyEvent(KeyEvent ev) {
        StringBuffer description = new StringBuffer();
        if (ev.getModifiers() != 0) {
            description.append(KeyBindings.getKeyModifiers(ev));
        }
        description.append(KeyBindings.getKeyText(ev));
        KeyBindings keyBindings = this;
        synchronized (keyBindings) {
            if (this.bindings.containsKey(description.toString())) {
                ev.consume();
                if (ev.getID() != 401) {
                    return false;
                }
                SwingUtilities.invokeLater(new ExecuteBinding(description.toString(), (KeyHandler)this.bindings.get(description.toString())));
                return true;
            }
        }
        return false;
    }

    private static String getKeyModifiers(KeyEvent ev) {
        StringBuffer modifiers = new StringBuffer();
        if (ev.isShiftDown()) {
            modifiers.append("Shift+");
        }
        if (ev.isControlDown()) {
            modifiers.append("Ctrl+");
        }
        if (ev.isAltDown()) {
            modifiers.append("Alt+");
        }
        if (ev.isMetaDown()) {
            modifiers.append("Meta+");
        }
        return modifiers.toString();
    }

    private static String getKeyText(KeyEvent ev) {
        switch (ev.getKeyCode()) {
            case 30: {
                return "Accept";
            }
            case 192: {
                return "Back_Quote";
            }
            case 8: {
                return "Backspace";
            }
            case 20: {
                return "Caps_Lock";
            }
            case 12: {
                return "Clear";
            }
            case 28: {
                return "Convert";
            }
            case 127: {
                return "Delete";
            }
            case 40: {
                return "Down";
            }
            case 35: {
                return "End";
            }
            case 10: {
                return "Enter";
            }
            case 27: {
                return "Escape";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 24: {
                return "Final";
            }
            case 156: {
                return "Help";
            }
            case 36: {
                return "Home";
            }
            case 155: {
                return "Insert";
            }
            case 37: {
                return "Left";
            }
            case 144: {
                return "Num_Lock";
            }
            case 106: {
                return "NumPad_*";
            }
            case 521: {
                return "NumPad_+";
            }
            case 44: {
                return "NumPad_,";
            }
            case 109: {
                return "NumPad_-";
            }
            case 46: {
                return "Period";
            }
            case 47: {
                return "NumPad_/";
            }
            case 34: {
                return "Page_Down";
            }
            case 33: {
                return "Page_Up";
            }
            case 19: {
                return "Pause";
            }
            case 154: {
                return "Print_Screen";
            }
            case 222: {
                return "Quote";
            }
            case 39: {
                return "Right";
            }
            case 145: {
                return "Scroll_Lock";
            }
            case 32: {
                return "Space";
            }
            case 9: {
                return "Tab";
            }
            case 38: {
                return "Up";
            }
        }
        return KeyEvent.getKeyText(ev.getKeyCode());
    }

    private static class ExecuteBinding
    implements Runnable {
        protected String binding;
        protected KeyHandler handler;

        public ExecuteBinding(String b, KeyHandler h) {
            this.binding = b;
            this.handler = h;
        }

        @Override
        public void run() {
            this.handler.key_pressed(this.binding);
        }
    }
}

